/*
 * Decompiled with CFR 0.152.
 */
package mariot7.xlfoodmod.config;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import mariot7.xlfoodmod.config.Configurationxlfoodmod;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RightClickHarvesting {
    public static final RightClickHarvesting instance = new RightClickHarvesting();

    private RightClickHarvesting() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!Configurationxlfoodmod.rightclickharvesting.rightclickharvest) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        IBlockState blockState = event.getWorld().func_180495_p(event.getPos());
        if (!(blockState.func_177230_c() instanceof BlockCrops) && !(blockState.func_177230_c() instanceof BlockNetherWart)) {
            return;
        }
        RightClickHarvesting.disableItemBlock(event);
        if ((blockState.func_177230_c() instanceof BlockCrops || blockState.func_177230_c() instanceof BlockNetherWart) && (event.getEntityPlayer().func_184614_ca().func_150998_b(blockState) || event.getEntityPlayer().func_184592_cb().func_150998_b(blockState))) {
            return;
        }
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        if (RightClickHarvesting.canHarvestCrops(blockState, event.getWorld(), event.getPos())) {
            if (!event.getWorld().field_72995_K) {
                RightClickHarvesting.harvestCrops(blockState, event.getEntityPlayer(), event.getWorld(), event.getPos());
            }
            event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
        } else if (RightClickHarvesting.canHarvestNetherWart(blockState)) {
            if (!event.getWorld().field_72995_K) {
                RightClickHarvesting.harvestNetherWart(blockState, event.getEntityPlayer(), event.getWorld(), event.getPos());
            }
            event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    private static boolean canHarvestCrops(IBlockState plantBlockState, World world, BlockPos pos) {
        if (!(plantBlockState.func_177230_c() instanceof BlockCrops)) {
            return false;
        }
        BlockCrops crops = (BlockCrops)plantBlockState.func_177230_c();
        IBlockState soilBlockState = world.func_180495_p(pos.func_177977_b());
        if (!soilBlockState.func_177230_c().canSustainPlant(soilBlockState, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)crops)) {
            return false;
        }
        return crops.func_185525_y(plantBlockState);
    }

    private static void harvestCrops(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        BlockCrops crops = (BlockCrops)blockState.func_177230_c();
        ItemStack stack = player.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        List drops = crops.getDrops((IBlockAccess)world, blockPos, blockState, fortune);
        Item seedItem = crops.func_180660_a(blockState, world.field_73012_v, fortune);
        if (seedItem != null) {
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                ItemStack drop = (ItemStack)iterator.next();
                if (drop.func_77973_b() == seedItem && !(crops instanceof BlockCarrot) && !(crops instanceof BlockPotato)) continue;
                iterator.remove();
                break;
            }
        }
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)blockPos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        world.func_175656_a(blockPos, crops.func_185528_e(0));
        for (ItemStack drop : drops) {
            RightClickHarvesting.dropItem(drop, world, blockPos);
        }
    }

    private static boolean canHarvestNetherWart(IBlockState blockState) {
        if (!(blockState.func_177230_c() instanceof BlockNetherWart)) {
            return false;
        }
        BlockNetherWart netherWart = (BlockNetherWart)blockState.func_177230_c();
        return (Integer)blockState.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= (Integer)Iterables.getLast((Iterable)BlockNetherWart.field_176486_a.func_177700_c());
    }

    private static void harvestNetherWart(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        BlockNetherWart netherWart = (BlockNetherWart)blockState.func_177230_c();
        ItemStack stack = player.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        List drops = netherWart.getDrops((IBlockAccess)world, blockPos, blockState, fortune);
        Item seedItem = netherWart.func_180660_a(blockState, world.field_73012_v, fortune);
        if (seedItem != null) {
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                ItemStack drop = (ItemStack)iterator.next();
                if (drop.func_77973_b() == seedItem) continue;
                iterator.remove();
                break;
            }
        }
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)blockPos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        world.func_175656_a(blockPos, blockState.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(0)));
        for (ItemStack drop : drops) {
            RightClickHarvesting.dropItem(drop, world, blockPos);
        }
    }

    private static void dropItem(ItemStack itemStack, World world, BlockPos pos) {
        if (world.restoringBlockSnapshots || world.field_72995_K) {
            return;
        }
        float f = 0.5f;
        double d0 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        double d1 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        double d2 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }

    private static void disableItemBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemBlock) {
            event.setUseItem(Event.Result.DENY);
        }
    }
}

