/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesItemStackOredictionary
implements IPrototypedIngredientAlternatives<ItemStack, Integer> {
    public static final Serializer SERIALIZER = new Serializer();
    private static final LoadingCache<String, List<ItemStack>> CACHE_OREDICT;
    private final List<String> keys;
    private final Integer matchCondition;
    private final long quantity;

    public PrototypedIngredientAlternativesItemStackOredictionary(List<String> keys, Integer matchCondition, long quantity) {
        this.keys = keys;
        this.matchCondition = matchCondition;
        this.quantity = quantity;
    }

    public static List<ItemStack> getItemStackVariants(ItemStack itemStack) {
        NonNullList output = NonNullList.func_191196_a();
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, output);
        } else {
            output.add((Object)itemStack);
        }
        return output;
    }

    @Override
    public Collection<IPrototypedIngredient<ItemStack, Integer>> getAlternatives() {
        IIngredientMatcher<ItemStack, Integer> matcher = IngredientComponent.ITEMSTACK.getMatcher();
        return this.keys.stream().flatMap(key -> {
            try {
                return ((List)CACHE_OREDICT.get(key)).stream();
            }
            catch (ExecutionException e) {
                return Stream.empty();
            }
        }).flatMap(itemStack -> PrototypedIngredientAlternativesItemStackOredictionary.getItemStackVariants(itemStack).stream()).map(itemStack -> matcher.withQuantity((ItemStack)itemStack, this.getQuantity())).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, this.matchCondition)).collect(Collectors.toList());
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof IPrototypedIngredientAlternatives && this.getAlternatives().equals(((IPrototypedIngredientAlternatives)obj).getAlternatives());
    }

    public int hashCode() {
        int inputsHash = 333;
        for (IPrototypedIngredient<ItemStack, Integer> value : this.getAlternatives()) {
            inputsHash |= value.hashCode();
        }
        return 0x4D3 | inputsHash << 2;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.getAlternatives().toString() + "]";
    }

    static {
        SERIALIZERS.put((byte)1, (Object)SERIALIZER);
        CACHE_OREDICT = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<ItemStack>>(){

            public List<ItemStack> load(String key) throws Exception {
                return OreDictionary.getOres((String)key);
            }
        });
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesItemStackOredictionary> {
        @Override
        public byte getId() {
            return 1;
        }

        @Override
        public <T, M> NBTBase serialize(IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesItemStackOredictionary alternatives) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList keys = new NBTTagList();
            for (String key : alternatives.keys) {
                keys.func_74742_a((NBTBase)new NBTTagString(key));
            }
            tag.func_74782_a("keys", (NBTBase)keys);
            tag.func_74768_a("match", alternatives.matchCondition.intValue());
            tag.func_74772_a("quantity", alternatives.quantity);
            return tag;
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesItemStackOredictionary deserialize(IngredientComponent<T, M> ingredientComponent, NBTBase tag) {
            NBTTagCompound tagCompound = (NBTTagCompound)tag;
            if (!tagCompound.func_74764_b("keys")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain valid keys");
            }
            if (!tagCompound.func_74764_b("match")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain a valid match");
            }
            NBTTagList keysTag = tagCompound.func_150295_c("keys", 8);
            ArrayList keys = Lists.newArrayList();
            for (NBTBase key : keysTag) {
                keys.add(((NBTTagString)key).func_150285_a_());
            }
            int matchCondition = tagCompound.func_74762_e("match");
            long quantity = tagCompound.func_74764_b("quantity") ? tagCompound.func_74763_f("quantity") : 1L;
            return new PrototypedIngredientAlternativesItemStackOredictionary(keys, matchCondition, quantity);
        }
    }
}

