/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox;

import net.darkhax.bookshelf.network.NetworkHandler;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.parabox.block.BlockParabox;
import net.darkhax.parabox.block.ItemBlockParabox;
import net.darkhax.parabox.block.TileEntityParabox;
import net.darkhax.parabox.block.v2.BlockParaboxV2;
import net.darkhax.parabox.block.v2.TileEntityParaboxV2;
import net.darkhax.parabox.gui.GuiHandler;
import net.darkhax.parabox.network.PacketActivate;
import net.darkhax.parabox.network.PacketConfirmReset;
import net.darkhax.parabox.network.PacketRefreshGui;
import net.darkhax.parabox.proxy.Proxy;
import net.darkhax.parabox.util.BlacklistedFileUtils;
import net.darkhax.parabox.util.ParaboxItemManager;
import net.darkhax.parabox.util.WorldSpaceTimeManager;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="parabox", name="Parabox", version="2.0.0", dependencies="required-after:bookshelf;required-after:prestige", certificateFingerprint="@FINGERPRINT@", acceptedMinecraftVersions="[1.12.2]")
public class Parabox {
    public static final String MODID = "parabox";
    public static final String NAME = "Parabox";
    public static final Logger LOG = LogManager.getLogger((String)"Parabox");
    public static final RegistryHelper REGISTRY = new RegistryHelper("parabox").enableAutoRegistration().setTab(CreativeTabs.field_78026_f);
    public static final NetworkHandler NETWORK = new NetworkHandler("parabox");
    @Mod.Instance(value="parabox")
    public static Parabox instance;
    @SidedProxy(clientSide="net.darkhax.parabox.proxy.ClientProxy", serverSide="net.darkhax.parabox.proxy.Proxy")
    public static Proxy proxy;
    static Configuration config;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        NETWORK.register(PacketActivate.class, Side.SERVER);
        NETWORK.register(PacketConfirmReset.class, Side.SERVER);
        NETWORK.register(PacketRefreshGui.class, Side.CLIENT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        BlockParabox block = new BlockParabox();
        REGISTRY.registerBlock((Block)block, (ItemBlock)new ItemBlockParabox((Block)block), MODID);
        GameRegistry.registerTileEntity(TileEntityParabox.class, (ResourceLocation)block.getRegistryName());
        block = new BlockParaboxV2();
        REGISTRY.registerBlock((Block)block, (ItemBlock)new ItemBlockParabox((Block)block), "empowered_parabox");
        GameRegistry.registerTileEntity(TileEntityParaboxV2.class, (ResourceLocation)block.getRegistryName());
        config = new Configuration(event.getSuggestedConfigurationFile());
        for (String s : config.getStringList("Backup Blacklist", "general", new String[]{"playerdata", "advancements", "level.dat"}, "The names of files/folders that will not be restored by a state backup.")) {
            BlacklistedFileUtils.IGNORED.add(s);
        }
        TileEntityParabox.rfPerTick = config.getInt("RF/t", "general", 400, 1, Integer.MAX_VALUE, "Power usage factor per cycle.");
        TileEntityParabox.cycleTime = config.getInt("Cycle Time", "general", 12000, 1, Integer.MAX_VALUE, "Tick time for a single cycle.");
        TileEntityParabox.updateMessages = config.getBoolean("Update Messages", "general", true, "If parabox broadcasts when an item is received.");
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ParaboxItemManager.readConfigs(config);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        ParaboxItemManager.load();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        WorldSpaceTimeManager.onGameInstanceStart();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        WorldSpaceTimeManager.onGameInstanceClose();
    }

    public static void sendMessage(TextFormatting color, String text, Object ... args) {
        MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (s != null) {
            args = Parabox.fixBlockPos(args);
            TextComponentTranslation translation = new TextComponentTranslation(text, args);
            translation.func_150256_b().func_150238_a(color);
            s.func_184103_al().func_148544_a((ITextComponent)translation, false);
        }
    }

    public static void sendMessage(EntityPlayer player, TextFormatting color, String text, Object ... args) {
        if (!player.field_70170_p.field_72995_K) {
            args = Parabox.fixBlockPos(args);
            TextComponentTranslation translation = new TextComponentTranslation(text, args);
            translation.func_150256_b().func_150238_a(color);
            player.func_146105_b((ITextComponent)translation, false);
        }
    }

    static Object[] fixBlockPos(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)args[i];
            args[i] = String.format("(%d, %d, %d)", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return args;
    }

    public static String ticksToTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static WorldServer overworld() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
    }
}

