/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.block;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.parabox.Parabox;
import net.darkhax.parabox.handler.EnergyHandlerParabox;
import net.darkhax.parabox.handler.ItemHandlerParabox;
import net.darkhax.parabox.handler.VotingHandler;
import net.darkhax.parabox.util.ParaboxItemManager;
import net.darkhax.parabox.util.ParaboxUserData;
import net.darkhax.parabox.util.SpeedFactor;
import net.darkhax.parabox.util.WorldSpaceTimeManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityParabox
extends TileEntityBasicTickable {
    public static int cycleTime = 12000;
    public static int rfPerTick = 400;
    public static float cycleFactor = 2.0f;
    public static NumberFormat format = NumberFormat.getNumberInstance(Locale.getDefault());
    public static boolean updateMessages = true;
    protected boolean active = false;
    protected double cycleTimeLeft = 0.0;
    protected int points = 0;
    protected int ticksOnline = 0;
    protected int power = 0;
    protected VotingHandler voter = new VotingHandler(this);
    protected EnergyHandlerParabox energyHandler = new EnergyHandlerParabox(rfPerTick * 2, rfPerTick * 2);
    protected ItemHandlerParabox itemHandler = new ItemHandlerParabox(this);

    public void onEntityUpdate() {
        if (this.field_145850_b.field_72995_K || !this.active) {
            return;
        }
        if (!(WorldSpaceTimeManager.getWorldData() != null && WorldSpaceTimeManager.getWorldData().getBackupFile().exists() || !this.active || WorldSpaceTimeManager.isSaving() || WorldSpaceTimeManager.requireSaving())) {
            this.deactivate();
        }
        ++this.ticksOnline;
        if (this.ticksOnline < 0) {
            this.ticksOnline = 0;
        }
        this.power = this.energyHandler.getEnergyStored();
        if (this.ticksOnline % 20 == 0) {
            this.sync();
        }
        this.cycleTimeLeft -= this.getTicksPerTick();
        this.energyHandler.setEnergy(0);
        if (this.cycleTimeLeft <= 0.0) {
            ++this.points;
            for (Map.Entry<UUID, ParaboxUserData> data : WorldSpaceTimeManager.getWorldData().getUserData()) {
                data.getValue().setPoints(this.points);
            }
            WorldSpaceTimeManager.saveCustomWorldData();
            Parabox.sendMessage(TextFormatting.LIGHT_PURPLE, "info.parabox.update.daily", this.getRFTNeeded());
            this.cycleTimeLeft = this.getCycleTime();
            this.energyHandler.updateValues(this.getRFTNeeded() * 2);
            this.itemHandler.randomizeTarget();
        }
    }

    public void activate() {
        this.active = true;
        WorldSpaceTimeManager.initiateWorldBackup();
        this.points = 0;
        this.cycleTimeLeft = this.getCycleTime();
        this.ticksOnline = 0;
        this.energyHandler.updateValues(this.getRFTNeeded() * 2);
        this.itemHandler.randomizeTarget();
        this.sync();
    }

    public void deactivate() {
        this.active = false;
        this.points = 0;
        for (Map.Entry<UUID, ParaboxUserData> data : WorldSpaceTimeManager.getWorldData().getUserData()) {
            data.getValue().setPoints(0);
        }
        WorldSpaceTimeManager.saveCustomWorldData();
        WorldSpaceTimeManager.handleFailState();
    }

    public ItemStack genRandomItem() {
        Random rand = new Random();
        rand.setSeed((long)this.ticksOnline ^ (long)this.field_174879_c.func_177952_p() * rand.nextLong());
        return ParaboxItemManager.CRAFTING_ITEMS.get(rand.nextInt(ParaboxItemManager.CRAFTING_ITEMS.size()));
    }

    public void provideItem(ItemStack stack) {
        this.cycleTimeLeft -= 1200.0;
        String oldName = this.itemHandler.getTarget().func_82833_r();
        this.itemHandler.randomizeTarget();
        if (updateMessages) {
            Parabox.sendMessage(TextFormatting.GOLD, "info.parabox.update.item", oldName, this.itemHandler.getTarget().func_82833_r());
        }
    }

    public List<String> getInfo(List<String> entries, EntityPlayer player) {
        if (this.active) {
            entries.add(I18n.func_135052_a((String)"parabox.status.power", (Object[])new Object[]{format.format(this.getPower())}));
            entries.add(I18n.func_135052_a((String)"parabox.status.target", (Object[])new Object[]{format.format(this.getRFTNeeded() / 2), format.format(this.getRFTNeeded() * 2)}));
            entries.add(I18n.func_135052_a((String)"parabox.status.item", (Object[])new Object[]{this.itemHandler.getTarget().func_82833_r()}));
            entries.add(I18n.func_135052_a((String)"parabox.status.speed", (Object[])new Object[]{format.format(this.getTicksPerTick() * 100.0)}));
            entries.add(I18n.func_135052_a((String)"parabox.status.cycle", (Object[])new Object[]{Parabox.ticksToTime(this.getRemainingTicks())}));
            entries.add(I18n.func_135052_a((String)"parabox.status.points", (Object[])new Object[]{this.points}));
        } else {
            entries.add(I18n.func_135052_a((String)"parabox.status.offline", (Object[])new Object[0]));
        }
        return entries;
    }

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74768_a("StoredPower", this.energyHandler.getEnergyStored());
        dataTag.func_74780_a("RemainingTicks", this.cycleTimeLeft);
        dataTag.func_74772_a("Points", (long)this.points);
        dataTag.func_74757_a("Active", this.active);
        dataTag.func_74782_a("Item", (NBTBase)this.itemHandler.getTarget().func_77955_b(new NBTTagCompound()));
        dataTag.func_74768_a("Energy", this.power);
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.energyHandler.setEnergy(dataTag.func_74762_e("StoredPower"));
        this.cycleTimeLeft = dataTag.func_74769_h("RemainingTicks");
        this.points = dataTag.func_74762_e("Points");
        this.active = dataTag.func_74767_n("Active");
        this.itemHandler.setTarget(new ItemStack(dataTag.func_74775_l("Item")));
        this.energyHandler.updateValues(this.getRFTNeeded() * 2);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.energyHandler.setEnergy(dataTag.func_74762_e("Energy"));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.isActive() && (capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.isActive() && capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyHandler);
        }
        if (this.isActive() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getRFTNeeded() {
        return this.points == 0 ? rfPerTick : TileEntityParabox.floor((float)(rfPerTick * this.points) * cycleFactor);
    }

    public int getRemainingTicks() {
        return TileEntityParabox.floor(this.cycleTimeLeft);
    }

    public static int floor(double f) {
        return MathHelper.func_76128_c((double)f);
    }

    public IEnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getPower() {
        return this.energyHandler.getEnergyStored();
    }

    public int getGeneratedPoints() {
        return this.points;
    }

    public ItemStack getTarget() {
        return this.itemHandler.getTarget();
    }

    public VotingHandler getVoter() {
        return this.voter;
    }

    public double getCycleTime() {
        return cycleTime;
    }

    public double getTicksPerTick() {
        return SpeedFactor.getForPower(this, this.energyHandler.getEnergyStored()).getTicksPerTick();
    }
}

