/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.block.v2;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.darkhax.parabox.Parabox;
import net.darkhax.parabox.block.TileEntityParabox;
import net.darkhax.parabox.util.ParaboxItemManager;
import net.darkhax.parabox.util.ParaboxUserData;
import net.darkhax.parabox.util.WorldSpaceTimeManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class TileEntityParaboxV2
extends TileEntityParabox {
    double itemFactor = 1.0;

    @Override
    public void onEntityUpdate() {
        if (this.field_145850_b.field_72995_K || !this.active) {
            return;
        }
        if (!(WorldSpaceTimeManager.getWorldData() != null && WorldSpaceTimeManager.getWorldData().getBackupFile().exists() || !this.active || WorldSpaceTimeManager.isSaving() || WorldSpaceTimeManager.requireSaving())) {
            this.deactivate();
        }
        ++this.ticksOnline;
        if (this.ticksOnline < 0) {
            this.ticksOnline = 0;
        }
        this.power = this.energyHandler.getEnergyStored();
        if (this.ticksOnline % 20 == 0) {
            this.sync();
        }
        this.cycleTimeLeft -= Math.min(1.0, this.getTicksPerTick());
        this.itemFactor = Math.max(1.0, this.getTicksPerTick());
        this.energyHandler.setEnergy(0);
        if (this.itemFactor > 1.0) {
            this.itemFactor *= 1.25;
        }
        if (this.cycleTimeLeft <= 0.0) {
            this.points += 3;
            for (Map.Entry<UUID, ParaboxUserData> data : WorldSpaceTimeManager.getWorldData().getUserData()) {
                data.getValue().setPoints(this.points);
            }
            WorldSpaceTimeManager.saveCustomWorldData();
            Parabox.sendMessage(TextFormatting.LIGHT_PURPLE, "info.parabox.emp.update.daily", format.format(this.getRFTNeeded()), format.format(this.getCycleTime() / 1200.0));
            this.cycleTimeLeft = this.getCycleTime();
            this.energyHandler.updateValues(this.getRFTNeeded() * 2);
            this.itemHandler.randomizeTarget();
        }
    }

    @Override
    public ItemStack genRandomItem() {
        Random rand = new Random();
        rand.setSeed((long)this.ticksOnline ^ (long)this.field_145850_b.field_73012_v.nextInt(2500) * rand.nextLong());
        return ParaboxItemManager.EMPOWERED_ITEMS.get(rand.nextInt(ParaboxItemManager.EMPOWERED_ITEMS.size()));
    }

    @Override
    public void provideItem(ItemStack stack) {
        this.cycleTimeLeft -= 2400.0 * this.itemFactor;
        String oldName = this.itemHandler.getTarget().func_82833_r();
        this.itemHandler.randomizeTarget();
        if (updateMessages) {
            Parabox.sendMessage(TextFormatting.GOLD, "info.parabox.emp.update.item", oldName, format.format(2400.0 * this.itemFactor / 1200.0), this.itemHandler.getTarget().func_82833_r());
        }
    }

    @Override
    public double getCycleTime() {
        return super.getCycleTime() * 2.0 + (double)(2400 * (this.points / 3));
    }

    @Override
    public int getRFTNeeded() {
        return 3 * (this.points == 0 ? rfPerTick : TileEntityParaboxV2.floor(0.33 * (double)rfPerTick * (double)this.points * (double)cycleFactor));
    }

    @Override
    public List<String> getInfo(List<String> entries, EntityPlayer player) {
        if (this.active) {
            entries.add(I18n.func_135052_a((String)"parabox.status.power", (Object[])new Object[]{format.format(this.getPower())}));
            entries.add(I18n.func_135052_a((String)"parabox.status.target", (Object[])new Object[]{format.format(this.getRFTNeeded() / 2), format.format(this.getRFTNeeded() * 2)}));
            entries.add(I18n.func_135052_a((String)"parabox.status.item", (Object[])new Object[]{this.itemHandler.getTarget().func_82833_r()}));
            entries.add(I18n.func_135052_a((String)"parabox.status.emp.speed", (Object[])new Object[]{format.format(Math.min(1.0, this.getTicksPerTick()) * 100.0), format.format(this.itemFactor * 100.0)}));
            entries.add(I18n.func_135052_a((String)"parabox.status.cycle", (Object[])new Object[]{Parabox.ticksToTime(this.getRemainingTicks())}));
            entries.add(I18n.func_135052_a((String)"parabox.status.points", (Object[])new Object[]{this.points}));
        } else {
            entries.add(I18n.func_135052_a((String)"parabox.status.offline", (Object[])new Object[0]));
        }
        return entries;
    }

    @Override
    public void writeNBT(NBTTagCompound dataTag) {
        super.writeNBT(dataTag);
        dataTag.func_74780_a("ItemFactor", this.itemFactor);
    }

    @Override
    public void readNBT(NBTTagCompound dataTag) {
        super.readNBT(dataTag);
        this.itemFactor = dataTag.func_74769_h("ItemFactor");
    }
}

