/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.parabox.Parabox;
import net.darkhax.parabox.block.TileEntityParabox;
import net.darkhax.parabox.network.PacketActivate;
import net.darkhax.parabox.network.PacketConfirmReset;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiParabox
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("parabox", "textures/gui/parabox-background.png");
    private static final int xSize = 176;
    private static final int ySize = 115;
    private static final String[] SPINNER = new String[]{"|", "/", "-", "\\"};
    private final TileEntityParabox tile;
    private final EntityPlayer user;
    private int loadTime;
    private int startX;
    private int startY;
    private boolean active;
    private GuiButton statusButton;
    private GuiButton confirmationButton;

    public GuiParabox(TileEntityParabox tile, EntityPlayer user) {
        this.tile = tile;
        this.user = user;
        this.active = tile.isActive();
    }

    public void func_73866_w_() {
        this.startX = (this.field_146294_l - 176) / 2;
        this.startY = (this.field_146295_m - 115) / 2;
        this.field_146292_n.clear();
        this.loadTime = MathsUtils.nextIntInclusive((int)1, (int)4);
        this.statusButton = new GuiButton(0, this.startX + 14, this.startY + 89, 60, 20, I18n.func_135052_a((String)("parabox.button." + (this.active ? "deactivate" : "activate")), (Object[])new Object[0]));
        this.confirmationButton = new GuiButton(1, this.startX + 176 - 74, this.startY + 89, 60, 20, I18n.func_135052_a((String)"parabox.button.loop.off", (Object[])new Object[0]));
        this.field_146292_n.add(this.statusButton);
        this.field_146292_n.add(this.confirmationButton);
        this.confirmationButton.field_146124_l = this.active && this.tile.getGeneratedPoints() > 0;
        this.confirmationButton.field_146125_m = this.active;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.statusButton) {
            Parabox.NETWORK.sendToServer((IMessage)new PacketActivate(this.tile.func_174877_v()));
            MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (s != null && !s.func_71262_S()) {
                this.active = !this.active;
            }
        } else if (button == this.confirmationButton) {
            Parabox.NETWORK.sendToServer((IMessage)new PacketConfirmReset(this.tile.func_174877_v()));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawBackgroundImage();
        int worldTicks = this.field_146297_k.field_71439_g.field_70173_aa;
        if (this.loadTime > 0) {
            this.func_73731_b(this.field_146289_q, SPINNER[worldTicks % 12 / 3], this.startX + 10, this.startY + 12, 0xFFFFFF);
            if (worldTicks % 20 == 0) {
                --this.loadTime;
            }
        } else {
            int lineNum = 0;
            for (String line : this.tile.getInfo(new ArrayList<String>(), this.user)) {
                int offset = this.field_146289_q.field_78288_b * lineNum + 2 * lineNum;
                this.func_73731_b(this.field_146289_q, line, this.startX + 10, this.startY + 12 + offset, 0xFFFFFF);
                ++lineNum;
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.statusButton.func_146115_a() && this.statusButton.field_146124_l) {
            this.func_146279_a(I18n.func_135052_a((String)("parabox.tip." + (this.active ? "deactivate" : "activate")), (Object[])new Object[0]), mouseX, mouseY + this.field_146289_q.field_78288_b);
        } else if (this.confirmationButton.func_146115_a() && this.confirmationButton.field_146124_l) {
            this.func_146279_a(I18n.func_135052_a((String)"parabox.tip.loop.off", (Object[])new Object[0]), mouseX, mouseY + this.field_146289_q.field_78288_b);
        }
        if (this.active) {
            this.confirmationButton.field_146124_l = this.tile.getGeneratedPoints() > 0;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawBackgroundImage() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - 176) / 2;
        int j = (this.field_146295_m - 115) / 2;
        this.func_73729_b(i, j, 0, 0, 176, 115);
    }
}

