/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.handler;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.darkhax.parabox.Parabox;
import net.darkhax.parabox.block.TileEntityParabox;
import net.darkhax.parabox.util.WorldSpaceTimeManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class VotingHandler {
    protected TileEntityParabox box;
    protected Set<UUID> activators = new HashSet<UUID>();
    protected Set<UUID> deactivators = new HashSet<UUID>();
    protected Set<UUID> collapsers = new HashSet<UUID>();

    public VotingHandler(TileEntityParabox box) {
        this.box = box;
    }

    public void voteActivate(EntityPlayer voter) {
        this.activators.add(voter.func_146103_bH().getId());
        Parabox.sendMessage(TextFormatting.RED, "parabox.status.active_vote", voter.func_145748_c_());
        if (this.hasEveryoneVoted(this.activators)) {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.vote_success", new Object[0]);
            this.box.activate();
            this.activators.clear();
        } else {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.more_votes", new Object[0]);
        }
    }

    public void voteDeactivate(EntityPlayer voter) {
        this.deactivators.add(voter.func_146103_bH().getId());
        Parabox.sendMessage(TextFormatting.RED, "parabox.status.deactivate_vote", voter.func_145748_c_());
        if (this.hasEveryoneVoted(this.deactivators)) {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.vote_success", new Object[0]);
            this.box.deactivate();
            this.deactivators.clear();
        } else {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.more_votes", new Object[0]);
        }
    }

    public void voteCollapse(EntityPlayer voter) {
        this.collapsers.add(voter.func_146103_bH().getId());
        Parabox.sendMessage(TextFormatting.RED, "parabox.status.collapse_vote", voter.func_145748_c_());
        if (this.hasEveryoneVoted(this.collapsers)) {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.vote_success", new Object[0]);
            WorldSpaceTimeManager.triggerCollapse((WorldServer)this.box.func_145831_w());
            this.collapsers.clear();
        } else {
            Parabox.sendMessage(TextFormatting.RED, "parabox.status.more_votes", new Object[0]);
        }
    }

    protected boolean hasEveryoneVoted(Set<UUID> voters) {
        PlayerList pList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        Set filtered = voters.stream().filter(id -> pList.func_177451_a(id) != null).collect(Collectors.toSet());
        return filtered.size() == pList.func_181057_v().size();
    }
}

