/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import net.darkhax.parabox.util.ZipUtils;
import org.apache.commons.io.FileUtils;

public class BlacklistedFileUtils {
    public static final List<String> IGNORED = new ArrayList<String>();
    public static FileFilter filter = f -> !IGNORED.contains(f.getName());

    public static void delete(File worldDir) throws IOException {
        for (File f : worldDir.listFiles(filter)) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            f.delete();
        }
    }

    public static void unzipFolder(File File2, File zipDestinationFolder) {
        try (ZipUtils.MyZipFile zipFile = new ZipUtils.MyZipFile(File2);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                if (BlacklistedFileUtils.isBlacklisted(name)) continue;
                if (zipEntry.isDirectory()) {
                    File newDir;
                    if (name.endsWith("/") || name.endsWith("\\")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if ((newDir = new File(zipDestinationFolder, name)).exists() || newDir.mkdirs()) continue;
                    throw new RuntimeException("Creation of target dir was failed, target dir: " + zipDestinationFolder + ", entity: " + name);
                }
                File destinationFile = ZipUtils.createTargetFile(zipDestinationFolder, name);
                if (destinationFile == null) {
                    throw new RuntimeException("Creation of target file was failed, target dir: " + zipDestinationFolder + ", entity: " + name);
                }
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(zipEntry), (File)destinationFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unzip failed:", e);
        }
    }

    public static boolean isBlacklisted(String path) {
        for (String s : IGNORED) {
            if (!path.contains(s)) continue;
            return true;
        }
        return false;
    }
}

