/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.darkhax.parabox.Parabox;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ParaboxItemManager {
    public static final List<ItemStack> CRAFTING_BLACKLIST = new ArrayList<ItemStack>();
    public static final List<String> CRAFTING_MOD_BLACKLIST = new ArrayList<String>();
    public static final List<ItemStack> CRAFTING_ITEMS = new ArrayList<ItemStack>(30000);
    public static final List<ItemStack> EMPOWERED_ITEMS = new ArrayList<ItemStack>(500);
    public static boolean dumpCrafting = false;
    public static boolean dumpEmpowered = false;

    public static void readConfigs(Configuration c) {
        ParaboxItemManager.loadCraftingConfigs(c);
        ParaboxItemManager.loadEmpoweredConfigs(c);
        if (c.hasChanged()) {
            c.save();
        }
    }

    public static void load() {
        ParaboxItemManager.loadCraftingList();
        ParaboxItemManager.loadEmpoweredList();
    }

    static boolean isAllowed(ItemStack stack) {
        if (CRAFTING_MOD_BLACKLIST.contains(stack.func_77973_b().getRegistryName().func_110624_b())) {
            return false;
        }
        for (ItemStack s : CRAFTING_BLACKLIST) {
            if (!OreDictionary.itemMatches((ItemStack)s, (ItemStack)stack, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    static void loadCraftingList() {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (recipe.func_192399_d()) continue;
            CRAFTING_ITEMS.add(recipe.func_77571_b().func_77946_l());
        }
        List stacks = CRAFTING_ITEMS.stream().filter(ParaboxItemManager::isAllowed).collect(Collectors.toList());
        CRAFTING_ITEMS.clear();
        CRAFTING_ITEMS.addAll(stacks);
        CRAFTING_MOD_BLACKLIST.clear();
        CRAFTING_BLACKLIST.clear();
        CRAFTING_ITEMS.removeIf(ItemStack::func_190926_b);
        if (dumpCrafting) {
            Parabox.LOG.info("Starting crafting list dump!");
            CRAFTING_ITEMS.forEach(s -> Parabox.LOG.info("Entry: {}", (Object)(s.func_77973_b().getRegistryName() + ":" + s.func_77960_j())));
            Parabox.LOG.info("Total Entries: {}", (Object)CRAFTING_ITEMS.size());
        }
    }

    static void loadCraftingConfigs(Configuration c) {
        String[] modids = c.getStringList("Crafting Banned Mods", "items", new String[0], "Mod ids that are not allowed in the parabox crafting item list.");
        String[] items = c.getStringList("Crafting Banned Items", "items", new String[0], "Items that are not allowed in the parabox crafting item list.  Format modid:name:meta");
        CRAFTING_MOD_BLACKLIST.addAll(Arrays.asList(modids));
        for (String s : items) {
            String[] split = s.split(":");
            if (split.length != 3) {
                Parabox.LOG.error("Invalid configuration entry {} in crafting blacklist will be ignored.", (Object)s);
                continue;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException ex) {
                Parabox.LOG.error("Invalid configuration entry {} in crafting blacklist will be ignored.", (Object)s);
                continue;
            }
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
            if (i == null || i == Items.field_190931_a) {
                Parabox.LOG.error("Invalid configuration entry {} in crafting blacklist will be ignored.", (Object)s);
                continue;
            }
            CRAFTING_BLACKLIST.add(new ItemStack(i, 1, meta));
        }
        dumpCrafting = c.getBoolean("Dump Crafting List", "items", false, "If the crafting list (post-filter) is dumped to the log.");
    }

    static void loadEmpoweredList() {
        if (EMPOWERED_ITEMS.isEmpty()) {
            Parabox.LOG.info("Empowered item list is empty!  This is not good.  Substituting with balanced objects so we don't crash later.");
            EMPOWERED_ITEMS.add(new ItemStack(Items.field_151119_aD));
            EMPOWERED_ITEMS.add(new ItemStack(Blocks.field_150435_aG));
        }
        EMPOWERED_ITEMS.removeIf(ItemStack::func_190926_b);
        if (dumpEmpowered) {
            Parabox.LOG.info("Starting empowered list dump!");
            EMPOWERED_ITEMS.forEach(s -> Parabox.LOG.info("Entry: {}", (Object)(s.func_77973_b().getRegistryName() + ":" + s.func_77960_j())));
            Parabox.LOG.info("Total Entries: {}", (Object)EMPOWERED_ITEMS.size());
        }
    }

    static void loadEmpoweredConfigs(Configuration c) {
        String[] items;
        String[] def = new String[]{"minecraft:diamond_block:0", "minecraft:emerald_block:0", "parabox:parabox:0", "minecraft:acacia_boat:0"};
        for (String s : items = c.getStringList("Empowered Parabox Items", "items", def, "The list of valid items for the Empowered Parabox.  Format modid:name:meta")) {
            String[] split = s.split(":");
            if (split.length != 3) {
                Parabox.LOG.error("Invalid configuration entry {} in empowered whitelist will be ignored.", (Object)s);
                continue;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException ex) {
                Parabox.LOG.error("Invalid configuration entry {} in empowered whitelist will be ignored.", (Object)s);
                continue;
            }
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
            if (i == null || i == Items.field_190931_a) {
                Parabox.LOG.error("Invalid configuration entry {} in empowered whitelist will be ignored.", (Object)s);
                continue;
            }
            EMPOWERED_ITEMS.add(new ItemStack(i, 1, meta));
        }
        dumpEmpowered = c.getBoolean("Dump Empowered List", "items", false, "If the empowered list (post-filter) is dumped to the log.");
    }
}

