/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.darkhax.parabox.util.ParaboxUserData;
import net.darkhax.parabox.util.WorldHelper;
import net.darkhax.parabox.util.WorldSpaceTimeManager;
import net.minecraft.util.math.BlockPos;

public class ParaboxWorldData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Expose
    private UUID worldId;
    @Expose
    private boolean shouldDelete = false;
    @Expose
    private Map<UUID, ParaboxUserData> data = new HashMap<UUID, ParaboxUserData>();
    @Expose
    private long parabox;

    public boolean isShouldDelete() {
        return this.shouldDelete;
    }

    public void setShouldDelete(boolean shouldDelete) {
        this.shouldDelete = shouldDelete;
    }

    public ParaboxUserData getOrCreateData(UUID userId) {
        ParaboxUserData data = this.data.get(userId);
        if (data == null) {
            this.data.put(userId, new ParaboxUserData());
            WorldSpaceTimeManager.saveCustomWorldData();
        }
        return data;
    }

    public BlockPos getParabox() {
        return BlockPos.func_177969_a((long)this.parabox);
    }

    public void setParabox(BlockPos pos) {
        this.parabox = pos.func_177986_g();
    }

    public Set<Map.Entry<UUID, ParaboxUserData>> getUserData() {
        return this.data.entrySet();
    }

    private ParaboxWorldData(UUID id) {
        this.worldId = id;
    }

    public UUID getWorldId() {
        return this.worldId;
    }

    public File getBackupFile() {
        return new File(WorldHelper.getBackupDir(), this.getWorldId().toString().toLowerCase() + ".zip");
    }

    public void save(File worldFile) {
        File dataFile = new File(worldFile, "parabox.json");
        try (FileWriter writer = new FileWriter(dataFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParaboxWorldData getData(File worldFile) {
        File dataFile = new File(worldFile, "parabox.json");
        if (!dataFile.exists()) {
            new ParaboxWorldData(UUID.randomUUID()).save(worldFile);
        }
        try (FileReader reader = new FileReader(dataFile);){
            ParaboxWorldData wData = null;
            try {
                wData = (ParaboxWorldData)GSON.fromJson((Reader)reader, ParaboxWorldData.class);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            if (wData == null) {
                wData = new ParaboxWorldData(UUID.randomUUID());
            }
            if (wData.data == null) {
                wData.data = new HashMap<UUID, ParaboxUserData>();
            }
            ParaboxWorldData paraboxWorldData = wData;
            return paraboxWorldData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

