/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import net.darkhax.parabox.block.TileEntityParabox;

public enum SpeedFactor {
    OFF(0.0f, 0.5f, 0.0),
    SLOWEST(0.5f, 0.7f, 0.33),
    SLOW(0.7f, 0.9f, 0.66),
    NORMAL(0.9f, 1.1f, 1.0),
    FAST(1.1f, 1.5f, 1.1),
    FASTEST(1.5f, 2.0f, 1.2);

    float min;
    float max;
    double ticksPerTick;

    private SpeedFactor(float min, float max, double ticksPerTick) {
        this.min = min;
        this.max = max;
        this.ticksPerTick = ticksPerTick;
    }

    public boolean isInRange(TileEntityParabox pbx, int rft) {
        return this.min * (float)pbx.getRFTNeeded() <= (float)rft && this.max * (float)pbx.getRFTNeeded() > (float)rft;
    }

    public double getTicksPerTick() {
        return this.ticksPerTick;
    }

    public static SpeedFactor getForPower(TileEntityParabox pbx, int rft) {
        for (SpeedFactor f : SpeedFactor.values()) {
            if (!f.isInRange(pbx, rft)) continue;
            return f;
        }
        return FASTEST;
    }
}

