/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import com.jarhax.prestige.data.GlobalPrestigeData;
import com.jarhax.prestige.data.PlayerData;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.darkhax.parabox.Parabox;
import net.darkhax.parabox.block.BlockParabox;
import net.darkhax.parabox.block.TileEntityParabox;
import net.darkhax.parabox.util.BlacklistedFileUtils;
import net.darkhax.parabox.util.ParaboxUserData;
import net.darkhax.parabox.util.ParaboxWorldData;
import net.darkhax.parabox.util.WorldHelper;
import net.darkhax.parabox.util.ZipUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class WorldSpaceTimeManager {
    private static File currentSaveRootDirectory;
    private static ParaboxWorldData currentWorldData;
    private static boolean[] oldSaveStates;
    private static boolean isSaving;
    private static boolean requireSaving;
    private static boolean started;

    public static boolean isSaving() {
        return isSaving;
    }

    public static boolean requireSaving() {
        return requireSaving;
    }

    public static ParaboxWorldData getWorldData() {
        return currentWorldData;
    }

    public static void onGameInstanceStart() {
        Parabox.LOG.info("Initializing Parabox world data.");
        currentSaveRootDirectory = DimensionManager.getCurrentSaveRootDirectory();
        currentWorldData = ParaboxWorldData.getData(currentSaveRootDirectory);
        started = true;
    }

    public static void onGameInstanceClose() {
        if (!started) {
            return;
        }
        Parabox.LOG.info("Saving Parabox world data.");
        WorldSpaceTimeManager.getWorldData().save(currentSaveRootDirectory);
        if (WorldSpaceTimeManager.getWorldData().isShouldDelete()) {
            Parabox.LOG.info("World has been marked for deletion. Starting world loop process.");
            try {
                Parabox.LOG.info("Deleting the current world file.");
                BlacklistedFileUtils.delete(currentSaveRootDirectory);
                Parabox.LOG.info("Restoring the initial world backup.");
                BlacklistedFileUtils.unzipFolder(WorldSpaceTimeManager.getWorldData().getBackupFile(), currentSaveRootDirectory.getParentFile());
                WorldSpaceTimeManager.getWorldData().getBackupFile().delete();
                for (Map.Entry<UUID, ParaboxUserData> entry : WorldSpaceTimeManager.getWorldData().getUserData()) {
                    PlayerData prestigeData = GlobalPrestigeData.getPlayerData((UUID)entry.getKey());
                    prestigeData.addPrestige((long)entry.getValue().getPoints());
                    GlobalPrestigeData.save((PlayerData)prestigeData);
                }
            }
            catch (IOException e) {
                Parabox.LOG.catching((Throwable)e);
            }
        }
        currentSaveRootDirectory = null;
        currentWorldData = null;
        started = false;
    }

    public static void initiateWorldBackup() {
        if (!WorldSpaceTimeManager.getWorldData().getBackupFile().exists() && !isSaving) {
            Parabox.sendMessage(TextFormatting.LIGHT_PURPLE, "info.parabox.backup", new Object[0]);
            requireSaving = true;
        }
    }

    public static void triggerCollapse(WorldServer server) {
        for (EntityPlayerMP player : server.func_73046_m().func_184103_al().func_181057_v()) {
            player.field_71135_a.func_194028_b((ITextComponent)new TextComponentString("The world is collapsing!"));
            Parabox.proxy.onGameShutdown(server.func_72860_G().func_75765_b().getName());
        }
        if (!WorldSpaceTimeManager.getWorldData().getBackupFile().exists()) {
            Parabox.LOG.warn("Attempted to do a world reset, but no world backup found. This mod will not work as intended if the backup file {} is not restored.", (Object)WorldSpaceTimeManager.getWorldData().getBackupFile().getPath());
            return;
        }
        WorldSpaceTimeManager.getWorldData().setShouldDelete(true);
        WorldHelper.shutdown();
    }

    private static void disableSaving() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Parabox.LOG.info("Temporarily disabling world saving.");
        server.func_184103_al().func_72389_g();
        oldSaveStates = new boolean[server.field_71305_c.length];
        for (int i = 0; i < oldSaveStates.length; ++i) {
            WorldServer worldServer = server.field_71305_c[i];
            if (worldServer == null) continue;
            WorldSpaceTimeManager.oldSaveStates[i] = worldServer.field_73058_d;
            try {
                worldServer.func_73044_a(true, null);
                worldServer.func_73041_k();
            }
            catch (MinecraftException ex) {
                Parabox.LOG.warn("Failed to save world.");
                Parabox.LOG.catching((Throwable)ex);
            }
            worldServer.field_73058_d = true;
        }
    }

    private static void restoreSaving() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        int l = Math.min(oldSaveStates.length, server.field_71305_c.length);
        Parabox.LOG.info("Restoring world saving states.");
        for (int i = 0; i < l; ++i) {
            WorldServer worldServer = server.field_71305_c[i];
            if (worldServer == null) continue;
            worldServer.field_73058_d = oldSaveStates[i];
        }
        if (server.func_184103_al() != null) {
            server.func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("parabox.status.backup", new Object[0]));
        }
    }

    public static void saveCustomWorldData() {
        if (WorldSpaceTimeManager.getWorldData() != null && currentSaveRootDirectory != null) {
            WorldSpaceTimeManager.getWorldData().save(currentSaveRootDirectory);
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (requireSaving && !isSaving) {
            try {
                WorldSpaceTimeManager.disableSaving();
                isSaving = true;
                requireSaving = false;
                WorldHelper.saveWorld();
                Parabox.LOG.info("Creating snapshot of world at " + WorldSpaceTimeManager.getWorldData().getBackupFile().getName());
                ZipUtils.createZip(currentSaveRootDirectory, WorldSpaceTimeManager.getWorldData().getBackupFile());
                Parabox.LOG.info("Snapshot created succesffully.");
                WorldSpaceTimeManager.getWorldData().save(currentSaveRootDirectory);
            }
            catch (IOException iOException) {}
        } else if (!requireSaving && isSaving) {
            WorldSpaceTimeManager.restoreSaving();
            isSaving = false;
        }
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        WorldSpaceTimeManager.getWorldData().getOrCreateData(event.player.func_146103_bH().getId());
        FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].field_147482_g.forEach(e -> {
            if (e instanceof TileEntityParabox && ((TileEntityParabox)((Object)e)).isActive()) {
                Parabox.sendMessage(event.player, TextFormatting.GOLD, "info.parabox.active", e.func_174877_v());
            }
        });
    }

    public static void handleFailState() {
        boolean noActiveUsers = true;
        TileEntityParabox box = BlockParabox.getParabox((World)Parabox.overworld(), WorldSpaceTimeManager.getWorldData().getParabox());
        if (box != null && box.isActive()) {
            noActiveUsers = false;
        }
        if (noActiveUsers && WorldSpaceTimeManager.getWorldData().getBackupFile().exists()) {
            WorldSpaceTimeManager.getWorldData().getBackupFile().delete();
            PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            if (playerList != null) {
                playerList.func_148539_a((ITextComponent)new TextComponentTranslation("parabox.status.backup.reset", new Object[0]));
            }
        }
    }

    static {
        isSaving = false;
        requireSaving = false;
        started = false;
    }
}

