/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.parabox.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.darkhax.parabox.util.BlacklistedFileUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void createZip(File directory, File zipFile) throws IOException {
        try (FileOutputStream fOut = new FileOutputStream(zipFile);
             BufferedOutputStream bOut = new BufferedOutputStream(fOut);
             ZipOutputStream tOut = new ZipOutputStream(bOut);){
            ZipUtils.addFileToZip(tOut, directory, "");
        }
    }

    private static void addFileToZip(ZipOutputStream zOut, File f, String base) throws IOException {
        String entryName = base + f.getName();
        String string = entryName = f.isDirectory() && !entryName.endsWith("/") ? entryName + "/" : entryName;
        if (BlacklistedFileUtils.isBlacklisted(entryName)) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        if (f.isFile()) {
            zipEntry.setSize(f.length());
        }
        zipEntry.setTime(f.lastModified());
        zOut.putNextEntry(zipEntry);
        if (f.isFile()) {
            try (FileInputStream fInputStream = new FileInputStream(f);){
                IOUtils.copy((InputStream)fInputStream, (OutputStream)zOut);
                zOut.closeEntry();
            }
        } else {
            zOut.closeEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    ZipUtils.addFileToZip(zOut, child.getAbsoluteFile(), entryName + "/");
                }
            }
        }
    }

    public static void extractZip(String Path2, String destinationPath) {
        File File2 = new File(Path2);
        try {
            File unzipDestFolder = new File(destinationPath);
            ZipUtils.unzipFolder(File2, unzipDestFolder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unzipFolder(File File2, File zipDestinationFolder) {
        try (MyZipFile zipFile = new MyZipFile(File2);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    File newDir;
                    if (name.endsWith("/") || name.endsWith("\\")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if ((newDir = new File(zipDestinationFolder, name)).mkdirs()) continue;
                    throw new RuntimeException("Creation of target dir was failed, target dir: " + zipDestinationFolder + ", entity: " + name);
                }
                File destinationFile = ZipUtils.createTargetFile(zipDestinationFolder, name);
                if (destinationFile == null) {
                    throw new RuntimeException("Creation of target file was failed, target dir: " + zipDestinationFolder + ", entity: " + name);
                }
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(zipEntry), (File)destinationFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unzip failed:", e);
        }
    }

    public static File createTargetFile(File zipDestinationFolder, String name) {
        File parentFolder;
        File destinationFile = new File(zipDestinationFolder, name);
        if (name.endsWith(File.separator)) {
            if (!destinationFile.isDirectory() && !destinationFile.mkdirs()) {
                throw new RuntimeException("Error creating temp directory:" + destinationFile.getPath());
            }
            return destinationFile;
        }
        if (name.indexOf(File.separatorChar) != -1 && !(parentFolder = destinationFile.getParentFile()).isDirectory() && !parentFolder.mkdirs()) {
            throw new RuntimeException("Error creating temp directory:" + parentFolder.getPath());
        }
        return destinationFile;
    }

    public static class MyZipFile
    extends ZipFile
    implements Cloneable,
    AutoCloseable {
        public MyZipFile(File f) throws IOException {
            super(f);
        }
    }
}

