/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.world;

import com.kashdeya.tinyprogressions.handlers.ConfigHandler;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class PlantGen
implements IWorldGenerator {
    public void generate(Random random, int chunk_X, int chunk_Z, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunk_X * 16 + random.nextInt(8);
        int z = chunk_Z * 16 + random.nextInt(8);
        BlockPos blockPos = world.func_175645_m(new BlockPos(x, 0, z));
        BlockPos chunkPos = new BlockPos(x, 0, z);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if ((BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) && ConfigHandler.old_reed) {
            this.generatePlant(TechBlocks.old_reed, world, blockPos, random);
        }
        if (!(BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) || !ConfigHandler.ExtraPlantGen || !ConfigHandler.ExtraJuices && !ConfigHandler.ExtraJuicesBottles)) {
            switch (random.nextInt(4)) {
                case 0: {
                    this.generateBerryPlant(TechBlocks.blueberry_bush, world, blockPos, random);
                    break;
                }
                case 1: {
                    this.generateBerryPlant(TechBlocks.raspberry_bush, world, blockPos, random);
                    break;
                }
                case 2: {
                    this.generateBerryPlant(TechBlocks.maloberry_bush, world, blockPos, random);
                    break;
                }
                case 3: {
                    this.generateBerryPlant(TechBlocks.blackberry_bush, world, blockPos, random);
                }
            }
        }
    }

    private void generatePlant(Block block, World world, BlockPos pos, Random random) {
        for (int tryNum = 0; tryNum < 2; ++tryNum) {
            int posZ;
            int posY;
            int posX = pos.func_177958_n() + random.nextInt(16);
            BlockPos newPos = new BlockPos(posX, posY = pos.func_177956_o(), posZ = pos.func_177952_p() + random.nextInt(16));
            if (!block.func_176196_c(world, newPos)) continue;
            world.func_180501_a(newPos, block.func_176223_P(), 2);
        }
    }

    private void generateBerryPlant(Block block, World world, BlockPos pos, Random random) {
        int posZ;
        int posY;
        int posX;
        BlockPos newPos;
        if (random.nextFloat() < (float)ConfigHandler.berryPlantRarity / 10.0f && block.func_176196_c(world, newPos = new BlockPos(posX = pos.func_177958_n() + random.nextInt(16), posY = pos.func_177956_o(), posZ = pos.func_177952_p() + random.nextInt(16)))) {
            world.func_180501_a(newPos, block.func_176223_P(), 2);
        }
    }
}

