/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.StatuesTab;
import com.shynieke.statues.compat.list.StatueLootList;
import com.shynieke.statues.compat.top.TOPCompat;
import com.shynieke.statues.config.StatuesConfigGen;
import com.shynieke.statues.entity.EntityStatueBat;
import com.shynieke.statues.handler.DespawnHandler;
import com.shynieke.statues.handler.DropHandler;
import com.shynieke.statues.handler.FishHandler;
import com.shynieke.statues.handler.MagicHandler;
import com.shynieke.statues.init.StatuesEntity;
import com.shynieke.statues.init.StatuesGuiHandler;
import com.shynieke.statues.init.StatuesHoliday;
import com.shynieke.statues.init.StatuesSounds;
import com.shynieke.statues.packets.StatuesPacketHandler;
import com.shynieke.statues.proxy.CommonProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="statues", name="Statues", version="0.8.9.2", acceptedMinecraftVersions="[1.12]", dependencies="before:crafttweaker;after:baubles;after:veinminer;after:theoneprobe;")
public class Statues {
    @Mod.Instance(value="statues")
    public static Statues instance;
    @SidedProxy(clientSide="com.shynieke.statues.proxy.ClientProxy", serverSide="com.shynieke.statues.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static StatuesTab tabStatues;
    public static final Map<String, GameProfile> GAMEPROFILE_CACHE;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        logger.info("Registering Statues Config");
        MinecraftForge.EVENT_BUS.register((Object)new StatuesConfigGen());
        logger.info("Registering Statues Sounds");
        StatuesSounds.registerSounds();
        logger.info("Registering Statues Entities");
        StatuesEntity.register();
        StatuesPacketHandler.registerWailaUpdatePacket();
        logger.info("Registering Statues Packets");
        StatuesPacketHandler.registerPackets();
        proxy.Preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (StatuesConfigGen.general.StatueBatSpawning) {
            for (Biome biome : Biome.field_185377_q) {
                biome.func_76747_a(EnumCreatureType.AMBIENT).add(new Biome.SpawnListEntry(EntityStatueBat.class, 4, 1, 2));
            }
            logger.info("Registered Statues Bat Spawn");
        }
        logger.info("Registering Statues Gui Handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new StatuesGuiHandler());
        if (StatuesConfigGen.events.halloweenSpawning) {
            StatuesHoliday.registerSpawning();
        }
        TOPCompat.register();
        logger.info("Initialize Statues Loot");
        StatueLootList.initializeStatueLoot();
        logger.info("Registering Statues Event Handlers");
        MinecraftForge.EVENT_BUS.register((Object)new DropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FishHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DespawnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MagicHandler());
        proxy.Init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.PostInit();
    }

    static {
        logger = LogManager.getLogger((String)"statues");
        tabStatues = new StatuesTab();
        GAMEPROFILE_CACHE = new HashMap<String, GameProfile>();
    }
}

