/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.list;

import com.shynieke.statues.compat.list.LootInfo;
import com.shynieke.statues.init.StatuesBlocks;
import com.shynieke.statues.init.StatuesItems;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StatueLootList {
    public static ArrayList<LootInfo> lootList = new ArrayList();
    public static LootInfo loot_info;

    public static void initializeStatueLoot() {
        StatueLootList.addLoot("baby_zombie", new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_191525_da), ItemStack.field_190927_a);
        StatueLootList.addLoot("blaze", new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151072_bj), ItemStack.field_190927_a);
        StatueLootList.addLoot("chicken", new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151076_bf), ItemStack.field_190927_a);
        StatueLootList.addLoot("chicken_jockey", new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151008_G), ItemStack.field_190927_a);
        StatueLootList.addLoot("king_cluck", new ItemStack((Item)StatuesItems.nugget), ItemStack.field_190927_a, new ItemStack(Items.field_151074_bl));
        StatueLootList.addLoot("cow", new ItemStack(Items.field_151082_bd), ItemStack.field_190927_a, new ItemStack(Items.field_151116_aA));
        StatueLootList.addLoot("creeper", new ItemStack(Items.field_151016_H), ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("enderman", new ItemStack(StatuesBlocks.pebble, 16), new ItemStack(Items.field_151079_bi), ItemStack.field_190927_a);
        StatueLootList.addLoot("flood", ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("ghast", new ItemStack(Items.field_151016_H), ItemStack.field_190927_a, new ItemStack(Items.field_151073_bk));
        StatueLootList.addLoot("guardian", new ItemStack(Items.field_151115_aP, 1, 0), new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_179563_cD));
        StatueLootList.addLoot("husk", new ItemStack(Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack(Items.field_151042_j));
        StatueLootList.addLoot("drowned", new ItemStack(Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack(Items.field_151043_k));
        StatueLootList.addLoot("magma_slime", new ItemStack(Items.field_151064_bs), ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("mooshroom", ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a);
        StatueLootList.addLoot("pig", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151147_al));
        StatueLootList.addLoot("rabbit", new ItemStack(Items.field_179555_bs), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179556_br));
        StatueLootList.addLoot("sheep", ItemStack.field_190927_a, new ItemStack(Items.field_179561_bm), ItemStack.field_190927_a);
        StatueLootList.addLoot("sheep_shaven", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_179561_bm));
        StatueLootList.addLoot("slime", ItemStack.field_190927_a, new ItemStack(Items.field_151123_aH), ItemStack.field_190927_a);
        StatueLootList.addLoot("snowgolem", new ItemStack(Items.field_151126_ay), ItemStack.field_190927_a, new ItemStack(Blocks.field_150423_aK));
        StatueLootList.addLoot("squid", ItemStack.field_190927_a, new ItemStack(Items.field_151100_aR, 1, 0), ItemStack.field_190927_a);
        StatueLootList.addLoot("villager", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151166_bC));
        StatueLootList.addLoot("witch", new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151069_bo));
        StatueLootList.addLoot("wasteland_pig", new ItemStack((Item)StatuesItems.tea), StatueLootList.getWastelandBlock(), ItemStack.field_190927_a);
        StatueLootList.addLoot("zombie", new ItemStack(Items.field_151078_bh), ItemStack.field_190927_a, new ItemStack(Items.field_151042_j));
        StatueLootList.addLoot("pufferfish", ItemStack.field_190927_a, new ItemStack(Items.field_151115_aP, 1, 3), ItemStack.field_190927_a);
        StatueLootList.addLoot("spider", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151070_bp), ItemStack.field_190927_a);
        StatueLootList.addLoot("evoker", ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_190929_cY));
        StatueLootList.addLoot("etho", new ItemStack((Item)StatuesItems.marshmallow), ItemStack.field_190927_a, ItemStack.field_190927_a);
    }

    public static ItemStack getWastelandBlock() {
        ItemStack wasteland = new ItemStack((Block)Blocks.field_150354_m).func_151001_c("\u00c2\u00a7dWasteland Block\u00c2\u00a7r");
        wasteland.func_77966_a(Enchantments.field_190940_C, 1);
        NBTTagCompound nbt = wasteland.func_77978_p();
        nbt.func_74768_a("HideFlags", 1);
        wasteland.func_77982_d(nbt);
        return wasteland;
    }

    public static ItemStack getFloodBucket() {
        ItemStack floodbucket = new ItemStack(Items.field_151131_as);
        floodbucket.func_151001_c("\u00c2\u00a79The Flood\u00c2\u00a7r");
        return floodbucket;
    }

    public static void addLoot(String statue, ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        loot_info = new LootInfo(stack1, stack2, stack3, statue);
        if (lootList.contains(loot_info)) {
            return;
        }
        lootList.add(loot_info);
    }

    public static void changeLoot(String statue, ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        for (LootInfo info : lootList) {
            if (!info.getStatue().equals(statue)) continue;
            info.setStack1(stack1);
            info.setStack2(stack2);
            info.setStack3(stack3);
        }
    }

    public static ArrayList<ItemStack> getStacksForStatue(String statue) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (LootInfo info : lootList) {
            if (info.getStatue() != statue) continue;
            stacks.add(0, info.getStack1());
            stacks.add(1, info.getStack2());
            stacks.add(2, info.getStack2());
            if (stacks.get(0) != info.getStack1()) {
                stacks.set(0, info.getStack1());
            }
            if (stacks.get(1) != info.getStack2()) {
                stacks.set(1, info.getStack2());
            }
            if (stacks.get(2) == info.getStack3()) continue;
            stacks.set(2, info.getStack3());
        }
        return stacks;
    }

    public static ArrayList<Block> getBlockForStatue(String statue) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (Block blocks : StatuesBlocks.BLOCKS) {
            String blockName = blocks.func_149739_a();
            if (!blockName.contains(statue.replace("_", "")) || !blockName.contains("t3") && !blockName.contains("t4") || blockList.contains(blocks)) continue;
            blockList.add(blocks);
        }
        return blockList;
    }
}

