/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.top;

import com.google.common.base.Function;
import com.mojang.authlib.GameProfile;
import com.shynieke.statues.tileentity.PlayerStatueTileEntity;
import com.shynieke.statues.tileentity.StatueTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TOPCompat {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.shynieke.statues.compat.top.TOPCompat$GetTheOneProbe");
    }

    public static final class StatuesInfo
    implements IProbeInfoProvider {
        public String getID() {
            return "statues";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            Block block = world.func_180495_p(data.getPos()).func_177230_c();
            if (te != null) {
                if (te instanceof StatueTileEntity) {
                    StatueTileEntity tile = (StatueTileEntity)te;
                    String blockName = block.getRegistryName().toString();
                    if (blockName.contains("t3") || blockName.contains("t4") || blockName.contains("t5")) {
                        int cooldown = tile.getCooldown();
                        int cooldownMax = tile.getCooldownMax();
                        boolean able = tile.isStatueAble();
                        int cooldownProgress = (int)((float)cooldown * 100.0f / (float)cooldownMax);
                        if (able) {
                            probeInfo.text(I18n.func_135052_a((String)"tooldown.statues.timer.finished", (Object[])new Object[0]));
                        }
                        if (!able) {
                            probeInfo.text(I18n.func_135052_a((String)"tooltip.statues.timer", (Object[])new Object[0]) + cooldownProgress + "%");
                        }
                    }
                } else if (te instanceof PlayerStatueTileEntity) {
                    PlayerStatueTileEntity tile = (PlayerStatueTileEntity)te;
                    GameProfile profile = tile.playerProfile;
                    String name = tile.func_70005_c_();
                    probeInfo.text(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.statues.player.info", (Object[])new Object[0]) + TextFormatting.GOLD + name);
                }
            }
        }
    }

    public static final class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public Void apply(ITheOneProbe input) {
            input.registerProvider((IProbeInfoProvider)new StatuesInfo());
            return null;
        }
    }
}

