/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.waila;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.compat.waila.StatueProgressInfo;
import com.shynieke.statues.init.StatuesBlocks;
import com.shynieke.statues.tileentity.PlayerStatueTileEntity;
import com.shynieke.statues.tileentity.StatueTileEntity;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@WailaPlugin
public class StatueTimerProvider
implements IWailaDataProvider,
IWailaPlugin {
    private static final String CONFIG_PLAYER_NAME = "statues.player.name";
    private static final String CONFIG_PLAYER_UUID = "statues.player.data";
    private static final String CONFIG_STATUE_TIMER = "statues.statue.timer";
    public static StatueProgressInfo info = null;

    public void register(IWailaRegistrar registrar) {
        for (Block block : StatuesBlocks.BLOCKS) {
            registrar.registerBodyProvider((IWailaDataProvider)this, block.getClass());
        }
        registrar.addConfig("Statues", CONFIG_PLAYER_NAME);
        registrar.addConfig("Statues", CONFIG_PLAYER_UUID, false);
        registrar.addConfig("Statues", CONFIG_STATUE_TIMER);
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile;
        TileEntity te = accessor.getTileEntity();
        if (te instanceof PlayerStatueTileEntity && !accessor.getTileEntity().func_145837_r()) {
            tile = (PlayerStatueTileEntity)te;
            GameProfile profile = tile.playerProfile;
            String name = tile.BlockName;
            if (config.getConfig(CONFIG_PLAYER_NAME) && profile != null && !accessor.getTileEntity().func_145837_r()) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.statues.player.info", (Object[])new Object[0]) + name);
            }
            if (config.getConfig(CONFIG_PLAYER_UUID) && profile != null && !accessor.getTileEntity().func_145837_r()) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.statues.player.info2", (Object[])new Object[0]) + profile.getId());
            }
        }
        if (te instanceof StatueTileEntity && !accessor.getTileEntity().func_145837_r()) {
            tile = (StatueTileEntity)te;
            String blockName = accessor.getBlock().getRegistryName().toString();
            if (blockName.contains("t3") || blockName.contains("t4")) {
                if (info != null) {
                    if (tile.func_174877_v().equals((Object)info.getPosition())) {
                        int cooldown = info.getCooldown();
                        int cooldownMax = info.getCooldownMax();
                        boolean able = info.isAble();
                        int cooldownProgress = (int)((float)cooldown * 100.0f / (float)cooldownMax);
                        if (config.getConfig(CONFIG_STATUE_TIMER) && !accessor.getTileEntity().func_145837_r()) {
                            if (able) {
                                tooltip.add(I18n.func_135052_a((String)"tooldown.statues.timer.finished", (Object[])new Object[0]));
                            }
                            if (!able) {
                                tooltip.add(I18n.func_135052_a((String)"tooltip.statues.timer", (Object[])new Object[0]) + cooldownProgress + "%");
                            }
                        }
                    } else {
                        tooltip = this.setStatueInfo((StatueTileEntity)tile, tooltip, accessor, config);
                    }
                } else {
                    tooltip = this.setStatueInfo((StatueTileEntity)tile, tooltip, accessor, config);
                }
            }
        }
        return tooltip;
    }

    public List<String> setStatueInfo(StatueTileEntity tile, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        int cooldown = tile.getCooldown();
        int cooldownMax = tile.getCooldownMax();
        boolean able = tile.isStatueAble();
        int cooldownProgress = (int)((float)cooldown * 100.0f / (float)cooldownMax);
        if (config.getConfig(CONFIG_STATUE_TIMER) && !accessor.getTileEntity().func_145837_r()) {
            if (able) {
                tooltip.add(I18n.func_135052_a((String)"tooldown.statues.timer.finished", (Object[])new Object[0]));
            }
            if (!able) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.statues.timer", (Object[])new Object[0]) + cooldownProgress + "%");
            }
        }
        return tooltip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }
}

