/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handler;

import com.shynieke.statues.config.StatuesConfigGen;
import com.shynieke.statues.init.StatuesBlocks;
import com.shynieke.statues.packets.StatuesAFKPacket;
import com.shynieke.statues.packets.StatuesPacketHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class FishHandler {
    public static final int maxTime = 2400;
    private int timeSinceKeyPressed;
    public static String afkKey = "statues:afk";

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && StatuesConfigGen.general.AquaticFishing) {
            double default_drop_chance = StatuesConfigGen.general.OldDropChance;
            if (!(player instanceof FakePlayer)) {
                EntityPlayerMP realPlayer = (EntityPlayerMP)event.getEntityPlayer();
                String[] LuckyPlayers2 = StatuesConfigGen.luckyplayers.lucky_players;
                if (StatuesConfigGen.othersettings.antiAfk) {
                    if (!realPlayer.getEntityData().func_74767_n(afkKey)) {
                        if (LuckyPlayers2.length != 0) {
                            for (int i = 0; i < LuckyPlayers2.length && LuckyPlayers2[i] != null; ++i) {
                                if (realPlayer.func_70005_c_().equals(LuckyPlayers2[i])) {
                                    // empty if block
                                }
                                default_drop_chance = StatuesConfigGen.general.OldDropChance / 4.0;
                            }
                        } else {
                            default_drop_chance = StatuesConfigGen.general.OldDropChance;
                        }
                        if (Math.random() < default_drop_chance) {
                            EntityFishHook hook = event.getHookEntity();
                            if (hook != null) {
                                EntityItem entityitem = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, new ItemStack(StatuesBlocks.pufferfish_statue[0]));
                                double d0 = hook.func_190619_l().field_70165_t - hook.field_70165_t;
                                double d1 = hook.func_190619_l().field_70163_u - hook.field_70163_u;
                                double d2 = hook.func_190619_l().field_70161_v - hook.field_70161_v;
                                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                                double d4 = 0.1;
                                entityitem.field_70159_w = d0 * 0.1;
                                entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                                entityitem.field_70179_y = d2 * 0.1;
                                hook.field_70170_p.func_72838_d((Entity)entityitem);
                            }
                            event.setCanceled(true);
                        }
                    }
                } else {
                    if (LuckyPlayers2.length != 0) {
                        for (int i = 0; i < LuckyPlayers2.length && LuckyPlayers2[i] != null; ++i) {
                            if (realPlayer.func_70005_c_().equals(LuckyPlayers2[i])) {
                                // empty if block
                            }
                            default_drop_chance = StatuesConfigGen.general.OldDropChance / 4.0;
                        }
                    } else {
                        default_drop_chance = StatuesConfigGen.general.OldDropChance;
                    }
                    if (Math.random() < default_drop_chance) {
                        EntityFishHook hook = event.getHookEntity();
                        if (hook != null) {
                            EntityItem entityitem = FishHandler.getFishedStatue(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v);
                            double d0 = hook.func_190619_l().field_70165_t - hook.field_70165_t;
                            double d1 = hook.func_190619_l().field_70163_u - hook.field_70163_u;
                            double d2 = hook.func_190619_l().field_70161_v - hook.field_70161_v;
                            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                            double d4 = 0.1;
                            entityitem.field_70159_w = d0 * 0.1;
                            entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                            entityitem.field_70179_y = d2 * 0.1;
                            hook.field_70170_p.func_72838_d((Entity)entityitem);
                        }
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    public static EntityItem getFishedStatue(World world, double x, double y, double z) {
        switch (world.field_73012_v.nextInt(8)) {
            default: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.pufferfish_statue[0]);
            }
            case 1: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.pufferfish_medium_statue[0]);
            }
            case 2: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.pufferfish_small_statue[0]);
            }
            case 3: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.drowned_statue[0]);
            }
            case 4: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.turtle_statue[0]);
            }
            case 5: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.cod_statue[0]);
            }
            case 6: {
                ItemStack itemStack = new ItemStack(StatuesBlocks.salmon_statue[0]);
            }
            case 7: 
        }
        ItemStack fishedStack = new ItemStack(StatuesBlocks.pufferfish_statue[0]);
        return new EntityItem(world, x, y, z, fishedStack);
    }

    public static void updateAfk(EntityPlayer player, boolean afk) {
        if (player.field_70170_p.field_73010_i.size() != 1) {
            if (afk) {
                player.getEntityData().func_74757_a(afkKey, true);
            } else {
                player.getEntityData().func_74757_a(afkKey, false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        World world = event.player.field_70170_p;
        List players = world.field_73010_i;
        if (players.size() == 1) {
            EntityPlayer lastPlayer = (EntityPlayer)players.get(0);
            lastPlayer.getEntityData().func_74757_a(afkKey, false);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.timeSinceKeyPressed;
            if (this.timeSinceKeyPressed >= 2400) {
                StatuesPacketHandler.INSTANCE.sendToServer((IMessage)new StatuesAFKPacket(true));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeystroke(InputEvent.KeyInputEvent event) {
        this.onPress();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeystroke(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        this.onPress();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMousePress(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButtonState()) {
            this.onPress();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMousePress(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButtonState() && event.getGui() != null) {
            this.onPress();
        }
    }

    private void onPress() {
        if (this.timeSinceKeyPressed >= 2400) {
            StatuesPacketHandler.INSTANCE.sendToServer((IMessage)new StatuesAFKPacket(false));
        }
        this.timeSinceKeyPressed = 0;
    }
}

