/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tileentity;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.blocks.Statues.BlockShulker_Statue;
import com.shynieke.statues.tileentity.container.ContainerShulkerStatue;
import com.shynieke.statues.tileentity.iStatueBehaviors;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ShulkerStatueTileEntity
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory,
iStatueBehaviors {
    private static final int[] SLOTS = new int[18];
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    private boolean hasBeenCleared;
    private int openCount;
    private float progress;
    private float progressOld;
    private boolean destroyedByCreativePlayer;
    private int tier = 3;
    private static FakePlayer fakeStatue = null;

    public void setTier(int tier) {
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount == 1 && this.tier == 3) {
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount <= 0 && this.tier == 3) {
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "statues:container.shulkerStatue";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerShulkerStatue(playerInventory, (IInventory)this, playerIn);
    }

    public String func_174875_k() {
        return "statues:shulker_statue";
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return !(Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof BlockShulker_Statue);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void func_73660_a() {
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.tier = compound.func_74762_e("StatueTier");
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.items, (boolean)false);
        }
        compound.func_74768_a("StatueTier", this.tier);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        if (!compound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(compound);
        }
        return compound;
    }

    public void func_174888_l() {
        this.hasBeenCleared = true;
        super.func_174888_l();
    }

    public boolean isCleared() {
        return this.hasBeenCleared;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 10, this.func_189517_E_());
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void setDestroyedByCreativePlayer(boolean p_190579_1_) {
        this.destroyedByCreativePlayer = p_190579_1_;
    }

    public boolean shouldDrop() {
        return !this.isDestroyedByCreativePlayer() || !this.func_191420_l() || this.func_145818_k_() || this.field_184284_m != null;
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    }

    public void PlaySound(SoundEvent Mobsound, BlockPos pos, World worldIn) {
        if (this.tier == 2 || this.tier == 3) {
            worldIn.func_184133_a(null, pos, Mobsound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void holidayCheck(Entity entity, World worldIn, BlockPos pos, boolean isChild) {
        int random;
        LocalDateTime now;
        if ((this.tier == 3 || this.tier == 4) && (now = LocalDateTime.now()).getMonth() == Month.OCTOBER && (random = this.field_145850_b.field_73012_v.nextInt(100)) < 1) {
            if (isChild && entity instanceof EntityMob) {
                EntityMob mob = (EntityMob)entity;
                mob.func_70631_g_();
                mob.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_72838_d((Entity)mob);
            } else {
                entity.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_72838_d(entity);
            }
        }
    }

    public static FakePlayer getFakePlayer() {
        if (fakeStatue == null) {
            fakeStatue = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(new UUID(123L, 132L), "Shulker Statue"));
        }
        return fakeStatue;
    }

    public void ShootBullet(BlockPos pos, World worldIn, EntityPlayer entity, EnumFacing.Axis facing) {
        EntityPlayer player = entity;
        FakePlayer fakePlayer = ShulkerStatueTileEntity.getFakePlayer();
        int random = worldIn.field_73012_v.nextInt(100);
        if (!(this.tier != 3 && this.tier != 4 || random >= 50 || worldIn.field_72995_K)) {
            EntityShulkerBullet bullet = new EntityShulkerBullet(worldIn, (EntityLivingBase)fakePlayer, (Entity)player, facing);
            bullet.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p());
            worldIn.func_72838_d((Entity)bullet);
            worldIn.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187789_eW, SoundCategory.NEUTRAL, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
        }
    }

    static {
        int i = 0;
        while (i < SLOTS.length) {
            ShulkerStatueTileEntity.SLOTS[i] = i++;
        }
    }
}

