/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tileentity;

import com.shynieke.statues.compat.list.StatueLootList;
import com.shynieke.statues.compat.waila.StatueTimerProvider;
import com.shynieke.statues.config.StatuesConfigGen;
import com.shynieke.statues.init.StatuesItems;
import com.shynieke.statues.init.StatuesSounds;
import com.shynieke.statues.items.ItemMarshmallow;
import com.shynieke.statues.items.ItemTea;
import com.shynieke.statues.packets.StatuesPacketHandler;
import com.shynieke.statues.packets.StatuesProgressMessage;
import com.shynieke.statues.tileentity.iStatueBehaviors;
import com.shynieke.statues.util.RandomLists;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StatueTileEntity
extends TileEntity
implements ITickable,
iStatueBehaviors {
    public int cooldown;
    public int cooldownMax;
    public boolean statueAble;
    private int tier;

    public StatueTileEntity() {
        this.tier = 2;
        this.cooldown = 0;
        this.cooldownMax = StatuesConfigGen.general.InteractionTimer * 20;
        this.statueAble = false;
    }

    public StatueTileEntity(int tier) {
        this.tier = tier;
        this.cooldown = 0;
        this.cooldownMax = StatuesConfigGen.general.InteractionTimer * 20;
        this.statueAble = false;
    }

    public int setTier(int theTier) {
        this.tier = theTier;
        return this.tier;
    }

    public int getTier() {
        return this.tier;
    }

    public void CampfireBehavior(World worldIn, BlockPos pos, EntityPlayer playerIn, @Nullable ItemStack stack1, @Nullable ItemStack stack2, @Nullable ItemStack stack3) {
        if (this.tier > 1) {
            if (this.isStatueAble()) {
                int random = this.field_145850_b.field_73012_v.nextInt(100);
                if (this.tier >= 3) {
                    if (random < 100 && stack1 != null && stack1 != ItemStack.field_190927_a) {
                        if (stack1.func_77973_b() instanceof ItemMarshmallow && this.tier == 3 || this.tier == 4) {
                            worldIn.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        }
                        playerIn.func_71019_a(stack1, true);
                    }
                    if (stack2 != null && stack2 != ItemStack.field_190927_a && random < 50) {
                        playerIn.func_71019_a(stack2, true);
                    }
                    if (stack3 != null && stack3 != ItemStack.field_190927_a && random < 10) {
                        playerIn.func_71019_a(stack3, true);
                    }
                    this.setStatueAble(false);
                }
            } else if (this.tier >= 2 && this.tier != 5) {
                this.PlaySound(RandomLists.getRandomCampfire(), pos, worldIn);
            }
        }
    }

    public void FakeMobs(Entity entity, World worldIn, BlockPos pos, boolean isChild) {
        int random;
        if (this.tier == 3 && (random = this.field_145850_b.field_73012_v.nextInt(100)) < 1) {
            if (isChild && entity instanceof EntityMob) {
                EntityMob mob = (EntityMob)entity;
                mob.func_70631_g_();
                mob.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_72838_d((Entity)mob);
            } else {
                entity.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                worldIn.func_72838_d(entity);
            }
        }
    }

    public void WastelandBehavior(World worldIn, BlockPos pos, EntityPlayer playerIn, @Nullable ItemStack stack1, @Nullable ItemStack stack2, @Nullable ItemStack stack3) {
        if (this.isStatueAble()) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier >= 3) {
                if (random < 100 && stack1 != null && stack1 != ItemStack.field_190927_a) {
                    if (stack1.func_77973_b() instanceof ItemTea && this.tier == 3 || this.tier == 4) {
                        worldIn.func_184133_a(null, pos, StatuesSounds.wasteland_tea, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    }
                    playerIn.func_71019_a(stack1, true);
                }
                if (stack2 != null && stack2 != ItemStack.field_190927_a && random < 50) {
                    playerIn.func_71019_a(stack2, true);
                }
                if (stack3 != null && stack3 != ItemStack.field_190927_a && random < 10) {
                    playerIn.func_71019_a(stack3, true);
                }
                this.setStatueAble(false);
            }
        } else if (this.tier >= 2 && this.tier != 5) {
            worldIn.func_184133_a(null, pos, RandomLists.getRandomWasteland(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void PlaySound(SoundEvent Mobsound, BlockPos pos, World worldIn) {
        if (this.tier >= 2 && this.tier != 5) {
            worldIn.func_184133_a(null, pos, Mobsound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void SendInfoMessage(EntityPlayer entity, World worldIn, BlockPos pos) {
        EntityPlayer player = entity;
        if (!this.field_145850_b.field_72995_K) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            String[] messages = StatuesConfigGen.messages.info_messages;
            String[] LuckyPlayers2 = StatuesConfigGen.luckyplayers.lucky_players;
            int idx = new Random().nextInt(messages.length);
            String randommessage = messages[idx];
            if (Loader.isModLoaded((String)"veinminer") && random < 20) {
                randommessage = "Did you know we have veinminer";
            } else if (LuckyPlayers2.length != 0 && random < 20) {
                for (int i = 0; i < LuckyPlayers2.length && LuckyPlayers2[i] != null; ++i) {
                    randommessage = "Luck is not on your side today";
                }
            } else {
                randommessage = messages[idx];
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation(randommessage, new Object[0]));
        }
    }

    public void GiveEffect(BlockPos pos, World worldIn, EntityPlayer entity, Potion effect) {
        if (this.isStatueAble()) {
            EntityPlayer player = entity;
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier >= 3 && random < 10 && !this.field_145850_b.field_72995_K && player.func_70660_b(effect) == null) {
                player.func_70690_d(new PotionEffect(effect, 400, 1, true, true));
            }
        }
    }

    public void ThrowPotion(BlockPos pos, World worldIn, EntityPlayer entity) {
        if (this.isStatueAble()) {
            EntityPlayer player = entity;
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier >= 3 && random < 10 && !this.field_145850_b.field_72995_K) {
                double d0 = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f;
                double d1 = entity.field_70165_t + entity.field_70159_w - (double)pos.func_177958_n();
                double d2 = d0 - (double)pos.func_177956_o();
                double d3 = entity.field_70161_v + entity.field_70179_y - (double)pos.func_177952_p();
                float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
                EntityPotion entitypotion = new EntityPotion(this.field_145850_b);
                entitypotion.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                entitypotion.func_184541_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)RandomLists.getRandomPotionType()));
                entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.25f, 6.0f);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187924_gx, SoundCategory.NEUTRAL, 1.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                this.field_145850_b.func_72838_d((Entity)entitypotion);
            }
        }
    }

    public void SpecialInteraction(boolean isCow, boolean isMooshroom, boolean isFlood, Block statue, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        EntityFireworkRocket firework = new EntityFireworkRocket(worldIn, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), this.getFirework(this.field_145850_b.field_73012_v));
        int random = this.field_145850_b.field_73012_v.nextInt(100);
        if (this.tier >= 3) {
            if (isCow && !worldIn.field_72995_K && stack.func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                    playerIn.func_71019_a(new ItemStack(Items.field_151117_aB), false);
                }
            }
            if (isMooshroom && !worldIn.field_72995_K && stack.func_77973_b() == Items.field_151054_z && !playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack((Item)StatuesItems.soup));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((Item)StatuesItems.soup))) {
                    playerIn.func_71019_a(new ItemStack((Item)StatuesItems.soup), false);
                }
            }
            if (isFlood) {
                if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151133_ar && !playerIn.field_71075_bZ.field_75098_d) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    stack.func_190918_g(1);
                    ItemStack floodbucket = StatueLootList.getFloodBucket();
                    if (stack.func_190926_b()) {
                        playerIn.func_184611_a(hand, floodbucket);
                    } else if (!playerIn.field_71071_by.func_70441_a(floodbucket)) {
                        playerIn.func_71019_a(floodbucket, false);
                    }
                }
                if (random < 50) {
                    worldIn.func_72838_d((Entity)firework);
                }
            }
        }
    }

    public ItemStack getFirework(Random rand) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(new NBTTagCompound());
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Flicker", true);
        nbt.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        nbt.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        nbt.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)nbt);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77978_p().func_74782_a("Fireworks", (NBTBase)fireworkTag);
        return firework;
    }

    public void SpawnMob(Entity entity, World worldIn) {
        if (this.tier == 3) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (random < 1) {
                if (entity instanceof EntityRabbit) {
                    EntityRabbit rabbit = new EntityRabbit(worldIn);
                    rabbit.func_175529_r(99);
                    rabbit.func_70634_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p());
                    worldIn.func_72838_d((Entity)rabbit);
                } else if (entity instanceof EntityCreeper) {
                    EntityCreeper creeper = new EntityCreeper(worldIn);
                    creeper.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
                    NBTTagCompound tag = new NBTTagCompound();
                    creeper.func_70014_b(tag);
                    tag.func_74777_a("ExplosionRadius", (short)0);
                    tag.func_74777_a("Fuse", (short)0);
                    creeper.func_70037_a(tag);
                    worldIn.func_72838_d((Entity)creeper);
                    creeper.func_70656_aK();
                } else {
                    entity.func_70634_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p());
                    worldIn.func_72838_d(entity);
                }
            }
            this.setStatueAble(false);
        }
    }

    public void GiveItem(@Nullable ItemStack stack1, @Nullable ItemStack stack2, @Nullable ItemStack stack3, EntityPlayer playerIn) {
        if (this.isStatueAble()) {
            int random = this.field_145850_b.field_73012_v.nextInt(100);
            if (this.tier >= 3) {
                if (random < 100 && stack1 != null && stack1 != ItemStack.field_190927_a) {
                    playerIn.func_71019_a(stack1, true);
                }
                if (stack2 != null && stack2 != ItemStack.field_190927_a && random < 50) {
                    playerIn.func_71019_a(stack2, true);
                }
                if (stack3 != null && stack3 != ItemStack.field_190927_a && random < 10) {
                    playerIn.func_71019_a(stack3, true);
                }
                this.setStatueAble(false);
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = compound.func_74762_e("StatueTier");
        this.cooldown = compound.func_74762_e("StatueCooldown");
        this.cooldownMax = compound.func_74762_e("StatueMaxcooldown");
        this.statueAble = compound.func_74767_n("StatueAble");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("StatueTier", this.tier);
        compound.func_74768_a("StatueCooldown", this.cooldown);
        compound.func_74768_a("StatueMaxcooldown", this.cooldownMax);
        compound.func_74757_a("StatueAble", this.statueAble);
        return compound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Loader.isModLoaded((String)"waila")) {
            this.sendUpdatePacket();
        }
        if (!this.statueAble) {
            ++this.cooldown;
            this.func_70296_d();
            if (this.cooldownMax == 0) {
                this.cooldownMax = StatuesConfigGen.general.InteractionTimer * 20;
            }
            if (this.cooldown >= this.cooldownMax) {
                this.cooldown = 0;
                this.setStatueAble(true);
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getCooldownMax() {
        return this.cooldownMax;
    }

    public boolean isStatueAble() {
        return this.statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        this.statueAble = statueAble;
        this.func_70296_d();
    }

    @Optional.Method(modid="waila")
    public void sendUpdatePacket() {
        EntityPlayerMP player = (EntityPlayerMP)this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0, false);
        if (player != null && this.tier >= 3) {
            if (StatueTimerProvider.info == null) {
                StatuesPacketHandler.INSTANCE.sendTo((IMessage)new StatuesProgressMessage(this.getCooldown(), this.getCooldownMax(), this.isStatueAble(), this.field_174879_c), player);
            } else {
                int z;
                int y;
                RayTraceResult result = player.func_174822_a(5.0, 1.0f);
                int x = result.func_178782_a().func_177958_n();
                BlockPos lookPos = new BlockPos(x, y = result.func_178782_a().func_177956_o(), z = result.func_178782_a().func_177952_p());
                if (lookPos.equals((Object)this.field_174879_c) && (StatueTimerProvider.info.getPosition() != this.field_174879_c || StatueTimerProvider.info.isAble() != this.isStatueAble())) {
                    if (StatueTimerProvider.info.isAble() != this.isStatueAble()) {
                        StatuesPacketHandler.INSTANCE.sendTo((IMessage)new StatuesProgressMessage(this.getCooldown(), this.getCooldownMax(), this.isStatueAble(), this.field_174879_c), player);
                    } else if (StatueTimerProvider.info.getCooldown() != this.getCooldown()) {
                        StatuesPacketHandler.INSTANCE.sendTo((IMessage)new StatuesProgressMessage(this.getCooldown(), this.getCooldownMax(), this.isStatueAble(), this.field_174879_c), player);
                    }
                }
            }
        }
    }
}

