/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.block;

import io.github.drmanganese.endercrop.block.BlockCropEnder;
import io.github.drmanganese.endercrop.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockTilledEndStone
extends BlockFarmland {
    public BlockTilledEndStone() {
        this.func_149663_c("tilled_end_stone");
        this.setRegistryName("tilled_end_stone");
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_149711_c(0.6f);
        this.setHarvestLevel("pickaxe", 1);
        ModBlocks.BLOCKS.add((Block)this);
    }

    public void func_180650_b(@Nullable World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn == null) {
            return;
        }
        int i = (Integer)state.func_177229_b((IProperty)field_176531_a);
        if (!this.hasWater(worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(state, worldIn, pos)) {
                worldIn.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private boolean hasCrops(IBlockState state, World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean hasWater(World worldIn, BlockPos pos) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        return plant.func_177230_c() instanceof BlockCropEnder;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos pos2) {
        super.func_189540_a(state, world, pos, block, pos2);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            world.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn instanceof EntityLivingBase) {
            if (!worldIn.field_72995_K && worldIn.field_73012_v.nextFloat() < fallDistance - 0.5f) {
                if (!(entityIn instanceof EntityPlayer) && !worldIn.func_82736_K().func_82766_b("mobGriefing")) {
                    return;
                }
                worldIn.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
            }
            entityIn.func_180430_e(fallDistance, 1.0f);
        }
    }

    public boolean isFertile(@Nonnull World world, @Nonnull BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)field_176531_a) > 0;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, @Nullable Random rand, int fortune) {
        return Blocks.field_150377_bs.func_180660_a(Blocks.field_150377_bs.func_176223_P(), rand, fortune);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        if (player != null) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        return new ItemStack((Block)this);
    }
}

