/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.raytrace.Cuboid;
import matteroverdrive.raytrace.DistanceRayTraceResult;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.AABBUtils;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockPipe<TE extends TileEntity>
extends MOBlockContainer<TE> {
    public static final ImmutableList<PropertyBool> CONNECTED_PROPERTIES = ImmutableList.of((Object)PropertyBool.func_177716_a((String)EnumFacing.DOWN.func_176610_l()), (Object)PropertyBool.func_177716_a((String)EnumFacing.UP.func_176610_l()), (Object)PropertyBool.func_177716_a((String)EnumFacing.NORTH.func_176610_l()), (Object)PropertyBool.func_177716_a((String)EnumFacing.SOUTH.func_176610_l()), (Object)PropertyBool.func_177716_a((String)EnumFacing.WEST.func_176610_l()), (Object)PropertyBool.func_177716_a((String)EnumFacing.EAST.func_176610_l()));
    private static final Cuboid CENTER = new Cuboid(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final Cuboid DOWN = new Cuboid(0.3125, 0.0, 0.3125, 0.6875, 0.3125, 0.6875);
    private static final List<Cuboid> CUBES = new ArrayList<Cuboid>();
    private static Cuboid[] FACES;

    public BlockPipe(Material material, String name) {
        super(material, name);
        this.field_149783_u = true;
        this.setRotationType(MOBlockHelper.RotationType.PREVENT);
    }

    protected static DistanceRayTraceResult rayTraceBox(BlockPos pos, Vec3d start, Vec3d end, Cuboid box) {
        Vec3d startRay = start.func_178788_d(new Vec3d((Vec3i)pos));
        Vec3d endRay = end.func_178788_d(new Vec3d((Vec3i)pos));
        RayTraceResult bbResult = box.aabb().func_72327_a(startRay, endRay);
        if (bbResult != null) {
            Vec3d hitVec = bbResult.field_72307_f.func_178787_e(new Vec3d((Vec3i)pos));
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = start.func_72436_e(hitVec);
            return new DistanceRayTraceResult(hitVec, pos, sideHit, box, dist);
        }
        return null;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.isConnectableSide(facing, world, pos)));
        }
        return state;
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CENTER.aabb();
    }

    @Nullable
    protected RayTraceResult func_185503_a(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        return this.rayTraceBoxesClosest(start, end, pos, CUBES);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList<Cuboid> list = new ArrayList<Cuboid>();
        list.add(CENTER);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.isConnectableSide(facing, (IBlockAccess)worldIn, pos)) continue;
            list.add(FACES[facing.func_176745_a()]);
        }
        return this.rayTraceBoxesClosest(start, end, pos, list);
    }

    protected RayTraceResult rayTraceBoxesClosest(Vec3d start, Vec3d end, BlockPos pos, List<Cuboid> boxes) {
        ArrayList<DistanceRayTraceResult> results = new ArrayList<DistanceRayTraceResult>();
        for (Cuboid box : boxes) {
            DistanceRayTraceResult hit = BlockPipe.rayTraceBox(pos, start, end, box);
            if (hit == null) continue;
            results.add(hit);
        }
        DistanceRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (DistanceRayTraceResult hit : results) {
            if (!(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity entityIn, boolean isActualState) {
        AxisAlignedBB center = CENTER.aabb().func_186670_a(pos);
        if (mask.func_72326_a(center)) {
            list.add(center);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            AxisAlignedBB sideBox;
            if (!this.isConnectableSide(side, (IBlockAccess)worldIn, pos) || !mask.func_72326_a(sideBox = FACES[side.func_176745_a()].aabb().func_186670_a(pos))) continue;
            list.add(sideBox);
        }
    }

    public boolean isConnectableSide(EnumFacing dir, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileEntityPipe && ((TileEntityPipe)tileEntity).isConnectableSide(dir);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    static {
        CUBES.add(CENTER);
        FACES = new Cuboid[6];
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPipe.FACES[facing.func_176745_a()] = new Cuboid(AABBUtils.rotateFace(DOWN.aabb(), facing));
            CUBES.add(FACES[facing.func_176745_a()]);
        }
    }
}

