/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks.includes;

import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.api.internal.ItemModelProvider;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class MOBlock
extends Block
implements ItemModelProvider {
    public static final PropertyDirection PROPERTY_DIRECTION = PropertyDirection.func_177714_a((String)"facing");
    protected AxisAlignedBB boundingBox = field_185505_j;
    private BlockStateContainer blockState;
    private boolean hasRotation;
    private MOBlockHelper.RotationType rotationType;

    public MOBlock(Material material, String name) {
        super(material);
        this.setRegistryName(new ResourceLocation("matteroverdrive", name));
        this.blockState = this.func_180661_e();
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.field_149787_q = this.func_176223_P().func_185914_p();
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.func_149663_c(name);
        this.func_149647_a(MatterOverdrive.TAB_OVERDRIVE);
        this.rotationType = MOBlockHelper.RotationType.FOUR_WAY;
    }

    public void setBoundingBox(AxisAlignedBB boundingBox) {
        this.boundingBox = boundingBox;
    }

    @Override
    public void initItemModel() {
        NonNullList sub = NonNullList.func_191196_a();
        this.func_149666_a(CreativeTabs.field_78027_g, sub);
        for (ItemStack stack : sub) {
            ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        if (this.hasRotation) {
            return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_DIRECTION});
        }
        return super.func_180661_e();
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        if (this.hasRotation) {
            return this.func_176223_P().func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        if (this.hasRotation) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTY_DIRECTION);
            return facing.func_176745_a();
        }
        return 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        IMOTileEntity tileEntity = (IMOTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.onAdded(worldIn, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor) {
        super.func_189540_a(state, world, pos, blockIn, neighbor);
        IMOTileEntity tileEntity = (IMOTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.onNeighborBlockChange((IBlockAccess)world, pos, world.func_180495_p(pos), world.func_180495_p(neighbor).func_177230_c());
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.hasRotation) {
            return this.func_176223_P().func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)(this.rotationType == MOBlockHelper.RotationType.FOUR_WAY ? placer.func_174811_aO().func_176734_d() : EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)));
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (this.rotationType != MOBlockHelper.RotationType.PREVENT) {
            IBlockState state = world.func_180495_p(pos);
            for (IProperty prop : state.func_177228_b().keySet()) {
                if (!prop.func_177701_a().equals(PROPERTY_DIRECTION)) continue;
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTY_DIRECTION);
                if (this.rotationType == MOBlockHelper.RotationType.FOUR_WAY) {
                    facing = EnumFacing.field_82609_l[MOBlockHelper.SIDE_LEFT[facing.ordinal() % MOBlockHelper.SIDE_LEFT.length]];
                } else if (this.rotationType == MOBlockHelper.RotationType.SIX_WAY && facing.ordinal() < 6) {
                    facing = EnumFacing.field_82609_l[(facing.ordinal() + 1) % 6];
                }
                world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)facing), 3);
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state) && worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof MOTileEntity) {
            ((MOTileEntity)worldIn.func_175625_s(pos)).onDestroyed(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void setRotationType(MOBlockHelper.RotationType type) {
        this.rotationType = type;
    }

    public void setHasRotation() {
        this.hasRotation = true;
        this.blockState = this.func_180661_e();
        this.func_180632_j(this.blockState.func_177621_b().func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)(this.rotationType == MOBlockHelper.RotationType.PREVENT ? EnumFacing.DOWN : (this.rotationType == MOBlockHelper.RotationType.FOUR_WAY ? EnumFacing.NORTH : EnumFacing.UP))));
    }

    public BlockStateContainer func_176194_O() {
        return this.blockState;
    }
}

