/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IAndroidStatRenderRegistry;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.api.internal.ItemModelProvider;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.api.renderer.IBionicPartRenderer;
import matteroverdrive.api.renderer.IBioticStatRenderer;
import matteroverdrive.api.starmap.IStarmapRenderRegistry;
import matteroverdrive.blocks.BlockDecorativeColored;
import matteroverdrive.client.ClientUtil;
import matteroverdrive.client.model.ModelTritaniumArmor;
import matteroverdrive.client.render.AndroidBionicPartRenderRegistry;
import matteroverdrive.client.render.AndroidStatRenderRegistry;
import matteroverdrive.client.render.DimensionalRiftsRender;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.client.render.PipeRenderManager;
import matteroverdrive.client.render.RenderDialogSystem;
import matteroverdrive.client.render.RenderMatterScannerInfoHandler;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.client.render.RenderWeaponsBeam;
import matteroverdrive.client.render.StarmapRenderRegistry;
import matteroverdrive.client.render.WeaponModuleModelRegistry;
import matteroverdrive.client.render.biostat.BioticStatRendererShield;
import matteroverdrive.client.render.biostat.BioticStatRendererTeleporter;
import matteroverdrive.client.render.entity.EntityRendererDrone;
import matteroverdrive.client.render.entity.EntityRendererFailedChicken;
import matteroverdrive.client.render.entity.EntityRendererFailedCow;
import matteroverdrive.client.render.entity.EntityRendererFailedPig;
import matteroverdrive.client.render.entity.EntityRendererFailedSheep;
import matteroverdrive.client.render.entity.EntityRendererMadScientist;
import matteroverdrive.client.render.entity.EntityRendererMutantScientist;
import matteroverdrive.client.render.entity.EntityRendererPhaserFire;
import matteroverdrive.client.render.entity.EntityRendererRangedRougeAndroid;
import matteroverdrive.client.render.entity.EntityRendererRougeAndroid;
import matteroverdrive.client.render.tileentity.TileEntityRendererAndroidStation;
import matteroverdrive.client.render.tileentity.TileEntityRendererContractMarket;
import matteroverdrive.client.render.tileentity.TileEntityRendererFusionReactorController;
import matteroverdrive.client.render.tileentity.TileEntityRendererGravitationalAnomaly;
import matteroverdrive.client.render.tileentity.TileEntityRendererGravitationalStabilizer;
import matteroverdrive.client.render.tileentity.TileEntityRendererHoloSign;
import matteroverdrive.client.render.tileentity.TileEntityRendererInscriber;
import matteroverdrive.client.render.tileentity.TileEntityRendererMatterPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererNetworkPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererPacketQueue;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatterStorage;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.client.render.tileentity.TileEntityRendererPipe;
import matteroverdrive.client.render.tileentity.TileEntityRendererReplicator;
import matteroverdrive.client.render.tileentity.TileEntityRendererStarMap;
import matteroverdrive.client.render.tileentity.TileEntityRendererWeaponStation;
import matteroverdrive.client.render.tileentity.starmap.StarMapRenderGalaxy;
import matteroverdrive.client.render.tileentity.starmap.StarMapRenderPlanetStats;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererPlanet;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererQuadrant;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStar;
import matteroverdrive.client.render.weapons.ItemRenderPlasmaShotgun;
import matteroverdrive.client.render.weapons.ItemRendererIonSniper;
import matteroverdrive.client.render.weapons.ItemRendererOmniTool;
import matteroverdrive.client.render.weapons.ItemRendererPhaser;
import matteroverdrive.client.render.weapons.ItemRendererPhaserRifle;
import matteroverdrive.client.render.weapons.WeaponRenderHandler;
import matteroverdrive.client.render.weapons.layers.WeaponLayerAmmoRender;
import matteroverdrive.client.render.weapons.modules.ModuleHoloSightsRender;
import matteroverdrive.client.render.weapons.modules.ModuleSniperScopeRender;
import matteroverdrive.entity.EntityDrone;
import matteroverdrive.entity.EntityFailedChicken;
import matteroverdrive.entity.EntityFailedCow;
import matteroverdrive.entity.EntityFailedPig;
import matteroverdrive.entity.EntityFailedSheep;
import matteroverdrive.entity.EntityVillagerMadScientist;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.items.weapon.module.WeaponModuleHoloSights;
import matteroverdrive.items.weapon.module.WeaponModuleSniperScope;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import matteroverdrive.machines.pattern_monitor.TileEntityMachinePatternMonitor;
import matteroverdrive.machines.pattern_storage.TileEntityMachinePatternStorage;
import matteroverdrive.machines.replicator.TileEntityMachineReplicator;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityAndroidStation;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.tile.TileEntityInscriber;
import matteroverdrive.tile.TileEntityMachineContractMarket;
import matteroverdrive.tile.TileEntityMachineGravitationalStabilizer;
import matteroverdrive.tile.TileEntityMachinePacketQueue;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;

public class RenderHandler {
    public static final Function<ResourceLocation, TextureAtlasSprite> modelTextureBakeFunc = new Function<ResourceLocation, TextureAtlasSprite>(){

        @Nullable
        public TextureAtlasSprite apply(@Nullable ResourceLocation input) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(input.toString());
        }
    };
    public static int stencilBuffer;
    private static ItemRendererPhaser rendererPhaser;
    private static ItemRendererPhaserRifle rendererPhaserRifle;
    private static ItemRendererOmniTool rendererOmniTool;
    private static ItemRenderPlasmaShotgun renderPlasmaShotgun;
    private static ItemRendererIonSniper rendererIonSniper;
    private final Random random = new Random();
    private final WeaponLayerAmmoRender weaponLayerAmmoRender = new WeaponLayerAmmoRender();
    public EntityRendererRougeAndroid<EntityRougeAndroidMob> rendererRougeAndroidHologram;
    public ModelTritaniumArmor modelTritaniumArmor;
    public ModelTritaniumArmor modelTritaniumArmorFeet;
    public ModelBiped modelMeleeRogueAndroidParts;
    public ModelBiped modelRangedRogueAndroidParts;
    public IBakedModel doubleHelixModel;
    private RenderMatterScannerInfoHandler matterScannerInfoHandler;
    private RenderParticlesHandler renderParticlesHandler;
    private RenderWeaponsBeam renderWeaponsBeam;
    private List<IWorldLastRenderer> customRenderers = new ArrayList<IWorldLastRenderer>();
    private AndroidStatRenderRegistry statRenderRegistry;
    private StarmapRenderRegistry starmapRenderRegistry;
    private RenderDialogSystem renderDialogSystem;
    private AndroidBionicPartRenderRegistry bionicPartRenderRegistry;
    private WeaponModuleModelRegistry weaponModuleModelRegistry;
    private PipeRenderManager pipeRenderManager;
    private DimensionalRiftsRender dimensionalRiftsRender;
    private WeaponRenderHandler weaponRenderHandler;
    private ModuleSniperScopeRender moduleSniperScopeRender;
    private ModuleHoloSightsRender moduleHoloSightsRender;
    private BioticStatRendererTeleporter rendererTeleporter;
    private BioticStatRendererShield biostatRendererShield;
    private StarMapRenderPlanetStats starMapRenderPlanetStats;
    private StarMapRenderGalaxy starMapRenderGalaxy;
    private StarMapRendererStar starMapRendererStar;
    private StarMapRendererQuadrant starMapRendererQuadrant;
    private StarMapRendererPlanet starMapRendererPlanet;
    private TileEntityRendererReplicator tileEntityRendererReplicator;
    private TileEntityRendererPipe tileEntityRendererPipe;
    private TileEntityRendererMatterPipe tileEntityRendererMatterPipe;
    private TileEntityRendererNetworkPipe tileEntityRendererNetworkPipe;
    private TileEntityRendererPatterStorage tileEntityRendererPatterStorage;
    private TileEntityRendererWeaponStation tileEntityRendererWeaponStation;
    private TileEntityRendererPatternMonitor tileEntityRendererPatternMonitor;
    private TileEntityRendererGravitationalAnomaly tileEntityRendererGravitationalAnomaly;
    private TileEntityRendererGravitationalStabilizer tileEntityRendererGravitationalStabilizer;
    private TileEntityRendererFusionReactorController tileEntityRendererFusionReactorController;
    private TileEntityRendererAndroidStation tileEntityRendererAndroidStation;
    private TileEntityRendererStarMap tileEntityRendererStarMap;
    private TileEntityRendererHoloSign tileEntityRendererHoloSign;
    private TileEntityRendererPacketQueue tileEntityRendererPacketQueue;
    private TileEntityRendererInscriber tileEntityRendererInscriber;
    private TileEntityRendererContractMarket tileEntityRendererContractMarket;

    public RenderHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.weaponRenderHandler = new WeaponRenderHandler();
        this.moduleSniperScopeRender = new ModuleSniperScopeRender(this.weaponRenderHandler);
        this.moduleHoloSightsRender = new ModuleHoloSightsRender(this.weaponRenderHandler);
    }

    public void init(World world, TextureManager textureManager) {
        this.matterScannerInfoHandler = new RenderMatterScannerInfoHandler();
        this.renderParticlesHandler = new RenderParticlesHandler(world, textureManager);
        this.renderWeaponsBeam = new RenderWeaponsBeam();
        this.statRenderRegistry = new AndroidStatRenderRegistry();
        this.starmapRenderRegistry = new StarmapRenderRegistry();
        this.renderDialogSystem = new RenderDialogSystem();
        this.bionicPartRenderRegistry = new AndroidBionicPartRenderRegistry();
        this.weaponModuleModelRegistry = new WeaponModuleModelRegistry();
        this.pipeRenderManager = new PipeRenderManager();
        this.dimensionalRiftsRender = new DimensionalRiftsRender();
        this.addCustomRenderer(this.matterScannerInfoHandler);
        this.addCustomRenderer(this.renderParticlesHandler);
        this.addCustomRenderer(this.renderWeaponsBeam);
        this.addCustomRenderer(this.renderDialogSystem);
        this.addCustomRenderer(this.dimensionalRiftsRender);
        MinecraftForge.EVENT_BUS.register((Object)this.pipeRenderManager);
        MinecraftForge.EVENT_BUS.register((Object)this.weaponRenderHandler);
        if (Minecraft.func_71410_x().func_147110_a().enableStencil()) {
            stencilBuffer = MinecraftForgeClient.reserveStencilBit();
        }
    }

    @SubscribeEvent
    public void modelLoadEvent(ModelRegistryEvent event) {
        for (Item item : MatterOverdriveItems.items) {
            if (!(item instanceof ItemModelProvider)) continue;
            ((ItemModelProvider)item).initItemModel();
        }
        for (Block block : MatterOverdriveBlocks.blocks) {
            if (block instanceof ItemModelProvider) {
                ((ItemModelProvider)block).initItemModel();
                continue;
            }
            ClientUtil.registerWithMapper(block);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        for (IWorldLastRenderer renderer : this.customRenderers) {
            renderer.onRenderWorldLast(this, event);
        }
        for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
            Collection<IBioticStatRenderer> statRendererCollection = this.statRenderRegistry.getRendererCollection(stat.getClass());
            if (statRendererCollection == null) continue;
            for (IBioticStatRenderer renderer : statRendererCollection) {
                renderer.onWorldRender(stat, MOPlayerCapabilityProvider.GetAndroidCapability((Entity)Minecraft.func_71410_x().field_71439_g).getUnlockedLevel(stat), event);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.renderParticlesHandler != null) {
            this.renderParticlesHandler.onClientTick(event);
        }
    }

    public void createTileEntityRenderers(ConfigurationHandler configHandler) {
        this.tileEntityRendererReplicator = new TileEntityRendererReplicator();
        this.tileEntityRendererPipe = new TileEntityRendererPipe();
        this.tileEntityRendererMatterPipe = new TileEntityRendererMatterPipe();
        this.tileEntityRendererNetworkPipe = new TileEntityRendererNetworkPipe();
        this.tileEntityRendererPatterStorage = new TileEntityRendererPatterStorage();
        this.tileEntityRendererWeaponStation = new TileEntityRendererWeaponStation();
        this.tileEntityRendererPatternMonitor = new TileEntityRendererPatternMonitor();
        this.tileEntityRendererGravitationalAnomaly = new TileEntityRendererGravitationalAnomaly();
        this.tileEntityRendererGravitationalStabilizer = new TileEntityRendererGravitationalStabilizer();
        this.tileEntityRendererFusionReactorController = new TileEntityRendererFusionReactorController();
        this.tileEntityRendererAndroidStation = new TileEntityRendererAndroidStation();
        this.tileEntityRendererStarMap = new TileEntityRendererStarMap();
        this.tileEntityRendererHoloSign = new TileEntityRendererHoloSign();
        this.tileEntityRendererPacketQueue = new TileEntityRendererPacketQueue();
        this.tileEntityRendererInscriber = new TileEntityRendererInscriber();
        this.tileEntityRendererContractMarket = new TileEntityRendererContractMarket();
        configHandler.subscribe(this.tileEntityRendererAndroidStation);
        configHandler.subscribe(this.tileEntityRendererWeaponStation);
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability(event.getEntity());
        if (androidPlayer != null && androidPlayer.isAndroid() && !event.getEntity().func_82150_aj()) {
            for (int i = 0; i < 5; ++i) {
                IBionicPartRenderer renderer;
                ItemStack part = androidPlayer.func_70301_a(i);
                if (part == null || !(part.func_77973_b() instanceof IBionicPart) || (renderer = this.bionicPartRenderRegistry.getRenderer(((IBionicPart)part.func_77973_b()).getClass())) == null) continue;
                try {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    renderer.renderPart(part, androidPlayer, event.getRenderer(), event.getPartialRenderTick());
                    GlStateManager.func_179121_F();
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "An Error occurred while rendering bionic part", new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability(event.getEntity());
        if (androidPlayer != null && androidPlayer.isAndroid() && !event.getEntity().func_82150_aj()) {
            for (int i = 0; i < 5; ++i) {
                IBionicPartRenderer renderer;
                ItemStack part = androidPlayer.func_70301_a(i);
                if (part == null || !(part.func_77973_b() instanceof IBionicPart) || (renderer = this.bionicPartRenderRegistry.getRenderer(((IBionicPart)part.func_77973_b()).getClass())) == null) continue;
                renderer.affectPlayerRenderer(part, androidPlayer, event.getRenderer(), event.getPartialRenderTick());
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntity() != null && AndroidPlayer.DISABLE_ANDROID_FOV && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntity())) != null && androidPlayer.isAndroid()) {
            double attributeValue = (1.0 - androidPlayer.getSpeedMultiply()) / 2.0;
            event.setNewfov(event.getFov() + (float)attributeValue);
        }
    }

    public void registerWeaponModuleRenders() {
        this.weaponRenderHandler.addModuleRender(WeaponModuleSniperScope.class, this.moduleSniperScopeRender);
        this.weaponRenderHandler.addModuleRender(WeaponModuleHoloSights.class, this.moduleHoloSightsRender);
    }

    public void registerWeaponLayers() {
        this.weaponRenderHandler.addWeaponLayer(this.weaponLayerAmmoRender);
    }

    public void registerTileEntitySpecialRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineReplicator.class, (TileEntitySpecialRenderer)this.tileEntityRendererReplicator);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePatternStorage.class, (TileEntitySpecialRenderer)this.tileEntityRendererPatterStorage);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWeaponStation.class, (TileEntitySpecialRenderer)this.tileEntityRendererWeaponStation);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePatternMonitor.class, (TileEntitySpecialRenderer)this.tileEntityRendererPatternMonitor);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGravitationalAnomaly.class, (TileEntitySpecialRenderer)this.tileEntityRendererGravitationalAnomaly);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineGravitationalStabilizer.class, (TileEntitySpecialRenderer)this.tileEntityRendererGravitationalStabilizer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineFusionReactorController.class, (TileEntitySpecialRenderer)this.tileEntityRendererFusionReactorController);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAndroidStation.class, (TileEntitySpecialRenderer)this.tileEntityRendererAndroidStation);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineStarMap.class, (TileEntitySpecialRenderer)this.tileEntityRendererStarMap);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHoloSign.class, (TileEntitySpecialRenderer)this.tileEntityRendererHoloSign);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachinePacketQueue.class, (TileEntitySpecialRenderer)this.tileEntityRendererPacketQueue);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInscriber.class, (TileEntitySpecialRenderer)this.tileEntityRendererInscriber);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMachineContractMarket.class, (TileEntitySpecialRenderer)this.tileEntityRendererContractMarket);
    }

    public void registerBlockColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, p_186720_2_, pos, tintIndex) -> {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b(BlockDecorativeColored.COLOR);
            return ItemDye.field_150922_c[MathHelper.func_76125_a((int)color.func_176765_a(), (int)0, (int)(ItemDye.field_150922_c.length - 1))];
        }, new Block[]{MatterOverdrive.BLOCKS.decorative_tritanium_plate_colored});
    }

    public void createItemRenderers() {
        rendererPhaser = new ItemRendererPhaser();
        rendererPhaserRifle = new ItemRendererPhaserRifle();
        rendererOmniTool = new ItemRendererOmniTool();
        renderPlasmaShotgun = new ItemRenderPlasmaShotgun();
        rendererIonSniper = new ItemRendererIonSniper();
    }

    public void activateItemRenderers() {
        rendererPhaser.init();
        rendererPhaserRifle.init();
        rendererOmniTool.init();
        renderPlasmaShotgun.init();
        rendererIonSniper.init();
    }

    public void bakeItemModels() {
        this.weaponRenderHandler.onModelBake(Minecraft.func_71410_x().func_147117_R(), this);
        rendererPhaser.bakeModel();
        rendererPhaserRifle.bakeModel();
        rendererOmniTool.bakeModel();
        rendererIonSniper.bakeModel();
        renderPlasmaShotgun.bakeModel();
    }

    public void registerModelTextures(TextureMap textureMap, OBJModel model) {
        model.getTextures().forEach(arg_0 -> ((TextureMap)textureMap).func_174942_a(arg_0));
    }

    public OBJModel getObjModel(ResourceLocation location, ImmutableMap<String, String> customOptions) {
        try {
            OBJModel model = (OBJModel)OBJLoader.INSTANCE.loadModel(location);
            model = (OBJModel)model.process(customOptions);
            return model;
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while baking %s model", location.func_110623_a());
            return null;
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(MatterOverdrive.ITEMS.phaser.getRegistryName(), "inventory"), (Object)rendererPhaser);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(MatterOverdrive.ITEMS.phaserRifle.getRegistryName(), "inventory"), (Object)rendererPhaserRifle);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(MatterOverdrive.ITEMS.omniTool.getRegistryName(), "inventory"), (Object)rendererOmniTool);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(MatterOverdrive.ITEMS.ionSniper.getRegistryName(), "inventory"), (Object)rendererIonSniper);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(MatterOverdrive.ITEMS.plasmaShotgun.getRegistryName(), "inventory"), (Object)renderPlasmaShotgun);
        this.activateItemRenderers();
        this.bakeItemModels();
    }

    @SubscribeEvent
    public void onTextureStich(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            this.weaponRenderHandler.onTextureStich(Minecraft.func_71410_x().func_147117_R(), this);
        }
    }

    public void registerItemColors() {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_HOLO_RED.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.energyPack});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_MATTER.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.battery});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_YELLOW_STRIPES.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.hc_battery});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_HOLO_RED.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.creative_battery});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_YELLOW_STRIPES.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.networkFlashDrive});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 1 ? Reference.COLOR_HOLO_GREEN.getColor() : -1, new Item[]{MatterOverdrive.ITEMS.transportFlashDrive});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> {
            switch (tintIndex) {
                case 1: {
                    return Reference.COLOR_YELLOW_STRIPES.getColor();
                }
                case 2: 
                case 3: {
                    return Reference.COLOR_MATTER.getColor();
                }
            }
            return -1;
        }, new Item[]{MatterOverdrive.ITEMS.matterContainer});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 1 && !stack.func_190926_b() && stack.func_77973_b() != null) {
                return WeaponModuleColor.colors[stack.func_77952_i()].getColor();
            }
            return 0xFFFFFF;
        }, new Item[]{MatterOverdrive.ITEMS.weapon_module_color});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0 && !stack.func_190926_b() && stack.func_77973_b() != null) {
                return ItemDye.field_150922_c[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(ItemDye.field_150922_c.length - 1))];
            }
            return -1;
        }, new Item[]{Item.func_150898_a((Block)MatterOverdrive.BLOCKS.decorative_tritanium_plate_colored)});
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (stack.func_77952_i() == 0) {
                return 0xD00000;
            }
            if (stack.func_77952_i() == 1) {
                return 106474;
            }
            if (stack.func_77952_i() == 2) {
                return 16770048;
            }
            return 0xFFFFFF;
        }, new Item[]{MatterOverdrive.ITEMS.androidPill});
    }

    public void createEntityRenderers(RenderManager renderManager) {
        this.rendererRougeAndroidHologram = new EntityRendererRougeAndroid(renderManager, true);
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMeleeRougeAndroidMob.class, renderManager -> new EntityRendererRougeAndroid(renderManager, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityVillagerMadScientist.class, EntityRendererMadScientist::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedPig.class, EntityRendererFailedPig::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedCow.class, EntityRendererFailedCow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedChicken.class, EntityRendererFailedChicken::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFailedSheep.class, EntityRendererFailedSheep::new);
        RenderingRegistry.registerEntityRenderingHandler(PlasmaBolt.class, EntityRendererPhaserFire::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRangedRogueAndroidMob.class, EntityRendererRangedRougeAndroid::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMutantScientist.class, EntityRendererMutantScientist::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDrone.class, EntityRendererDrone::new);
    }

    public void createBioticStatRenderers() {
        this.rendererTeleporter = new BioticStatRendererTeleporter();
        this.biostatRendererShield = new BioticStatRendererShield();
    }

    public void registerBioticStatRenderers() {
        this.statRenderRegistry.registerRenderer(OverdriveBioticStats.shield.getClass(), this.biostatRendererShield);
        this.statRenderRegistry.registerRenderer(OverdriveBioticStats.teleport.getClass(), this.rendererTeleporter);
    }

    public void registerBionicPartRenderers() {
    }

    public void createStarmapRenderers() {
        this.starMapRendererPlanet = new StarMapRendererPlanet();
        this.starMapRendererQuadrant = new StarMapRendererQuadrant();
        this.starMapRendererStar = new StarMapRendererStar();
        this.starMapRenderGalaxy = new StarMapRenderGalaxy();
        this.starMapRenderPlanetStats = new StarMapRenderPlanetStats();
    }

    public void registerStarmapRenderers() {
        this.starmapRenderRegistry.registerRenderer(Planet.class, this.starMapRendererPlanet);
        this.starmapRenderRegistry.registerRenderer(Quadrant.class, this.starMapRendererQuadrant);
        this.starmapRenderRegistry.registerRenderer(Star.class, this.starMapRendererStar);
        this.starmapRenderRegistry.registerRenderer(Galaxy.class, this.starMapRenderGalaxy);
        this.starmapRenderRegistry.registerRenderer(Planet.class, this.starMapRenderPlanetStats);
    }

    public void createModels() {
        this.modelTritaniumArmor = new ModelTritaniumArmor(0.0f);
        this.modelTritaniumArmorFeet = new ModelTritaniumArmor(0.5f);
        this.modelMeleeRogueAndroidParts = new ModelBiped(0.0f);
        this.modelRangedRogueAndroidParts = new ModelBiped(0.0f, 0.0f, 96, 64);
        try {
            IModel model = OBJLoader.INSTANCE.loadModel(new ResourceLocation("matteroverdrive:models/gui/double_helix.obj"));
            this.doubleHelixModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (java.util.function.Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Nullable
                public TextureAtlasSprite apply(@Nullable ResourceLocation input) {
                    return Minecraft.func_71410_x().func_147117_R().func_174942_a(input);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RenderParticlesHandler getRenderParticlesHandler() {
        return this.renderParticlesHandler;
    }

    public TileEntityRendererStarMap getTileEntityRendererStarMap() {
        return this.tileEntityRendererStarMap;
    }

    public IAndroidStatRenderRegistry getStatRenderRegistry() {
        return this.statRenderRegistry;
    }

    public IStarmapRenderRegistry getStarmapRenderRegistry() {
        return this.starmapRenderRegistry;
    }

    public ItemRendererOmniTool getRendererOmniTool() {
        return rendererOmniTool;
    }

    public AndroidBionicPartRenderRegistry getBionicPartRenderRegistry() {
        return this.bionicPartRenderRegistry;
    }

    public WeaponModuleModelRegistry getWeaponModuleModelRegistry() {
        return this.weaponModuleModelRegistry;
    }

    public Random getRandom() {
        return this.random;
    }

    public void addCustomRenderer(IWorldLastRenderer renderer) {
        this.customRenderers.add(renderer);
    }

    public WeaponRenderHandler getWeaponRenderHandler() {
        return this.weaponRenderHandler;
    }
}

