/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.client.TextureMapMO;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class HoloIcons
implements ITextureMapPopulator {
    public final TextureMapMO textureMap;
    public final ResourceLocation sheet = new ResourceLocation("matteroverdrive", "textures/gui/holo_icons.png");
    private final Map<String, HoloIcon> iconMap = new HashMap<String, HoloIcon>();
    public int sheetSize = 256;

    public HoloIcons() {
        this.textureMap = new TextureMapMO("textures/gui/items", this);
        this.textureMap.func_174943_a(Minecraft.func_71410_x().func_110442_L(), this);
        try {
            Minecraft.func_71410_x().field_71446_o.func_110580_a(this.sheet, (ITickableTextureObject)this.textureMap);
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while creating Holo Icons texture sheet", new Object[0]);
        }
    }

    public static void tessalateParticleIcon(TextureAtlasSprite icon, double x, double y, double z, float size, Color color) {
        RenderUtils.tessalateParticle(Minecraft.func_71410_x().func_175606_aa(), icon, size, new Vec3d(x, y, z), color);
    }

    public static void tessalateStaticIcon(TextureAtlasSprite icon, double x, double y, double z, float size, Color color) {
        HoloIcons.tessalateStaticIcon(icon, x, y, z, size, color, 1.0f);
    }

    public static void tessalateStaticIcon(TextureAtlasSprite icon, double x, double y, double z, float size, Color color, float multiply) {
        float halfSize = size / 2.0f;
        float uMin = icon.func_94209_e();
        float uMax = icon.func_94212_f();
        float vMin = icon.func_94206_g();
        float vMax = icon.func_94210_h();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181662_b(x - (double)halfSize, y - (double)halfSize, z).func_187315_a((double)uMax, (double)vMax).func_181666_a(color.getFloatR() * multiply, color.getFloatG() * multiply, color.getFloatB() * multiply, color.getFloatA()).func_181675_d();
        wr.func_181662_b(x + (double)halfSize, y - (double)halfSize, z).func_187315_a((double)uMin, (double)vMax).func_181666_a(color.getFloatR() * multiply, color.getFloatG() * multiply, color.getFloatB() * multiply, color.getFloatA()).func_181675_d();
        wr.func_181662_b(x + (double)halfSize, y + (double)halfSize, z).func_187315_a((double)uMin, (double)vMin).func_181666_a(color.getFloatR() * multiply, color.getFloatG() * multiply, color.getFloatB() * multiply, color.getFloatA()).func_181675_d();
        wr.func_181662_b(x - (double)halfSize, y + (double)halfSize, z).func_187315_a((double)uMax, (double)vMin).func_181666_a(color.getFloatR() * multiply, color.getFloatG() * multiply, color.getFloatB() * multiply, color.getFloatA()).func_181675_d();
    }

    private void reg(TextureMap map, String icon, int size) {
        this.registerIcon(map, icon, size);
    }

    public HoloIcon registerIcon(TextureMap textureMap, String iconName, int originalSize) {
        HoloIcon holoIcon = new HoloIcon(textureMap.func_174942_a(new ResourceLocation("matteroverdrive", iconName)), originalSize, originalSize);
        this.iconMap.put(iconName, holoIcon);
        return holoIcon;
    }

    public HoloIcon getIcon(String icon) {
        return this.iconMap.get(icon);
    }

    public void bindSheet() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.sheet);
    }

    public void renderIcon(String name, double x, double y) {
        HoloIcon icon = this.getIcon(name);
        this.renderIcon(icon, x, y, icon.getOriginalWidth(), icon.getOriginalHeight());
    }

    public void renderIcon(String name, double x, double y, int width, int height) {
        this.renderIcon(this.getIcon(name), x, y, width, height);
    }

    public void renderIcon(HoloIcon icon, double x, double y) {
        this.renderIcon(icon, x, y, icon.getOriginalWidth(), icon.getOriginalHeight());
    }

    public void renderIcon(HoloIcon icon, double x, double y, int width, int height) {
        if (icon != null) {
            this.bindSheet();
            RenderUtils.renderIcon(x, y, 0.0, icon.getIcon(), width, height);
        }
    }

    public void func_177059_a(TextureMap ir) {
        this.reg(ir, "holo_home", 14);
        this.reg(ir, "holo_dotted_circle", 20);
        this.reg(ir, "holo_factory", 14);
        this.reg(ir, "person", 18);
        this.reg(ir, "android_slot_arms", 16);
        this.reg(ir, "android_slot_chest", 16);
        this.reg(ir, "android_slot_head", 16);
        this.reg(ir, "android_slot_legs", 16);
        this.reg(ir, "android_slot_other", 16);
        this.reg(ir, "barrel", 16);
        this.reg(ir, "battery", 16);
        this.reg(ir, "color", 16);
        this.reg(ir, "factory", 16);
        this.reg(ir, "module", 16);
        this.reg(ir, "sights", 16);
        this.reg(ir, "shielding", 16);
        this.reg(ir, "scanner", 16);
        this.reg(ir, "upgrade", 16);
        this.reg(ir, "decompose", 16);
        this.reg(ir, "pattern_storage", 16);
        this.reg(ir, "home_icon", 14);
        this.reg(ir, "page_icon_home", 14);
        this.reg(ir, "page_icon_tasks", 15);
        this.reg(ir, "page_icon_upgrades", 12);
        this.reg(ir, "page_icon_config", 16);
        this.reg(ir, "page_icon_search", 16);
        this.reg(ir, "page_icon_info", 16);
        this.reg(ir, "page_icon_galaxy", 11);
        this.reg(ir, "page_icon_quadrant", 9);
        this.reg(ir, "page_icon_star", 12);
        this.reg(ir, "page_icon_planet", 16);
        this.reg(ir, "energy", 16);
        this.reg(ir, "arrow_right", 19);
        this.reg(ir, "travel_icon", 18);
        this.reg(ir, "icon_search", 16);
        this.reg(ir, "icon_size", 16);
        this.reg(ir, "icon_shuttle", 16);
        this.reg(ir, "icon_size", 16);
        this.reg(ir, "icon_stats", 16);
        this.reg(ir, "icon_scount_planet", 32);
        this.reg(ir, "icon_attack", 16);
        this.reg(ir, "up_arrow", 7);
        this.reg(ir, "crosshair", 3);
        this.reg(ir, "up_arrow_large", 18);
        this.reg(ir, "android_feature_icon_bg", 22);
        this.reg(ir, "android_feature_icon_bg_active", 22);
        this.reg(ir, "health", 18);
        this.reg(ir, "black_circle", 18);
        this.reg(ir, "connections", 16);
        this.reg(ir, "ammo", 18);
        this.reg(ir, "temperature", 18);
        this.reg(ir, "flash_drive", 16);
        this.reg(ir, "trade", 16);
        this.reg(ir, "mini_quit", 16);
        this.reg(ir, "mini_back", 16);
        this.reg(ir, "tick", 16);
        this.reg(ir, "list", 16);
        this.reg(ir, "grid", 16);
        this.reg(ir, "sort_random", 16);
        this.reg(ir, "minimap_target", 21);
        this.reg(ir, "question_mark", 20);
        this.reg(ir, "android_feature_icon_bg_black", 22);
        this.reg(ir, "smile", 16);
        MatterOverdrive.STAT_REGISTRY.registerIcons(ir, this);
    }
}

