/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.weapons.modules;

import com.google.common.collect.ImmutableMap;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.weapons.WeaponRenderHandler;
import matteroverdrive.client.render.weapons.modules.ModuleRenderAbstract;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.obj.OBJModel;

public class ModuleHoloSightsRender
extends ModuleRenderAbstract {
    private ResourceLocation sightsModelLocation = new ResourceLocation("matteroverdrive:models/item/weapon_module_holo_sights.obj");
    private OBJModel sightsModel;
    private IBakedModel sightsBakedModel;

    public ModuleHoloSightsRender(WeaponRenderHandler weaponRenderer) {
        super(weaponRenderer);
    }

    @Override
    public void renderModule(WeaponMetadataSection weaponMeta, ItemStack weaponStack, ItemStack moduleStack, float ticks) {
        Vec3d scopePos = weaponMeta.getModulePosition("default_scope");
        if (scopePos != null) {
            GlStateManager.func_179124_c((float)0.7f, (float)0.7f, (float)0.7f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)scopePos.field_72450_a, (double)scopePos.field_72448_b, (double)scopePos.field_72449_c);
            GlStateManager.func_179090_x();
            this.weaponRenderer.renderModel(this.sightsBakedModel, weaponStack);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
            GlStateManager.func_179140_f();
            RenderUtils.disableLightmap();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179137_b((double)(scopePos.field_72450_a - 0.012), (double)(scopePos.field_72448_b + (double)0.01f), (double)scopePos.field_72449_c);
            GlStateManager.func_179137_b((double)0.012, (double)0.012, (double)0.0);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)-0.012, (double)-0.012, (double)0.0);
            RenderUtils.bindTexture(((IWeaponModule)moduleStack.func_77973_b()).getModelTexture(moduleStack));
            RenderUtils.drawPlane(0.024, 0.024);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            RenderUtils.enableLightmap();
        }
    }

    @Override
    public void transformWeapon(WeaponMetadataSection weaponMeta, ItemStack weaponStack, ItemStack moduleStack, float ticks, float zoomValue) {
        Vec3d scopePos = weaponMeta.getModulePosition("default_scope");
        if (scopePos != null) {
            GlStateManager.func_179137_b((double)0.0, (double)MOMathHelper.Lerp(0.0, -scopePos.field_72448_b + (double)0.118f, (double)zoomValue), (double)0.0);
        }
    }

    @Override
    public void onModelBake(TextureMap textureMap, RenderHandler renderHandler) {
        this.sightsModel = renderHandler.getObjModel(this.sightsModelLocation, (ImmutableMap<String, String>)new ImmutableMap.Builder().put((Object)"flip-v", (Object)"true").put((Object)"ambient", (Object)"false").build());
        this.sightsBakedModel = this.sightsModel.bake(this.sightsModel.getDefaultState(), DefaultVertexFormats.field_176599_b, RenderHandler.modelTextureBakeFunc);
    }

    @Override
    public void onTextureStich(TextureMap textureMap, RenderHandler renderHandler) {
    }
}

