/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.init.OverdriveFluids;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class MatterStorage
extends FluidTank
implements IMatterHandler {
    private int maxExtract;
    private int maxReceive;

    public MatterStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public MatterStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public MatterStorage(int capacity, int maxExtract, int maxReceive) {
        super(capacity);
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid != null && fluid.getFluid() == OverdriveFluids.matterPlasma;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return fluid != null && fluid.getFluid() == OverdriveFluids.matterPlasma;
    }

    @Override
    public int modifyMatterStored(int amount) {
        int lastAmount = this.getFluid() == null ? 0 : this.getFluid().amount;
        int newAmount = lastAmount + amount;
        newAmount = MathHelper.func_76125_a((int)newAmount, (int)0, (int)this.getCapacity());
        this.setMatterStored(newAmount);
        return lastAmount - newAmount;
    }

    @Override
    public int getMatterStored() {
        return this.getFluidAmount();
    }

    @Override
    public void setMatterStored(int amount) {
        if (amount <= 0) {
            this.setFluid(null);
        } else {
            this.drainInternal(this.getFluidAmount(), true);
            this.fillInternal(new FluidStack((Fluid)OverdriveFluids.matterPlasma, amount), true);
        }
    }

    @Override
    public int receiveMatter(int amount, boolean simulate) {
        return this.fill(new FluidStack((Fluid)OverdriveFluids.matterPlasma, amount), !simulate);
    }

    @Override
    public int extractMatter(int amount, boolean simulate) {
        FluidStack drained = this.drain(amount, !simulate);
        if (drained == null) {
            return 0;
        }
        return drained.amount;
    }
}

