/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.dialog;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogMessageSeedable;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.dialog.IDialogOption;
import matteroverdrive.api.events.MOEventDialogInteract;
import matteroverdrive.api.exceptions.MORuntimeException;
import matteroverdrive.api.renderer.IDialogShot;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DialogMessage
implements IDialogMessage,
IDialogMessageSeedable {
    protected static Random random = new Random();
    protected String[] messages;
    protected String[] questions;
    protected boolean unlocalized;
    protected IDialogMessage parent;
    protected List<IDialogOption> options;
    @SideOnly(value=Side.CLIENT)
    protected IDialogShot[] shots;
    @SideOnly(value=Side.CLIENT)
    protected String holoIcon;
    protected long seed;

    public DialogMessage(JsonObject object) {
        this.init();
        this.unlocalized = MOJsonHelper.getBool(object, "unlocalized", false);
        if (object.has("message")) {
            JsonElement messageElement = object.get("message");
            if (messageElement.isJsonArray()) {
                this.messages = MOJsonHelper.getStringArray(object, "message");
            } else if (messageElement.isJsonPrimitive() && messageElement.getAsJsonPrimitive().isString()) {
                this.messages = new String[]{messageElement.getAsString()};
            }
        } else {
            throw new MORuntimeException(String.format("Cannot find Message for dialog", new Object[0]));
        }
        if (object.has("question")) {
            JsonElement questionElement = object.get("question");
            if (questionElement.isJsonArray()) {
                this.questions = MOJsonHelper.getStringArray(object, "message");
            } else if (questionElement.isJsonPrimitive() && questionElement.getAsJsonPrimitive().isString()) {
                this.questions = new String[]{questionElement.getAsString()};
            }
        }
    }

    public DialogMessage() {
        this.init();
    }

    public DialogMessage(String message) {
        this(message, message);
    }

    public DialogMessage(String message, String question) {
        String[] stringArray;
        String[] stringArray2;
        if (message != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = message;
        } else {
            stringArray2 = null;
        }
        if (question != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = question;
        } else {
            stringArray = null;
        }
        this(stringArray2, stringArray);
    }

    public DialogMessage(String[] messages, String[] questions) {
        this.messages = messages;
        this.questions = questions;
        this.init();
    }

    private void init() {
        this.options = new ArrayList<IDialogOption>();
    }

    @Override
    public IDialogMessage getParent(IDialogNpc npc, EntityPlayer player) {
        return this.parent;
    }

    @Override
    public List<IDialogOption> getOptions(IDialogNpc npc, EntityPlayer player) {
        return this.options;
    }

    @Override
    public String getMessageText(IDialogNpc npc, EntityPlayer player) {
        if (this.messages != null && this.messages.length > 0) {
            int messageIndex = 0;
            if (this.messages.length > 1) {
                messageIndex = random.nextInt(this.messages.length);
            }
            return this.formatMessage(this.messages[messageIndex], npc, player);
        }
        return "";
    }

    @Override
    public String getQuestionText(IDialogNpc npc, EntityPlayer player) {
        if (this.questions != null && this.questions.length > 0) {
            int questionIndex = 0;
            if (this.questions.length > 1) {
                questionIndex = random.nextInt(this.questions.length);
            }
            return this.formatQuestion(this.questions[questionIndex], npc, player);
        }
        return "";
    }

    @Override
    public void onOptionsInteract(IDialogNpc npc, EntityPlayer player, int option) {
        if (option >= 0 && option < this.options.size()) {
            this.options.get(option).onInteract(npc, player);
        }
    }

    @Override
    public void onInteract(IDialogNpc npc, EntityPlayer player) {
        if (npc != null && player != null) {
            if (player.field_70170_p.field_72995_K) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventDialogInteract(player, npc, this, Side.CLIENT))) {
                    this.setAsGuiActiveMessage(npc, player);
                }
            } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventDialogInteract(player, npc, this, Side.SERVER))) {
                npc.onPlayerInteract(player, this);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setAsGuiActiveMessage(IDialogNpc npc, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiDialog) {
            ((GuiDialog)Minecraft.func_71410_x().field_71462_r).setCurrentMessage(this);
        }
    }

    @Override
    public boolean canInteract(IDialogNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isVisible(IDialogNpc npc, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IDialogShot[] getShots(IDialogNpc npc, EntityPlayer player) {
        return this.shots;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHoloIcon(IDialogNpc npc, EntityPlayer player) {
        return this.holoIcon;
    }

    @Override
    public boolean equalsOption(IDialogOption other) {
        return this.equals(other);
    }

    @SideOnly(value=Side.CLIENT)
    public void setShots(IDialogShot ... shot) {
        this.shots = shot;
    }

    public void setParent(IDialogMessage parent) {
        this.parent = parent;
    }

    public void addOption(IDialogOption message) {
        this.options.add(message);
    }

    public IDialogOption getOption(int id) {
        return this.options.get(id);
    }

    public List<IDialogOption> getOptions() {
        return this.options;
    }

    @SideOnly(value=Side.CLIENT)
    public DialogMessage setHoloIcon(String holoIcon) {
        this.holoIcon = holoIcon;
        return this;
    }

    protected String formatMessage(String text, IDialogNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(this.unlocalized ? MOStringHelper.translateToLocal(text, new Object[0]) : text, player.func_145748_c_().func_150254_d(), npc.getEntity().func_145748_c_().func_150254_d());
        }
        return null;
    }

    protected String formatQuestion(String text, IDialogNpc npc, EntityPlayer player) {
        if (text != null) {
            return String.format(this.unlocalized ? MOStringHelper.translateToLocal(text, new Object[0]) : text, player.func_145748_c_().func_150254_d(), npc.getEntity().func_145748_c_().func_150254_d());
        }
        return null;
    }

    public DialogMessage setUnlocalized(boolean unlocalized) {
        this.unlocalized = unlocalized;
        return this;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        random.setSeed(seed);
    }

    public void setQuestions(String[] questions) {
        this.questions = questions;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }
}

