/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogicRandomItem;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicCollectItem
extends AbstractQuestLogicRandomItem {
    int dimensionID;
    boolean inSpecificDimension;
    boolean destroyOnCollect;
    int xpPerItem;
    int minItemCount;
    int maxItemCount;

    public QuestLogicCollectItem() {
    }

    public QuestLogicCollectItem(QuestItem questItem, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{questItem}, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(ItemStack itemStack, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{QuestItem.fromItemStack(itemStack)}, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(Item item, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{QuestItem.fromItemStack(new ItemStack(item))}, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(ItemStack[] itemStacks, int minItemCount, int maxItemCount, int xpPerItem) {
        QuestItem[] questItems = new QuestItem[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            questItems[i] = QuestItem.fromItemStack(itemStacks[i]);
        }
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(Item[] items, int minItemCount, int maxItemCount, int xpPerItem) {
        QuestItem[] questItems = new QuestItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            questItems[i] = QuestItem.fromItemStack(new ItemStack(items[i]));
        }
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(QuestItem[] questItems, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    protected void init(QuestItem[] questItems, int minItemCount, int maxItemCount, int xpPerItem) {
        super.init(questItems);
        this.minItemCount = minItemCount;
        this.maxItemCount = maxItemCount;
        this.xpPerItem = xpPerItem;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        if (jsonObject.has("dimension")) {
            this.dimensionID = MOJsonHelper.getInt(jsonObject, "dimension", 0);
            this.inSpecificDimension = true;
        }
        this.destroyOnCollect = MOJsonHelper.getBool(jsonObject, "destroy_pickup", false);
        this.xpPerItem = MOJsonHelper.getInt(jsonObject, "xp", 0);
        this.minItemCount = MOJsonHelper.getInt(jsonObject, "item_count_min");
        this.maxItemCount = MOJsonHelper.getInt(jsonObject, "item_count_max");
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return String.format(info, "", this.getMaxItemCount(questStack), this.getItemName(questStack));
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getItemCount(entityPlayer, questStack) >= this.getMaxItemCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        return String.format(objective, "", this.getItemCount(entityPlayer, questStack), this.getMaxItemCount(questStack), this.getItemName(questStack));
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.initItemType(random, questStack);
        this.getTag(questStack).func_74768_a("MaxItemCount", this.random(random, this.minItemCount, this.maxItemCount));
    }

    public int getItemCount(EntityPlayer entityPlayer, QuestStack questStack) {
        if (this.destroyOnCollect) {
            if (this.hasTag(questStack)) {
                return this.getTag(questStack).func_74762_e("ItemCount");
            }
            return 0;
        }
        int itemCount = 0;
        for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackInSlot = entityPlayer.field_71071_by.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !this.matches(questStack, stackInSlot)) continue;
            itemCount += stackInSlot.func_190916_E();
        }
        return itemCount;
    }

    public void setItemCount(QuestStack questStack, int count) {
        if (this.destroyOnCollect) {
            this.initTag(questStack);
            this.getTag(questStack).func_74768_a("ItemCount", count);
        }
    }

    public int getMaxItemCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74762_e("MaxItemCount");
        }
        return 0;
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (this.destroyOnCollect && event instanceof EntityItemPickupEvent && !((EntityItemPickupEvent)event).getItem().func_92059_d().func_190926_b()) {
            if (this.inSpecificDimension && entityPlayer.field_70170_p.field_73011_w.getDimension() != this.dimensionID) {
                return null;
            }
            ItemStack itemStack = ((EntityItemPickupEvent)event).getItem().func_92059_d();
            if (!itemStack.func_190926_b() && this.matches(questStack, itemStack)) {
                this.initTag(questStack);
                int currentItemCount = this.getItemCount(entityPlayer, questStack);
                if (currentItemCount < this.getMaxItemCount(questStack)) {
                    this.setItemCount(questStack, ++currentItemCount);
                    if (this.isObjectiveCompleted(questStack, entityPlayer, 0)) {
                        this.markComplete(questStack, entityPlayer);
                        return new QuestLogicState(QuestState.Type.COMPLETE, true);
                    }
                    return new QuestLogicState(QuestState.Type.UPDATE, true);
                }
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        if (!this.destroyOnCollect) {
            int itemCount = this.getMaxItemCount(questStack);
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = entityPlayer.field_71071_by.func_70301_a(i);
                if (stackInSlot.func_190926_b() || !this.matches(questStack, stackInSlot) || itemCount <= 0) continue;
                int newItemCount = Math.max(0, itemCount - stackInSlot.func_190916_E());
                int takenFromStack = itemCount - newItemCount;
                entityPlayer.field_71071_by.func_70298_a(i, takenFromStack);
                itemCount = newItemCount;
            }
        }
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxItemCount(questStack) * this.xpPerItem;
    }

    public QuestLogicCollectItem setDestroyOnCollect(boolean destroyOnCollect) {
        this.destroyOnCollect = destroyOnCollect;
        return this;
    }

    public QuestLogicCollectItem setDimensionID(int dimensionID) {
        this.inSpecificDimension = true;
        this.dimensionID = dimensionID;
        return this;
    }
}

