/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.recipes;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import matteroverdrive.data.recipes.Recipe;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecipeManager<M, R extends Recipe<M>> {
    protected final Class<R> recipeClass;
    protected final List<R> recipes = new ArrayList<R>();

    public RecipeManager(Class<R> recipeClass) {
        this.recipeClass = recipeClass;
    }

    public void load(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodes = document.getElementsByTagName("recipe");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                Recipe recipe = (Recipe)this.recipeClass.newInstance();
                recipe.fromXML(e);
                this.register(recipe);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(R recipe) {
        this.recipes.add(recipe);
    }

    public Optional<R> get(M machine) {
        return this.recipes.stream().filter(r -> r.matches(machine)).findFirst();
    }

    public boolean isInput(ItemStack stack) {
        return this.recipes.stream().flatMap(r -> r.getInputs().stream()).anyMatch(s -> s.func_77973_b() == stack.func_77973_b() && s.func_77952_i() == stack.func_77952_i());
    }

    public List<R> getRecipes() {
        return ImmutableList.copyOf(this.recipes);
    }
}

