/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.android_player;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.api.events.MOEventAndroid;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.MinimapEntityInfo;
import matteroverdrive.data.inventory.BionicSlot;
import matteroverdrive.data.inventory.EnergySlot;
import matteroverdrive.entity.android_player.AndroidAttributes;
import matteroverdrive.entity.android_player.AndroidEffects;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.gui.GuiAndroidHud;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.network.packet.client.PacketAndroidTransformation;
import matteroverdrive.network.packet.client.PacketSendAndroidEffects;
import matteroverdrive.network.packet.client.PacketSendMinimapInfo;
import matteroverdrive.network.packet.client.PacketSyncAndroid;
import matteroverdrive.network.packet.server.PacketAndroidChangeAbility;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AndroidPlayer
implements IEnergyStorage,
IAndroid {
    public static final int EFFECT_GLITCH_TIME = 0;
    public static final int EFFECT_CLOAKED = 1;
    public static final int EFFECT_SHIELD = 2;
    public static final int EFFECT_SHIELD_LAST_USE = 3;
    public static final int EFFECT_NIGHTVISION = 4;
    public static final int EFFECT_SHOCK_LAST_USE = 5;
    public static final int EFFECT_LAST_TELEPORT = 6;
    public static final int EFFECT_WIRELESS_CHARGING = 7;
    public static final int EFFECT_HIGH_JUMP = 8;
    public static final int EFFECT_TURNNING = 9;
    public static final int EFFECT_ITEM_MAGNET = 10;
    public static final String NBT_ACTIVE_ABILITY = "AA";
    public static final String NBT_STATS = "S";
    public static final short TRANSFORM_TIME = 680;
    public static final int MINIMAP_SEND_TIMEOUT = 40;
    private static final int BUILTIN_ENERGY_TRANSFER = 1024;
    private static final int ENERGY_WATCHER_DEFAULT = 29;
    private static final int ENERGY_PER_JUMP = 512;
    private static final AttributeModifier outOfPowerSpeedModifier = new AttributeModifier(UUID.fromString("ec778ddc-9711-498b-b9aa-8e5adc436e00"), "Android Out of Power", -0.5, 2).func_111168_a(false);
    private static final List<IBioticStat> wheelStats = new ArrayList<IBioticStat>();
    private static final Map<Integer, MinimapEntityInfo> entityInfoMap = new HashMap<Integer, MinimapEntityInfo>();
    @CapabilityInject(value=AndroidPlayer.class)
    public static Capability<AndroidPlayer> CAPABILITY;
    public static boolean DISABLE_ANDROID_FOV;
    private static int RECHARGE_AMOUNT_ON_RESPAWN;
    private static boolean HURT_GLITCHING;
    private static DataParameter<Integer> ENERGY;
    private static boolean TRANSFORMATION_DEATH;
    private static boolean REMOVE_POTION_EFFECTS;
    private static List<String> POTION_REMOVAL_BLACKLIST;
    private final int ENERGY_SLOT;
    private final Inventory inventory;
    private NonNullList<ItemStack> previousBionicParts = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private EntityPlayer player;
    private IBioticStat activeStat;
    private NBTTagCompound unlocked;
    private int maxEnergy = 512000;
    private boolean isAndroid;
    private boolean hasRunOutOfPower;
    private AndroidEffects androidEffects;

    public AndroidPlayer(EntityPlayer player) {
        this.inventory = new Inventory("Android");
        this.inventory.AddSlot(new BionicSlot(false, 0));
        this.inventory.AddSlot(new BionicSlot(false, 1));
        this.inventory.AddSlot(new BionicSlot(false, 2));
        this.inventory.AddSlot(new BionicSlot(false, 3));
        this.inventory.AddSlot(new BionicSlot(false, 4));
        this.ENERGY_SLOT = this.inventory.AddSlot(new EnergySlot(false));
        this.unlocked = new NBTTagCompound();
        this.androidEffects = new AndroidEffects(this);
        this.registerEffects(this.androidEffects);
        this.init(player);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(AndroidPlayer.class, (Capability.IStorage)new Capability.IStorage<AndroidPlayer>(){

            public NBTBase writeNBT(Capability<AndroidPlayer> capability, AndroidPlayer instance, EnumFacing side) {
                NBTTagCompound data = new NBTTagCompound();
                instance.writeToNBT(data, EnumSet.allOf(IAndroid.DataType.class));
                return data;
            }

            public void readNBT(Capability<AndroidPlayer> capability, AndroidPlayer instance, EnumFacing side, NBTBase nbt) {
                instance.readFromNBT((NBTTagCompound)nbt, EnumSet.allOf(IAndroid.DataType.class));
            }
        }, AndroidPlayer.class);
    }

    public static void loadConfigs(ConfigurationHandler configurationHandler) {
        TRANSFORMATION_DEATH = configurationHandler.getBool("transformation_death", "entities.android_player", true, "Should the player die after an Android transformation");
        REMOVE_POTION_EFFECTS = configurationHandler.getBool("remove_potion_effects", "entities.android_player", true, "Remove all potion effects while an Android");
        HURT_GLITCHING = configurationHandler.getBool("hurt_glitching", "entities.android_player", true, "Should the glitch effect be displayed every time the player gets hurt");
        RECHARGE_AMOUNT_ON_RESPAWN = configurationHandler.getInt("recharge_amount_on_respawn", "entities.android_player", RECHARGE_AMOUNT_ON_RESPAWN, "How much does the android player recharge after respawning");
        POTION_REMOVAL_BLACKLIST = Arrays.asList(configurationHandler.getStringList("entities.android_player", "potion_removal_blacklist", "Collection of potion ids that won't get removed while being an android. Example: minecraft:wither"));
        DISABLE_ANDROID_FOV = configurationHandler.getBool("disable_android_fov", "entities.android_player", true, "If true android speed modifiers won't change players FOV");
    }

    public static boolean isVisibleOnMinimap(EntityLivingBase entityLivingBase, EntityPlayer player, Vec3d relativePosition) {
        return !entityLivingBase.func_82150_aj() && Math.abs(relativePosition.field_72448_b) < 16.0 && AndroidPlayer.isInRangeToRenderDist(entityLivingBase, 256.0);
    }

    private static boolean isInRangeToRenderDist(EntityLivingBase entity, double distance) {
        double d1 = entity.func_174813_aQ().func_72320_b() * 64.0;
        return distance < d1 * d1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setMinimapEntityInfo(List<MinimapEntityInfo> entityInfo) {
        entityInfoMap.clear();
        for (MinimapEntityInfo info : entityInfo) {
            entityInfoMap.put(info.getEntityID(), info);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static MinimapEntityInfo getMinimapEntityInfo(EntityLivingBase entityLivingBase) {
        return entityInfoMap.get(entityLivingBase.func_145782_y());
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public void init(EntityPlayer player) {
        if (ENERGY == null) {
            ENERGY = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
        }
        player.func_184212_Q().func_187214_a(ENERGY, (Object)this.maxEnergy);
        this.registerAttributes(player);
        this.player = player;
    }

    private void registerEffects(AndroidEffects effects) {
        effects.registerEffect(0, 0, true, false);
        effects.registerEffect(1, false, true, true);
        effects.registerEffect(2, false, true, true);
        effects.registerEffect(3, 0L, true, false);
        effects.registerEffect(4, false, true, false);
        effects.registerEffect(5, 0L, true, false);
        effects.registerEffect(6, 0L, true, false);
        effects.registerEffect(7, false, true, false);
        effects.registerEffect(8, false, true, false);
        effects.registerEffect(9, (short)-1, true, false);
        effects.registerEffect(10, false, true, false);
    }

    private void registerAttributes(EntityPlayer player) {
        player.func_110140_aT().func_111150_b(AndroidAttributes.attributeGlitchTime);
        player.func_110140_aT().func_111150_b(AndroidAttributes.attributeBatteryUse);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound, EnumSet<IAndroid.DataType> dataTypes) {
        NBTTagCompound prop = new NBTTagCompound();
        if (dataTypes.contains((Object)IAndroid.DataType.ENERGY)) {
            prop.func_74768_a("Energy", ((Integer)this.player.func_184212_Q().func_187225_a(ENERGY)).intValue());
            prop.func_74768_a("MaxEnergy", this.maxEnergy);
        }
        if (dataTypes.contains((Object)IAndroid.DataType.DATA)) {
            prop.func_74757_a("isAndroid", this.isAndroid);
        }
        if (dataTypes.contains((Object)IAndroid.DataType.STATS)) {
            prop.func_74782_a(NBT_STATS, (NBTBase)this.unlocked);
        }
        NBTTagCompound effects = new NBTTagCompound();
        this.getAndroidEffects().writeToNBT(effects);
        prop.func_74782_a("effects", (NBTBase)effects);
        if (dataTypes.contains((Object)IAndroid.DataType.ACTIVE_ABILITY) && this.activeStat != null) {
            prop.func_74778_a(NBT_ACTIVE_ABILITY, this.activeStat.getUnlocalizedName());
        }
        if (dataTypes.contains((Object)IAndroid.DataType.INVENTORY)) {
            this.inventory.writeToNBT(prop, true);
        } else if (dataTypes.contains((Object)IAndroid.DataType.BATTERY) && !this.inventory.func_70301_a(this.ENERGY_SLOT).func_190926_b()) {
            NBTTagCompound batteryTag = new NBTTagCompound();
            this.inventory.func_70301_a(this.ENERGY_SLOT).func_77955_b(batteryTag);
            compound.func_74782_a("Battery", (NBTBase)batteryTag);
        }
        compound.func_74782_a("AndroidPlayer", (NBTBase)prop);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound, EnumSet<IAndroid.DataType> dataTypes) {
        NBTTagCompound prop = (NBTTagCompound)compound.func_74781_a("AndroidPlayer");
        if (prop != null) {
            boolean initFlag = false;
            if (dataTypes.contains((Object)IAndroid.DataType.ENERGY)) {
                this.player.func_184212_Q().func_187227_b(ENERGY, (Object)prop.func_74762_e("Energy"));
                this.maxEnergy = prop.func_74762_e("MaxEnergy");
            }
            if (dataTypes.contains((Object)IAndroid.DataType.DATA)) {
                this.isAndroid = prop.func_74767_n("isAndroid");
                initFlag = true;
            }
            if (dataTypes.contains((Object)IAndroid.DataType.STATS)) {
                this.unlocked = prop.func_74775_l(NBT_STATS);
            }
            if (dataTypes.contains((Object)IAndroid.DataType.EFFECTS)) {
                NBTTagCompound effects = prop.func_74775_l("effects");
                this.getAndroidEffects().readFromNBT(effects);
            }
            if (dataTypes.contains((Object)IAndroid.DataType.ACTIVE_ABILITY) && prop.func_74764_b(NBT_ACTIVE_ABILITY)) {
                this.activeStat = MatterOverdrive.STAT_REGISTRY.getStat(prop.func_74779_i(NBT_ACTIVE_ABILITY));
            }
            if (dataTypes.contains((Object)IAndroid.DataType.INVENTORY)) {
                this.inventory.clearItems();
                this.inventory.readFromNBT(prop);
                initFlag = true;
            } else if (dataTypes.contains((Object)IAndroid.DataType.BATTERY)) {
                this.inventory.func_70299_a(this.ENERGY_SLOT, ItemStack.field_190927_a);
                if (compound.func_150297_b("Battery", 10)) {
                    ItemStack battery = new ItemStack(compound.func_74775_l("Battery"));
                    this.inventory.func_70299_a(this.ENERGY_SLOT, battery);
                }
            }
            if (initFlag) {
                // empty if block
            }
        }
    }

    public int extractEnergyRaw(int amount, boolean simulate) {
        int energyExtracted;
        if (this.player.field_71075_bZ.field_75098_d) {
            return amount;
        }
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).hasCapability(CapabilityEnergy.ENERGY, null)) {
            ItemStack battery = this.func_70301_a(this.ENERGY_SLOT);
            IEnergyStorage energyContainerItem = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null);
            energyExtracted = energyContainerItem.extractEnergy(amount, simulate);
            if (energyExtracted > 0 && !simulate) {
                this.sync(EnumSet.of(IAndroid.DataType.BATTERY));
            }
        } else {
            int energy = (Integer)this.player.func_184212_Q().func_187225_a(ENERGY);
            energyExtracted = Math.min(Math.min(energy, amount), 1024);
            if (!simulate) {
                energy -= energyExtracted;
                energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
                this.player.func_184212_Q().func_187227_b(ENERGY, (Object)energy);
            }
        }
        return energyExtracted;
    }

    public void extractEnergyScaled(int amount) {
        double percent = this.getPlayer().func_110140_aT().func_111151_a(AndroidAttributes.attributeBatteryUse).func_111126_e();
        this.extractEnergyRaw((int)((double)amount * percent), false);
    }

    public boolean hasEnoughEnergyScaled(int energy) {
        double percent = this.getPlayer().func_110140_aT().func_111151_a(AndroidAttributes.attributeBatteryUse).func_111126_e();
        int newEnergy = (int)Math.ceil((double)energy * percent);
        return this.extractEnergyRaw(energy, true) >= newEnergy;
    }

    @Override
    public boolean isUnlocked(IBioticStat stat, int level) {
        return this.unlocked.func_74764_b(stat.getUnlocalizedName()) && this.unlocked.func_74762_e(stat.getUnlocalizedName()) >= level;
    }

    @Override
    public int getUnlockedLevel(IBioticStat stat) {
        if (this.unlocked.func_74764_b(stat.getUnlocalizedName())) {
            return this.unlocked.func_74762_e(stat.getUnlocalizedName());
        }
        return 0;
    }

    public boolean tryUnlock(IBioticStat stat, int level) {
        if (stat.canBeUnlocked(this, level)) {
            this.unlock(stat, level);
            return true;
        }
        return false;
    }

    public void unlock(IBioticStat stat, int level) {
        this.clearAllStatAttributeModifiers();
        this.unlocked.func_74768_a(stat.getUnlocalizedName(), level);
        stat.onUnlock(this, level);
        this.sync(EnumSet.of(IAndroid.DataType.STATS));
        this.manageStatAttributeModifiers();
    }

    public int getEnergyStored() {
        if (this.player.field_71075_bZ.field_75098_d) {
            return this.getMaxEnergyStored();
        }
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)this.func_70301_a(this.ENERGY_SLOT).getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return (Integer)this.player.func_184212_Q().func_187225_a(ENERGY);
    }

    public int getMaxEnergyStored() {
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)this.func_70301_a(this.ENERGY_SLOT).getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
        }
        return this.maxEnergy;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        int energyReceived;
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).hasCapability(CapabilityEnergy.ENERGY, null)) {
            ItemStack battery = this.func_70301_a(this.ENERGY_SLOT);
            IEnergyStorage energyContainerItem = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null);
            energyReceived = energyContainerItem.receiveEnergy(amount, simulate);
            this.sync(EnumSet.of(IAndroid.DataType.BATTERY));
        } else {
            int energy = (Integer)this.player.func_184212_Q().func_187225_a(ENERGY);
            energyReceived = Math.min(Math.min(this.getMaxEnergyStored() - energy, amount), 1024);
            if (!simulate) {
                energy += energyReceived;
                energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
                this.player.func_184212_Q().func_187227_b(ENERGY, (Object)energy);
            }
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergyRaw(maxExtract, simulate);
    }

    @Override
    public boolean isAndroid() {
        return this.isAndroid;
    }

    public void setAndroid(boolean isAndroid) {
        this.isAndroid = isAndroid;
        this.sync(EnumSet.allOf(IAndroid.DataType.class));
        if (isAndroid) {
            this.previousBionicParts.clear();
            this.manageStatAttributeModifiers();
        } else {
            this.clearAllStatAttributeModifiers();
            this.clearAllEquipmentAttributeModifiers();
        }
    }

    public void sync(EnumSet<IAndroid.DataType> part) {
        this.sync(this.player, part, false);
    }

    public void sync(EnumSet<IAndroid.DataType> part, boolean others) {
        this.sync(this.player, part, others);
    }

    public void sync(EntityPlayer player, EnumSet<IAndroid.DataType> syncPart, boolean toOthers) {
        if (player instanceof EntityPlayerMP) {
            if (toOthers) {
                MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSyncAndroid(this, syncPart), player, 64.0);
            } else {
                MatterOverdrive.NETWORK.sendTo(new PacketSyncAndroid(this, syncPart), (EntityPlayerMP)player);
            }
        }
    }

    public void copy(AndroidPlayer player) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        player.writeToNBT(tagCompound, EnumSet.allOf(IAndroid.DataType.class));
        this.readFromNBT(tagCompound, EnumSet.allOf(IAndroid.DataType.class));
        this.manageStatAttributeModifiers();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int resetUnlocked() {
        int xp = this.getResetXPRequired();
        this.unlocked = new NBTTagCompound();
        this.sync(EnumSet.of(IAndroid.DataType.STATS));
        this.clearAllStatAttributeModifiers();
        return xp;
    }

    public int getResetXPRequired() {
        int calculatedXP = 0;
        for (Object key : this.unlocked.func_150296_c()) {
            IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(key.toString());
            int unlocked = this.unlocked.func_74762_e(key.toString());
            calculatedXP += stat.getXP(this, unlocked);
        }
        return calculatedXP / 2;
    }

    public void reset(IBioticStat stat) {
        if (this.unlocked.func_74764_b(stat.getUnlocalizedName())) {
            int level = this.unlocked.func_74762_e(stat.getUnlocalizedName());
            stat.onUnlearn(this, level);
            this.unlocked.func_82580_o(stat.getUnlocalizedName());
            this.sync(EnumSet.of(IAndroid.DataType.STATS));
            this.manageStatAttributeModifiers();
        }
    }

    public void onAndroidTick(Side side) {
        if (side.isServer()) {
            if (this.isAndroid()) {
                if (this.getEnergyStored() > 0) {
                    this.manageHasPower();
                    this.managePotionEffects();
                    if (this.hasRunOutOfPower) {
                        this.manageStatAttributeModifiers();
                        this.hasRunOutOfPower = false;
                    }
                } else if (this.getEnergyStored() <= 0) {
                    if (!this.hasRunOutOfPower) {
                        this.manageStatAttributeModifiers();
                        this.hasRunOutOfPower = true;
                    }
                    this.manageOutOfPower();
                }
                this.manageCharging();
                this.manageEquipmentAttributeModifiers();
                if (!this.getPlayer().field_70170_p.field_72995_K) {
                    this.manageMinimapInfo();
                }
            }
            this.manageTurning();
            this.manageEffects();
        }
        if (side.isClient() && this.isAndroid()) {
            this.manageAbilityWheel();
            this.manageSwimming();
        }
        if (this.isAndroid()) {
            this.manageGlitch();
            for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
                int unlockedLevel = this.getUnlockedLevel(stat);
                if (unlockedLevel <= 0) continue;
                if (stat.isEnabled(this, unlockedLevel)) {
                    stat.changeAndroidStats(this, unlockedLevel, true);
                    stat.onAndroidUpdate(this, unlockedLevel);
                    continue;
                }
                stat.changeAndroidStats(this, unlockedLevel, false);
            }
        }
    }

    private void manageEffects() {
        if (this.androidEffects.haveEffectsChanged()) {
            List<AndroidEffects.Effect> changedEffects = this.androidEffects.getChanged();
            MatterOverdrive.NETWORK.sendTo(new PacketSendAndroidEffects(this.player.func_145782_y(), changedEffects), (EntityPlayerMP)this.player);
            ArrayList<AndroidEffects.Effect> othersEffects = new ArrayList<AndroidEffects.Effect>();
            for (AndroidEffects.Effect effect : changedEffects) {
                if (!effect.isSendToOthers()) continue;
                othersEffects.add(effect);
            }
            Set trackers = ((EntityPlayerMP)this.player).func_71121_q().func_73039_n().getTrackingPlayers((Entity)this.player);
            for (EntityPlayer entityPlayer : trackers) {
                if (!(entityPlayer instanceof EntityPlayerMP) || entityPlayer == this.player) continue;
                MatterOverdrive.NETWORK.sendTo(new PacketSendAndroidEffects(this.player.func_145782_y(), othersEffects), (EntityPlayerMP)entityPlayer);
            }
        }
    }

    private void clearAllEquipmentAttributeModifiers() {
        for (int j = 0; j < 5; ++j) {
            Multimap<String, AttributeModifier> multimap;
            ItemStack itemstack1 = this.inventory.func_70301_a(j);
            if (itemstack1.func_190926_b() || !(itemstack1.func_77973_b() instanceof IBionicPart) || (multimap = ((IBionicPart)itemstack1.func_77973_b()).getModifiers(this, itemstack1)) == null) continue;
            this.player.func_110140_aT().func_111148_a(multimap);
        }
    }

    private void manageEquipmentAttributeModifiers() {
        boolean needsSync = false;
        for (int j = 0; j < 5; ++j) {
            Multimap<String, AttributeModifier> multimap;
            ItemStack itemstack = (ItemStack)this.previousBionicParts.get(j);
            ItemStack itemstack1 = this.inventory.func_70301_a(j);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IBionicPart && (multimap = ((IBionicPart)itemstack.func_77973_b()).getModifiers(this, itemstack)) != null) {
                this.player.func_110140_aT().func_111148_a(multimap);
            }
            if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() instanceof IBionicPart && (multimap = ((IBionicPart)itemstack1.func_77973_b()).getModifiers(this, itemstack1)) != null) {
                this.player.func_110140_aT().func_111147_b(multimap);
            }
            this.previousBionicParts.set(j, (Object)itemstack1.func_77946_l());
            needsSync = true;
        }
        if (needsSync) {
            this.sync(EnumSet.of(IAndroid.DataType.INVENTORY), true);
        }
    }

    public void updateStatModifyers(IBioticStat stat) {
        int unlockedLevel = this.getUnlockedLevel(stat);
        Multimap<String, AttributeModifier> multimap = stat.attributes(this, unlockedLevel);
        if (multimap != null) {
            if (this.isAndroid()) {
                if (unlockedLevel > 0) {
                    if (stat.isEnabled(this, unlockedLevel)) {
                        this.player.func_110140_aT().func_111147_b(multimap);
                    } else {
                        this.player.func_110140_aT().func_111148_a(multimap);
                    }
                } else {
                    this.player.func_110140_aT().func_111148_a(multimap);
                }
            } else {
                this.player.func_110140_aT().func_111148_a(multimap);
            }
        }
    }

    private void clearAllStatAttributeModifiers() {
        for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
            int unlockedLevel;
            Multimap<String, AttributeModifier> multimap = stat.attributes(this, unlockedLevel = this.getUnlockedLevel(stat));
            if (multimap == null) continue;
            this.player.func_110140_aT().func_111148_a(multimap);
        }
    }

    private void manageStatAttributeModifiers() {
        MatterOverdrive.STAT_REGISTRY.getStats().forEach(this::updateStatModifyers);
    }

    private void manageMinimapInfo() {
        if (this.getPlayer() instanceof EntityPlayerMP && this.getPlayer().field_70170_p.func_72820_D() % 40L == 0L) {
            ArrayList<MinimapEntityInfo> entityList = new ArrayList<MinimapEntityInfo>();
            for (Object entityObject : this.getPlayer().field_70170_p.field_72996_f) {
                if (!(entityObject instanceof EntityLivingBase) || !AndroidPlayer.isVisibleOnMinimap((EntityLivingBase)entityObject, this.player, new Vec3d(((EntityLivingBase)entityObject).field_70165_t, ((EntityLivingBase)entityObject).field_70163_u, ((EntityLivingBase)entityObject).field_70161_v).func_178788_d(new Vec3d(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v))) || !MinimapEntityInfo.hasInfo((EntityLivingBase)entityObject, this.player)) continue;
                entityList.add(new MinimapEntityInfo((EntityLivingBase)entityObject, this.getPlayer()));
            }
            if (entityList.size() > 0) {
                MatterOverdrive.NETWORK.sendTo(new PacketSendMinimapInfo(entityList), (EntityPlayerMP)this.getPlayer());
            }
        }
    }

    private void manageOutOfPower() {
        IAttributeInstance speed = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speed.func_111127_a(outOfPowerSpeedModifier.func_111167_a()) == null) {
            speed.func_111121_a(outOfPowerSpeedModifier);
        }
        if (this.player.field_70170_p.func_72820_D() % 60L == 0L) {
            this.androidEffects.updateEffect(0, 5);
            this.playGlitchSound(this, this.player.func_70681_au(), 0.2f);
        }
    }

    private void manageHasPower() {
        IAttributeInstance speed = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speed.func_111127_a(outOfPowerSpeedModifier.func_111167_a()) != null) {
            speed.func_111124_b(outOfPowerSpeedModifier);
        }
    }

    private void manageCharging() {
        if (this.player != null && this.player.func_70093_af() && !this.player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (this.player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == MatterOverdrive.ITEMS.battery || this.player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == MatterOverdrive.ITEMS.hc_battery)) {
            int freeEnergy = this.getMaxEnergyStored() - this.getEnergyStored();
            int receivedAmount = ((IEnergyStorage)this.player.func_184586_b(EnumHand.MAIN_HAND).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(freeEnergy, false);
            this.receiveEnergy(receivedAmount, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageAbilityWheel() {
        GuiAndroidHud.showRadial = ClientProxy.keyHandler.getBinding(2).func_151470_d();
        if (GuiAndroidHud.showRadial) {
            double mag = Math.sqrt(GuiAndroidHud.radialDeltaX * GuiAndroidHud.radialDeltaX + GuiAndroidHud.radialDeltaY * GuiAndroidHud.radialDeltaY);
            double magAcceptance = 0.2;
            double radialAngle = -720.0;
            if (mag > magAcceptance) {
                double aSin = Math.toDegrees(Math.asin(GuiAndroidHud.radialDeltaX));
                if (GuiAndroidHud.radialDeltaY >= 0.0 && GuiAndroidHud.radialDeltaX >= 0.0) {
                    radialAngle = aSin;
                } else if (GuiAndroidHud.radialDeltaY < 0.0 && GuiAndroidHud.radialDeltaX >= 0.0) {
                    radialAngle = 90.0 + (90.0 - aSin);
                } else if (GuiAndroidHud.radialDeltaY < 0.0 && GuiAndroidHud.radialDeltaX < 0.0) {
                    radialAngle = 180.0 - aSin;
                } else if (GuiAndroidHud.radialDeltaY >= 0.0 && GuiAndroidHud.radialDeltaX < 0.0) {
                    radialAngle = 270.0 + (90.0 + aSin);
                }
            }
            if (mag > 0.9999999) {
                mag = Math.round(mag);
            }
            wheelStats.clear();
            wheelStats.addAll(MatterOverdrive.STAT_REGISTRY.getStats().stream().filter(stat -> stat.showOnWheel(this, this.getUnlockedLevel((IBioticStat)stat)) && this.isUnlocked((IBioticStat)stat, 0)).collect(Collectors.toList()));
            if (mag > magAcceptance) {
                GuiAndroidHud.radialAngle = radialAngle;
            }
            if (wheelStats.size() <= 0) {
                GuiAndroidHud.showRadial = false;
                return;
            }
            int i = 0;
            for (IBioticStat stat2 : wheelStats) {
                float leeway = 360.0f / (float)wheelStats.size();
                if (mag > magAcceptance && (i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f)) || i != 0 && radialAngle < (double)(leeway * (float)i + leeway / 2.0f) && radialAngle > (double)(leeway * (float)i - leeway / 2.0f))) {
                    if (this.activeStat == stat2) break;
                    this.activeStat = stat2;
                    MatterOverdrive.NETWORK.sendToServer(new PacketAndroidChangeAbility(this.activeStat.getUnlocalizedName()));
                    break;
                }
                ++i;
            }
        }
    }

    public void startConversion() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventAndroid.Transformation(this))) {
            if (this.player.field_70170_p.field_72995_K) {
                this.playTransformMusic();
            } else if (!this.isAndroid() && !this.isTurning()) {
                AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)this.player);
                androidPlayer.startTurningToAndroid();
                if (this.player instanceof EntityPlayerMP) {
                    MatterOverdrive.NETWORK.sendTo(new PacketAndroidTransformation(), (EntityPlayerMP)this.player);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playTransformMusic() {
        MOPositionedSound sound = new MOPositionedSound(MatterOverdriveSounds.musicTransformation, SoundCategory.MUSIC, 1.0f, 1.0f);
        sound.setAttenuationType(ISound.AttenuationType.NONE);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    private void managePotionEffects() {
        if (this.isAndroid() && REMOVE_POTION_EFFECTS) {
            for (PotionEffect potionEffect : new ArrayList(this.player.func_70651_bq())) {
                if (POTION_REMOVAL_BLACKLIST.contains(potionEffect.func_188419_a().getRegistryName().toString())) continue;
                this.player.func_184589_d(potionEffect.func_188419_a());
            }
        }
    }

    public double getSpeedMultiply() {
        return this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    private void manageGlitch() {
        if (this.androidEffects.getEffectInt(0) > 0) {
            this.androidEffects.updateEffect(0, this.androidEffects.getEffectInt(0) - 1);
        }
    }

    private int modify(int amount, IAttribute attribute) {
        IAttributeInstance glitchAttribute = this.player.func_110148_a(attribute);
        if (glitchAttribute != null) {
            amount = (int)((double)amount * glitchAttribute.func_111126_e());
        }
        return amount;
    }

    public float modify(float amount, IAttribute attribute) {
        IAttributeInstance glitchAttribute = this.player.func_110148_a(attribute);
        if (glitchAttribute != null) {
            amount = (int)((double)amount * glitchAttribute.func_111126_e());
        }
        return amount;
    }

    private void manageSwimming() {
        if (this.player.func_70090_H() && (!this.isUnlocked(OverdriveBioticStats.flotation, 1) || !OverdriveBioticStats.flotation.isEnabled(this, 1)) && this.player.field_70181_x > 0.0) {
            this.player.field_70181_x -= 0.06;
        }
    }

    private void manageTurning() {
        short turnningTime = this.getAndroidEffects().getEffectShort(9);
        if (turnningTime > 0) {
            DamageSource fake = new DamageSource("android_transformation");
            fake.func_151518_m();
            fake.func_76348_h();
            turnningTime = (short)(turnningTime - 1);
            this.getAndroidEffects().updateEffect(9, turnningTime);
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 680, 1));
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76438_s, 680));
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 680));
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76440_q, 680));
            if (turnningTime % 40 == 0) {
                this.player.func_70097_a(fake, 0.1f);
                this.playGlitchSound(this, this.player.field_70170_p.field_73012_v, 0.2f);
            }
            if (turnningTime <= 0) {
                this.setAndroid(true);
                this.playGlitchSound(this, this.player.field_70170_p.field_73012_v, 0.8f);
                if (!this.player.field_71075_bZ.field_75098_d && !this.player.field_70170_p.func_72912_H().func_76093_s() && TRANSFORMATION_DEATH) {
                    this.player.func_70097_a(fake, 2.1474836E9f);
                    this.player.func_70106_y();
                }
            }
            this.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
        }
    }

    private void playGlitchSound(AndroidPlayer player, Random random, float amount) {
        player.getPlayer().field_70170_p.func_184134_a(player.getPlayer().field_70165_t, player.getPlayer().field_70163_u, player.getPlayer().field_70161_v, MatterOverdriveSounds.guiGlitch, SoundCategory.PLAYERS, amount, 0.9f + random.nextFloat() * 0.2f, true);
    }

    @SideOnly(value=Side.CLIENT)
    private void playGlitchSoundClient(Random random, float amount) {
        this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, MatterOverdriveSounds.guiGlitch, SoundCategory.PLAYERS, amount, 0.9f + random.nextFloat() * 0.2f);
    }

    @Override
    public boolean isTurning() {
        return this.getAndroidEffects().getEffectShort(9) > 0;
    }

    public void triggerEventOnStats(LivingEvent event) {
        AndroidPlayer androidPlayer;
        if (event.getEntityLiving() instanceof EntityPlayer && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)event.getEntityLiving())).isAndroid()) {
            for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
                int unlockedLevel = androidPlayer.getUnlockedLevel(stat);
                if (unlockedLevel <= 0 || !stat.isEnabled(androidPlayer, unlockedLevel)) continue;
                stat.onLivingEvent(androidPlayer, unlockedLevel, event);
            }
        }
    }

    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        this.manageStatAttributeModifiers();
    }

    public void onPlayerRespawn() {
        while (this.getEnergyStored() < RECHARGE_AMOUNT_ON_RESPAWN) {
            this.receiveEnergy(RECHARGE_AMOUNT_ON_RESPAWN, false);
        }
    }

    public void onEntityHurt(LivingHurtEvent event) {
        if (!event.isCanceled()) {
            if (HURT_GLITCHING && event.getAmount() > 0.0f) {
                this.androidEffects.updateEffect(0, this.modify(10, AndroidAttributes.attributeGlitchTime));
                this.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
                this.playGlitchSound(this, this.player.func_70681_au(), 0.2f);
            }
            this.triggerEventOnStats((LivingEvent)event);
        }
    }

    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            this.extractEnergyScaled(512);
        }
    }

    public void onEntityFall(LivingFallEvent event) {
        this.triggerEventOnStats((LivingEvent)event);
    }

    public void onWeaponEvent(MOEventEnergyWeapon eventEnergyWeapon) {
        this.triggerEventOnStats(eventEnergyWeapon);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    private void startTurningToAndroid() {
        this.getAndroidEffects().updateEffect(9, (short)680);
        this.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
    }

    public NBTTagCompound getUnlockedNBT() {
        return this.unlocked;
    }

    @Override
    public IBioticStat getActiveStat() {
        return this.activeStat;
    }

    public void setActiveStat(IBioticStat stat) {
        this.activeStat = stat;
    }

    @Override
    public void onEffectsUpdate(int effectId) {
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.player.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public AndroidEffects getAndroidEffects() {
        return this.androidEffects;
    }

    static {
        DISABLE_ANDROID_FOV = true;
        RECHARGE_AMOUNT_ON_RESPAWN = 64000;
        HURT_GLITCHING = true;
        TRANSFORMATION_DEATH = true;
        REMOVE_POTION_EFFECTS = true;
        POTION_REMOVAL_BLACKLIST = new ArrayList<String>();
    }
}

