/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.ArrayDeque;
import java.util.Queue;
import matteroverdrive.Reference;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.client.data.Color;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.animation.MOAnimationTimeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiQuestHud {
    private static final float QUEST_NOTIFICATION_TIME = 400.0f;
    private static final float QUEST_FADE_IN_TIME = 30.0f;
    private static final float QUEST_FADE_OUT_TIME = 60.0f;
    private static final float OBJECTIVES_NOTIFICATION_TIME = 200.0f;
    private static final float OBJECTIVES_FADE_TIME = 20.0f;
    private Queue<QuestStack> completedQuestQueue = new ArrayDeque<QuestStack>();
    private Queue<QuestStack> startedQuestQueue = new ArrayDeque<QuestStack>();
    private Queue<String> objectivesChangedQueue = new ArrayDeque<String>();
    private String completeQuestName;
    private int completeQuestXp;
    private String newQuestName;
    private String objectiveChanged;
    private MOAnimationTimeline completeQuestTimeline = new MOAnimationTimeline(400.0f, false, false, 1.0f);
    private MOAnimationTimeline startedQuestTimeline;
    private MOAnimationTimeline objectivesTimeline;

    public GuiQuestHud() {
        this.completeQuestTimeline.setAutoLength(true);
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 30.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.completeQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 340.0f, 60.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
        this.startedQuestTimeline = new MOAnimationTimeline(400.0f, false, false, 1.0f);
        this.startedQuestTimeline.setAutoLength(true);
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 30.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.startedQuestTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 340.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
        this.objectivesTimeline = new MOAnimationTimeline(200.0f, false, false, 1.0f);
        this.objectivesTimeline.setAutoLength(true);
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(0.0f, 1.0f, 0.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseIn()));
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 1.0f, 30.0f, 340.0f, null));
        this.objectivesTimeline.addSlice(new MOAnimationTimeline.Slice(1.0f, 0.0f, 180.0f, 20.0f, new MOAnimationTimeline.Easing.QuadEaseOut()));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            int y;
            Color color;
            float time;
            FontRenderer fontRenderer = ClientProxy.moFontRender;
            if (this.completeQuestTimeline.isPlaying() && this.completeQuestName != null) {
                time = this.completeQuestTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 20 + (int)(235.0f * time));
                GlStateManager.func_179094_E();
                y = (int)((double)event.getResolution().func_78328_b() * 0.15);
                int titleWidth = (int)((double)fontRenderer.func_78256_a(this.completeQuestName) * 1.5);
                GlStateManager.func_179109_b((float)((float)(event.getResolution().func_78326_a() - titleWidth - 30) - time * 30.0f), (float)(y - 20), (float)0.0f);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                fontRenderer.func_175063_a(TextFormatting.BOLD + this.completeQuestName, 0.0f, 40.0f, color.getColor());
                GlStateManager.func_179121_F();
                fontRenderer.func_175063_a("Completed:", (float)(event.getResolution().func_78326_a() - titleWidth - 20 - (int)(time * 40.0f)), (float)(y + 28), color.getColor());
                if (this.completeQuestXp > 0) {
                    fontRenderer.func_175063_a(String.format("+%dxp", (int)(time * (float)this.completeQuestXp)), (float)(event.getResolution().func_78326_a() - 50 - (int)(20.0f * time)), (float)(y + 58), color.getColor());
                }
            }
            if (this.startedQuestTimeline.isPlaying() && this.newQuestName != null) {
                time = this.startedQuestTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 19 + (int)(235.0f * time));
                GlStateManager.func_179094_E();
                y = (int)((double)event.getResolution().func_78328_b() * 0.65);
                GlStateManager.func_179109_b((float)(-10.0f + time * 30.0f), (float)y, (float)0.0f);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                fontRenderer.func_175063_a(TextFormatting.BOLD + this.newQuestName, 0.0f, 0.0f, color.getColor());
                GlStateManager.func_179121_F();
                fontRenderer.func_175063_a("Started:", (float)((int)(time * 20.0f)), (float)(y - 12), color.getColor());
            }
            if (this.objectivesTimeline.isPlaying() && this.objectiveChanged != null) {
                time = this.objectivesTimeline.getCurrentValue();
                color = new Color(Reference.COLOR_HOLO.getIntR(), Reference.COLOR_HOLO.getIntG(), Reference.COLOR_HOLO.getIntB(), 20 + (int)(235.0f * time));
                int objectivesY = 0;
                if (this.objectiveChanged != null) {
                    fontRenderer.func_175063_a(String.format("[ %s ]", this.objectiveChanged), (float)((int)(time * 20.0f)), (float)((int)((double)event.getResolution().func_78328_b() * 0.5) + objectivesY), color.getColor());
                    objectivesY += fontRenderer.field_78288_b + 2;
                }
            }
            this.startedQuestTimeline.tick(event.getPartialTicks());
            this.completeQuestTimeline.tick(event.getPartialTicks());
            this.objectivesTimeline.tick(event.getPartialTicks());
        }
    }

    public void onTick() {
        if (!(this.completedQuestQueue.isEmpty() || this.completeQuestTimeline.isPlaying() || this.startedQuestTimeline.isPlaying())) {
            this.startCompleteQuestNotification(this.completedQuestQueue.poll());
        }
        if (!(this.startedQuestQueue.isEmpty() || this.startedQuestTimeline.isPlaying() || this.completeQuestTimeline.isPlaying())) {
            this.startNewQuestNotification(this.startedQuestQueue.poll());
        }
        if (!this.objectivesChangedQueue.isEmpty() && !this.objectivesTimeline.isPlaying()) {
            String objective = this.objectivesChangedQueue.poll();
            this.startObjectivesChanged(objective);
        }
    }

    public void startCompleteQuestNotification(QuestStack questStack) {
        Minecraft.func_71410_x().field_71439_g.func_184185_a(MatterOverdriveSounds.guiQuestComplete, 1.0f, 1.0f);
        if (questStack != null) {
            this.completeQuestName = questStack.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.completeQuestXp = questStack.getXP((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else {
            this.completeQuestName = "Test. This is a test";
            this.completeQuestXp = 256;
        }
        this.completeQuestTimeline.getSlice(1).setLength(this.completeQuestName.length() * 15);
        this.completeQuestTimeline.sort();
        this.completeQuestTimeline.replay();
    }

    public void startNewQuestNotification(QuestStack questStack) {
        Minecraft.func_71410_x().field_71439_g.func_184185_a(MatterOverdriveSounds.guiQuestStarted, 1.0f, 1.0f);
        this.newQuestName = questStack != null ? questStack.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g) : "Test. This is a test";
        this.startedQuestTimeline.getSlice(1).setLength(100 + this.newQuestName.length() * 5);
        this.startedQuestTimeline.sort();
        this.startedQuestTimeline.replay();
    }

    public void startObjectivesChanged(String objective) {
        int showTime = 0;
        if (objective != null) {
            this.objectiveChanged = objective;
            showTime = objective.length() * 4;
        } else {
            this.objectiveChanged = "Objectives changed 0/5";
        }
        this.objectivesTimeline.getSlice(1).setLength(showTime);
        this.objectivesTimeline.sort();
        this.objectivesTimeline.replay();
    }

    public void addCompletedQuest(QuestStack questStack) {
        this.completedQuestQueue.add(questStack);
    }

    public void addStartedQuest(QuestStack questStack) {
        this.startedQuestQueue.add(questStack);
    }

    public void addObjectivesChanged(QuestStack oldQuestStack, QuestStack newQestStack, QuestState questState) {
        for (int i = 0; i < questState.getObjectiveIds().length; ++i) {
            this.objectivesChangedQueue.add(newQestStack.getObjective((EntityPlayer)Minecraft.func_71410_x().field_71439_g, questState.getObjectiveIds()[i]));
        }
        if (this.objectivesTimeline.getTime() < 180.0f) {
            this.objectivesTimeline.setTime(180.0f);
        }
    }
}

