/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.client.data.Color;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class MOElementBase {
    protected final MOGuiBase gui;
    public MOElementBase parent;
    protected ResourceLocation texture;
    protected int posX;
    protected int posY;
    protected int posZ;
    protected int sizeX;
    protected int sizeY;
    protected int texW = 256;
    protected int texH = 256;
    protected String name;
    private FontRenderer fontRenderer;
    private boolean visible = true;
    private boolean enabled = true;
    private Color color = new Color(255, 255, 255);

    public MOElementBase(MOGuiBase gui, int posX, int posY) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
    }

    public MOElementBase(MOGuiBase gui, int posX, int posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.sizeX = width;
        this.sizeY = height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int r, int g, int b, int alpha) {
        this.color = new Color(r, g, b, alpha);
    }

    protected void ApplyColor() {
        if (this.color != null) {
            RenderUtils.applyColor(this.color);
        }
    }

    protected void ResetColor() {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getGlobalX() {
        int x = this.posX;
        if (this.parent != null) {
            x += this.parent.getGlobalX();
        }
        return x;
    }

    protected int getGlobalY() {
        int y = this.posY;
        if (this.parent != null) {
            y += this.parent.getGlobalY();
        }
        return y;
    }

    public MOElementBase setPosition(int var1, int var2) {
        this.posX = var1;
        this.posY = var2;
        return this;
    }

    public MOElementBase setSize(int var1, int var2) {
        this.sizeX = var1;
        this.sizeY = var2;
        return this;
    }

    public MOElementBase setTexture(String var1, int var2, int var3) {
        this.texture = new ResourceLocation(var1);
        this.texW = var2;
        this.texH = var3;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final MOElementBase setVisible(boolean var1) {
        this.visible = var1;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final MOElementBase setEnabled(boolean var1) {
        this.enabled = var1;
        return this;
    }

    public void update(int mouseX, int mouseY, float partialTicks) {
        this.update();
    }

    public void update() {
    }

    public abstract void updateInfo();

    public abstract void init();

    public abstract void addTooltip(List<String> var1, int var2, int var3);

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void drawModalRect(int var1, int var2, int var3, int var4, int var5) {
        this.gui.drawSizedModalRect(var1, var2, var3, var4, var5);
    }

    public void drawStencil(int xStart, int yStart, int xEnd, int yEnd, int flag) {
        GlStateManager.func_179090_x();
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glClearStencil((int)0);
        GlStateManager.func_179086_m((int)1024);
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181675_d();
        vb.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        vb.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181675_d();
        vb.func_181662_b((double)xStart, (double)yStart, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.func_179132_a((boolean)true);
    }

    public void drawTexturedModalRect(int var1, int var2, int var3, int var4, int var5, int var6) {
        this.gui.drawSizedTexturedModalRect(var1, var2, var3, var4, var5, var6, this.texW, this.texH);
    }

    public void drawCenteredString(FontRenderer var1, String var2, int var3, int var4, int var5) {
        var1.func_175063_a(var2, (float)(var3 - var1.func_78256_a(var2) / 2), (float)var4, var5);
    }

    public boolean onMousePressed(int var1, int var2, int var3) {
        return false;
    }

    public void onMouseReleased(int var1, int var2) {
    }

    public boolean onMouseWheel(int var1, int var2, int var3) {
        return false;
    }

    public boolean onKeyTyped(char var1, int var2) {
        return false;
    }

    public boolean intersectsWith(int var1, int var2) {
        return var1 >= this.posX && var1 <= this.posX + this.sizeX && var2 >= this.posY && var2 <= this.posY + this.sizeY;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer == null ? this.gui.getFontRenderer() : this.fontRenderer;
    }

    public MOElementBase setFontRenderer(FontRenderer var1) {
        this.fontRenderer = var1;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public MOElementBase setName(String var1) {
        this.name = var1;
        return this;
    }

    public final MOGuiBase getContainerScreen() {
        return this.gui;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getHeight() {
        return this.sizeY;
    }

    public final int getWidth() {
        return this.sizeX;
    }

    public final int getPosZ() {
        return this.posZ;
    }

    public final void setPosZ(int z) {
        this.posZ = z;
    }
}

