/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import java.util.List;
import matteroverdrive.client.data.Color;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementItemPreview;
import matteroverdrive.gui.element.ElementProgress;
import matteroverdrive.gui.element.ElementScanProgress;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.gui.element.MatterDatabaseListBox;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;

public class PageScanInfo
extends ElementBaseGroup {
    public static final String backgroundPath = "matteroverdrive:textures/gui/matter_scanner.png";
    public static final String LIST_ELEMENT_NAME = "list";
    public static final String SCROLL_UP_BUTTON_NAME = "scroll_up";
    public static final String SCROLL_DOWN_BUTTON_NAME = "scroll_down";
    public MatterDatabaseListBox list;
    private ItemPattern pattern;
    private ElementProgress scan_progress;
    private ElementScanProgress scan_info_graph;
    private MOElementTextField searchField;
    private MOElementButton scrollButtonUp;
    private MOElementButton scrollButtonDown;
    private ElementItemPreview itemPreview;

    public PageScanInfo(MOGuiBase gui, int posX, int posY, String name, ItemPattern pattern, ItemStack scanner) {
        super(gui, posX, posY);
        this.setName(name);
        this.pattern = pattern;
        this.scan_info_graph = new ElementScanProgress(gui, 94, 44);
        this.itemPreview = new ElementItemPreview(gui, 45, 44, null);
        this.scan_progress = new ElementProgress(gui, 79, 204, 44, 202, 39, 202, 62, 188, 105, 14, 142, 18);
        this.searchField = new MOElementTextField(gui, 41, 26, 242, 14);
        this.list = new MatterDatabaseListBox(gui, 3, 39, 42, 152, scanner);
        this.scrollButtonUp = new MOElementButton(gui, this, 11, 27, SCROLL_UP_BUTTON_NAME, 22, 188, 32, 188, 10, 10, backgroundPath);
        this.scrollButtonDown = new MOElementButton(gui, this, 11, 190, SCROLL_DOWN_BUTTON_NAME, 42, 188, 52, 188, 10, 10, backgroundPath);
        this.list.setName(LIST_ELEMENT_NAME);
        this.list.setFilter("");
        this.scan_progress.setTexture(backgroundPath, 256, 256);
        this.scan_progress.setMaxValue(100.0f);
        this.scan_progress.SetTextPostition(18, 5);
        this.scan_progress.setTextColor(new Color(255, 255, 255).getColor());
        this.scan_info_graph.setProgress(1.0f);
    }

    @Override
    public void init() {
        super.init();
        this.elements.add(this.scan_info_graph);
        this.elements.add(this.itemPreview);
        this.elements.add(this.scan_progress);
        this.elements.add(this.searchField);
        this.elements.add(this.scrollButtonUp);
        this.elements.add(this.scrollButtonDown);
        this.elements.add(this.list);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        ItemStack item = this.pattern.toItemStack(false);
        if (item != null) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.5f);
            List infos = item.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            if (MatterHelper.CanScan(item)) {
                String text = "Matter: " + String.valueOf(MatterHelper.getMatterAmountFromItem(item)) + " kM";
                infos.add(text);
            }
            RenderUtils.DrawMultilineInfo(infos, 50, 98, 8, 200, Color.WHITE.getColor());
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a("No Item Selected!", 80.0f, 90.0f, new Color(255, 150, 50).getColor());
        }
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.list.setFilter(this.searchField.getText());
        }
    }

    public void updateList(List<ItemPattern> list) {
        this.list.updateList(list);
    }

    public void setItemNBT(ItemPattern pattern) {
        this.pattern = pattern;
        ItemStack itemStack = pattern.toItemStack(false);
        this.scan_progress.setVisible(pattern != null && MatterHelper.CanScan(itemStack));
        this.scan_info_graph.setVisible(pattern != null);
        this.itemPreview.setVisible(pattern != null);
        if (pattern != null) {
            this.scan_progress.setValue(pattern.getProgress());
            this.scan_progress.setText(String.valueOf((int)((float)pattern.getProgress() / 100.0f * 100.0f)) + "%");
            this.scan_info_graph.setSeed(pattern.getItemID());
            this.itemPreview.setItemStack(itemStack);
        }
    }
}

