/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import java.io.File;
import java.util.concurrent.Future;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.thread.RegisterItemsFromRecipes;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class MatterRegistrationHandler {
    private Future matterCalculationThread;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        block11: {
            if (!load.getWorld().field_72995_K && load.getWorld().field_73011_w.getDimension() == 0) {
                File matterRegistryFile = this.getMatterRegistryFile(load.getWorld());
                File customHandlersFile = this.getCustomHandlersFile(load.getWorld());
                try {
                    MatterOverdrive.MATTER_REGISTRY.loadCustomHandlers(customHandlersFile);
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem while loading custom matter handlers", new Object[0]);
                }
                try {
                    if (MatterOverdrive.MATTER_REGISTRY.needsCalculation(matterRegistryFile) && MatterOverdrive.MATTER_REGISTRY.AUTOMATIC_CALCULATION) {
                        try {
                            this.runCalculationThread(load.getWorld());
                        }
                        catch (Exception e) {
                            MOLog.log(Level.ERROR, e, "There was a problem calculating Matter from Recipes or Furnaces", new Object[0]);
                        }
                        break block11;
                    }
                    try {
                        MatterOverdrive.MATTER_REGISTRY.loadFromFile(matterRegistryFile);
                    }
                    catch (Exception e) {
                        MOLog.log(Level.ERROR, e, "There was a problem loading the Matter Registry file.", new Object[0]);
                        if (MatterOverdrive.MATTER_REGISTRY.AUTOMATIC_CALCULATION) {
                            MOLog.log(Level.INFO, e, "Starting automatic matter calculation thread.", new Object[0]);
                            this.runCalculationThread(load.getWorld());
                            break block11;
                        }
                        MOLog.log(Level.INFO, e, "Automatic matter calculation disabled. To enable go to Matter Overdrive configs", new Object[0]);
                    }
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem while trying to load Matter Registry or trying to Calculate it", new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        if (!unload.getWorld().field_72995_K && unload.getWorld().field_73011_w.getDimension() == 0) {
            MatterOverdrive.MATTER_REGISTRY.unload();
        }
    }

    public void runCalculationThread(World world) {
        File matterRegistryFile = this.getMatterRegistryFile(world);
        if (this.matterCalculationThread != null) {
            MOLog.log(Level.INFO, "Old calculation thread is running. Stopping old calculation thread", new Object[0]);
            this.matterCalculationThread.cancel(true);
            this.matterCalculationThread = null;
        }
        this.matterCalculationThread = MatterOverdrive.THREAD_POOL.submit(new RegisterItemsFromRecipes(matterRegistryFile));
    }

    public void onRegistrationComplete() {
        PacketUpdateMatterRegistry updateMatterRegistry = new PacketUpdateMatterRegistry(MatterOverdrive.MATTER_REGISTRY);
        FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_73010_i.stream().filter(playerMP -> playerMP instanceof EntityPlayerMP).forEach(playerMP -> MatterOverdrive.NETWORK.sendTo(updateMatterRegistry, (EntityPlayerMP)playerMP));
    }

    private File getMatterRegistryFile(World world) {
        File worldDirectory = world.func_72860_G().func_75765_b();
        return new File(worldDirectory.getPath() + "/matter_registry.dat");
    }

    private File getCustomHandlersFile(World world) {
        File worldDirectory = world.func_72860_G().func_75765_b();
        return new File(worldDirectory.getPath() + "/custom_matter.json");
    }
}

