/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.init;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.internal.IItemBlockFactory;
import matteroverdrive.api.internal.OreDictItem;
import matteroverdrive.blocks.BlockAndroidSpawner;
import matteroverdrive.blocks.BlockAndroidStation;
import matteroverdrive.blocks.BlockBoundingBox;
import matteroverdrive.blocks.BlockChargingStation;
import matteroverdrive.blocks.BlockContractMarket;
import matteroverdrive.blocks.BlockDecomposer;
import matteroverdrive.blocks.BlockDecorative;
import matteroverdrive.blocks.BlockDecorativeColored;
import matteroverdrive.blocks.BlockDecorativeRotated;
import matteroverdrive.blocks.BlockFluidMatterPlasma;
import matteroverdrive.blocks.BlockFusionReactorCoil;
import matteroverdrive.blocks.BlockFusionReactorController;
import matteroverdrive.blocks.BlockFusionReactorIO;
import matteroverdrive.blocks.BlockGravitationalAnomaly;
import matteroverdrive.blocks.BlockGravitationalStabilizer;
import matteroverdrive.blocks.BlockHeavyMatterPipe;
import matteroverdrive.blocks.BlockHoloSign;
import matteroverdrive.blocks.BlockIndustrialGlass;
import matteroverdrive.blocks.BlockInscriber;
import matteroverdrive.blocks.BlockMatterAnalyzer;
import matteroverdrive.blocks.BlockMatterPipe;
import matteroverdrive.blocks.BlockMatterRecycler;
import matteroverdrive.blocks.BlockMicrowave;
import matteroverdrive.blocks.BlockNetworkPipe;
import matteroverdrive.blocks.BlockNetworkRouter;
import matteroverdrive.blocks.BlockNetworkSwitch;
import matteroverdrive.blocks.BlockPatternMonitor;
import matteroverdrive.blocks.BlockPatternStorage;
import matteroverdrive.blocks.BlockPylon;
import matteroverdrive.blocks.BlockReplicator;
import matteroverdrive.blocks.BlockSolarPanel;
import matteroverdrive.blocks.BlockSpacetimeAccelerator;
import matteroverdrive.blocks.BlockStarMap;
import matteroverdrive.blocks.BlockTransporter;
import matteroverdrive.blocks.BlockTritaniumCrate;
import matteroverdrive.blocks.BlockWeaponStation;
import matteroverdrive.blocks.MaterialTritanium;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.blocks.includes.MOBlockOre;
import matteroverdrive.blocks.world.DilithiumOre;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.items.includes.MOMachineBlockItem;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemColored;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MatterOverdriveBlocks {
    public static final List<IRecipe> recipes = new ArrayList<IRecipe>();
    public static List<Block> blocks = new ArrayList<Block>();
    public static List<Item> items = new ArrayList<Item>();
    public final MaterialTritanium TRITANIUM = new MaterialTritanium(MapColor.field_151667_k);
    public DilithiumOre dilithium_ore;
    public MOBlockOre tritaniumOre;
    public MOBlockOre tritanium_block;
    public MOBlock machine_hull;
    public BlockDecomposer decomposer;
    public BlockMatterRecycler recycler;
    public BlockReplicator replicator;
    public BlockMatterPipe matter_pipe;
    public BlockMatterPipe heavy_matter_pipe;
    public BlockNetworkPipe network_pipe;
    public BlockNetworkRouter network_router;
    public BlockMatterAnalyzer matter_analyzer;
    public BlockPatternMonitor pattern_monitor;
    public BlockPatternStorage pattern_storage;
    public BlockNetworkSwitch network_switch;
    public BlockSolarPanel solar_panel;
    public BlockGravitationalAnomaly gravitational_anomaly;
    public BlockGravitationalStabilizer gravitational_stabilizer;
    public BlockFusionReactorController fusion_reactor_controller;
    public BlockFusionReactorCoil fusion_reactor_coil;
    public BlockFusionReactorIO fusionReactorIO;
    public BlockFluidMatterPlasma blockMatterPlasma;
    public BlockFluidClassic blockMoltenTritanium;
    public BlockTritaniumCrate tritaniumCrate;
    public BlockTritaniumCrate[] tritaniumCrateColored;
    public BlockInscriber inscriber;
    public BlockContractMarket contractMarket;
    public BlockAndroidSpawner androidSpawner;
    public BlockSpacetimeAccelerator spacetimeAccelerator;
    public BlockPylon pylon;
    public BlockTransporter transporter;
    public BlockStarMap starMap;
    public BlockHoloSign holoSign;
    public BlockWeaponStation weapon_station;
    public BlockAndroidStation androidStation;
    public BlockChargingStation chargingStation;
    public BlockDecorative decorative_stripes;
    public BlockDecorative decorative_coils;
    public BlockDecorative decorative_clean;
    public BlockDecorative decorative_vent_dark;
    public BlockDecorative decorative_vent_bright;
    public BlockDecorative decorative_holo_matrix;
    public BlockDecorative decorative_tritanium_plate;
    public BlockDecorative decorative_tritanium_plate_stripe;
    public BlockDecorative decorative_carbon_fiber_plate;
    public BlockDecorative decorative_matter_tube;
    public BlockDecorative decorative_beams;
    public BlockDecorative decorative_floor_tiles;
    public BlockDecorative decorative_floor_tile_white;
    public BlockDecorative decorative_floor_tiles_green;
    public BlockDecorative decorative_floor_noise;
    public BlockDecorative decorative_white_plate;
    public BlockDecorative decorative_separator;
    public BlockDecorative decorative_tritanium_lamp;
    public BlockDecorative decorative_tritanium_plate_colored;
    public BlockDecorative decorative_engine_exhaust_plasma;
    public BlockMicrowave microwave;
    public BlockIndustrialGlass industrialGlass;
    public BlockBoundingBox boundingBox;
    private int registeredCount = 0;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        blocks.forEach(b -> event.getRegistry().register((IForgeRegistryEntry)b));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        items.forEach(i -> event.getRegistry().register((IForgeRegistryEntry)i));
        blocks.stream().filter(block -> block instanceof OreDictItem).forEach(block -> ((OreDictItem)block).registerOreDict());
    }

    public void init() {
        MOLog.info("Registering blocks", new Object[0]);
        this.dilithium_ore = this.register(new DilithiumOre(Material.field_151576_e, "dilithium_ore", "oreDilithium"));
        this.tritaniumOre = this.register(new MOBlockOre(Material.field_151576_e, "tritanium_ore", "oreTritanium"));
        this.tritaniumOre.func_149711_c(8.0f).func_149752_b(5.0f).setHarvestLevel("pickaxe", 2);
        this.tritanium_block = this.register(new MOBlockOre(this.TRITANIUM, "tritanium_block", "blockTritanium"));
        this.tritanium_block.func_149711_c(15.0f).func_149752_b(10.0f).setHarvestLevel("pickaxe", 2);
        this.machine_hull = this.register(new MOBlock(this.TRITANIUM, "machine_hull"));
        this.machine_hull.func_149711_c(15.0f).func_149752_b(8.0f).setHarvestLevel("pickaxe", 2);
        this.decomposer = this.register(new BlockDecomposer(this.TRITANIUM, "decomposer"));
        this.recycler = this.register(new BlockMatterRecycler(this.TRITANIUM, "matter_recycler"));
        this.replicator = this.register(new BlockReplicator(this.TRITANIUM, "replicator"));
        this.matter_pipe = this.register(new BlockMatterPipe(this.TRITANIUM, "matter_pipe"));
        this.heavy_matter_pipe = this.register(new BlockHeavyMatterPipe(this.TRITANIUM, "heavy_matter_pipe"));
        this.network_pipe = this.register(new BlockNetworkPipe(this.TRITANIUM, "network_pipe"));
        this.network_router = this.register(new BlockNetworkRouter(this.TRITANIUM, "network_router"));
        this.matter_analyzer = this.register(new BlockMatterAnalyzer(this.TRITANIUM, "matter_analyzer"));
        this.pattern_monitor = this.register(new BlockPatternMonitor(this.TRITANIUM, "pattern_monitor"));
        this.pattern_storage = this.register(new BlockPatternStorage(this.TRITANIUM, "pattern_storage"));
        this.network_switch = this.register(new BlockNetworkSwitch(this.TRITANIUM, "network_switch"));
        this.solar_panel = this.register(new BlockSolarPanel(this.TRITANIUM, "solar_panel"));
        this.gravitational_anomaly = this.register(new BlockGravitationalAnomaly(Material.field_151567_E, "gravitational_anomaly"));
        this.gravitational_stabilizer = this.register(new BlockGravitationalStabilizer(this.TRITANIUM, "gravitational_stabilizer"));
        this.fusion_reactor_controller = this.register(new BlockFusionReactorController(this.TRITANIUM, "fusion_reactor_controller"));
        this.fusion_reactor_coil = this.register(new BlockFusionReactorCoil(this.TRITANIUM, "fusion_reactor_coil"));
        this.fusionReactorIO = this.register(new BlockFusionReactorIO(this.TRITANIUM, "fusion_reactor_io"));
        this.blockMatterPlasma = this.register(new BlockFluidMatterPlasma(OverdriveFluids.matterPlasma, Material.field_151586_h));
        this.blockMoltenTritanium = this.register((BlockFluidClassic)new BlockFluidClassic((Fluid)OverdriveFluids.moltenTritanium, Material.field_151587_i).setRegistryName(new ResourceLocation("matteroverdrive", "molten_tritanium")));
        this.tritaniumCrate = this.register(new BlockTritaniumCrate(this.TRITANIUM, "tritanium_crate"));
        EnumDyeColor[] colors = EnumDyeColor.values();
        this.tritaniumCrateColored = new BlockTritaniumCrate[colors.length];
        for (EnumDyeColor color : colors) {
            this.tritaniumCrateColored[color.func_176765_a()] = this.register(new BlockTritaniumCrate(this.TRITANIUM, "tritanium_crate_" + color.func_176610_l()));
        }
        this.inscriber = this.register(new BlockInscriber(this.TRITANIUM, "inscriber"));
        this.contractMarket = this.register(new BlockContractMarket(this.TRITANIUM, "contract_market"));
        this.androidSpawner = this.register(new BlockAndroidSpawner(this.TRITANIUM, "android_spawner"));
        this.spacetimeAccelerator = this.register(new BlockSpacetimeAccelerator(this.TRITANIUM, "spacetime_accelerator"));
        this.pylon = this.register(new BlockPylon(this.TRITANIUM, "pylon"));
        this.transporter = this.register(new BlockTransporter(this.TRITANIUM, "transporter"));
        this.starMap = this.register(new BlockStarMap(this.TRITANIUM, "star_map"));
        this.holoSign = this.register(new BlockHoloSign(this.TRITANIUM, "holo_sign"));
        this.weapon_station = this.register(new BlockWeaponStation(this.TRITANIUM, "weapon_station"));
        this.androidStation = this.register(new BlockAndroidStation(this.TRITANIUM, "android_station"));
        this.chargingStation = this.register(new BlockChargingStation(this.TRITANIUM, "charging_station"));
        this.decorative_stripes = this.register(new BlockDecorative(this.TRITANIUM, "decorative.stripes", 5.0f, 1, 8.0f, 13938952));
        this.decorative_coils = this.register(new BlockDecorative(this.TRITANIUM, "decorative.coils", 5.0f, 1, 8.0f, 11952670));
        this.decorative_clean = this.register(new BlockDecorative(this.TRITANIUM, "decorative.clean", 5.0f, 1, 8.0f, 3885131));
        this.decorative_vent_dark = this.register(new BlockDecorative(this.TRITANIUM, "decorative.vent.dark", 5.0f, 1, 8.0f, 3291452));
        this.decorative_vent_bright = this.register(new BlockDecorative(this.TRITANIUM, "decorative.vent.bright", 5.0f, 1, 8.0f, 4148046));
        this.decorative_holo_matrix = this.register(new BlockDecorative(this.TRITANIUM, "decorative.holo_matrix", 3.0f, 1, 4.0f, 3291962));
        this.decorative_tritanium_plate = this.register(new BlockDecorative(this.TRITANIUM, "decorative.tritanium_plate", 10.0f, 1, 10.0f, 4674649));
        this.decorative_tritanium_plate_stripe = this.register(new BlockDecorative(this.TRITANIUM, "decorative.tritanium_plate_stripe", 10.0f, 1, 10.0f, 5727336));
        this.decorative_carbon_fiber_plate = this.register(new BlockDecorative(this.TRITANIUM, "decorative.carbon_fiber_plate", 10.0f, 1, 12.0f, 1842976));
        this.decorative_matter_tube = this.register(new BlockDecorativeRotated(Material.field_151592_s, "decorative.matter_tube", 3.0f, 1, 4.0f, 5277861));
        this.decorative_beams = this.register(new BlockDecorativeRotated(this.TRITANIUM, "decorative.beams", 8.0f, 1, 8.0f, 1974816));
        this.decorative_floor_tiles = this.register(new BlockDecorative(Material.field_151571_B, "decorative.floor_tiles", 4.0f, 0, 4.0f, 9801084));
        this.decorative_floor_tile_white = this.register(new BlockDecorative(Material.field_151571_B, "decorative.floor_tile_white", 4.0f, 0, 4.0f, 10724508));
        this.decorative_floor_tiles_green = this.register(new BlockDecorative(Material.field_151571_B, "decorative.floor_tiles_green", 4.0f, 0, 4.0f, 5462335));
        this.decorative_floor_noise = this.register(new BlockDecorative(Material.field_151571_B, "decorative.floor_noise", 4.0f, 0, 4.0f, 8355451));
        this.decorative_white_plate = this.register(new BlockDecorative(this.TRITANIUM, "decorative.white_plate", 8.0f, 1, 8.0f, 0xE3E3E3));
        this.decorative_separator = this.register(new BlockDecorativeRotated(this.TRITANIUM, "decorative.separator", 8.0f, 1, 8.0f, 3160119));
        this.decorative_tritanium_lamp = this.register(new BlockDecorativeRotated(this.TRITANIUM, "decorative.tritanium_lamp", 2.0f, 1, 4.0f, 13957365));
        this.decorative_tritanium_lamp.func_149715_a(1.0f);
        this.decorative_tritanium_plate_colored = this.register(new BlockDecorativeColored(this.TRITANIUM, "decorative.tritanium_plate_colored", 10.0f, 1, 10.0f, 0x505050));
        this.decorative_engine_exhaust_plasma = this.register(new BlockDecorative(Material.field_151570_A, "decorative.engine_exhaust_plasma", 1.0f, 1, 1.0f, 3701918));
        this.decorative_engine_exhaust_plasma.func_149715_a(1.0f);
        this.microwave = this.register(new BlockMicrowave(Material.field_151573_f, "microwave"));
        this.industrialGlass = this.register(new BlockIndustrialGlass(Material.field_151592_s, "industrial_glass"));
        this.boundingBox = this.register(new BlockBoundingBox("bounding_box"));
        MOLog.info("Finished registering blocks", new Object[0]);
        MOLog.info("Registered %d blocks", this.registeredCount);
    }

    protected <T extends Block> T register(T block) {
        ItemBlock itemBlock;
        if (block instanceof IItemBlockFactory) {
            itemBlock = ((IItemBlockFactory)block).createItemBlock();
        } else if (block instanceof MOBlockMachine) {
            itemBlock = new MOMachineBlockItem(block);
        } else if (block instanceof BlockDecorativeColored) {
            itemBlock = new ItemColored(block, false);
            itemBlock.setRegistryName(block.getRegistryName());
        } else {
            itemBlock = new ItemBlock(block);
            itemBlock.setRegistryName(block.getRegistryName());
        }
        return this.register(block, itemBlock);
    }

    protected <T extends Block> T register(T block, ItemBlock itemBlock) {
        if (block instanceof IConfigSubscriber) {
            MatterOverdrive.CONFIG_HANDLER.subscribe((IConfigSubscriber)block);
        }
        ++this.registeredCount;
        blocks.add(block);
        items.add((Item)itemBlock);
        return block;
    }
}

