/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.api.weapon.WeaponStats;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector2f;

public class Phaser
extends EnergyWeapon
implements IWeapon {
    public static final int MAX_LEVEL = 6;
    public static final int RANGE = 18;
    private static final double ENERGY_MULTIPLY = 2.1;
    private static final int MAX_USE_TIME = 60;
    private static final int MAX_HEAT = 80;
    private static final int KILL_MODE_LEVEL = 3;
    private static final float KILL_DAMAGE_MULTIPLY = 2.0f;
    private static final int STUN_SLEEP_MULTIPLY = 5;
    final Map<EntityPlayer, WeaponSound> soundMap;

    public Phaser(String name) {
        super(name, 18);
        this.field_77789_bW = true;
        this.soundMap = new HashMap<EntityPlayer, WeaponSound>();
    }

    public static boolean isKillMode(ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74771_c("power") >= 3;
    }

    @Override
    protected int getCapacity() {
        return 32000;
    }

    @Override
    protected int getInput() {
        return 128;
    }

    @Override
    protected int getOutput() {
        return 128;
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        return (int)Math.pow(2.1, level + 1);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
        infos.add(TextFormatting.BLUE + "Stun: " + (float)this.GetSleepTime(weapon) / 20.0f + "s");
    }

    public int func_77626_a(ItemStack item) {
        return 60;
    }

    @Override
    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    private void ManageShooting(ItemStack item, World w, EntityPlayer player, int useCount) {
        if (w.field_72995_K) {
            return;
        }
        Vec3d dir = this.getPlayerLook(player, item);
        RayTraceResult hit = MOPhysicsHelper.rayTrace((EntityLivingBase)player, w, this.getRange(item), 0.0f, new Vec3d(0.0, (double)player.func_70047_e(), 0.0), false, true, dir);
        if (hit != null) {
            Vec3d hitVector = hit.field_72307_f;
            if (hit.field_72308_g != null && hit.field_72308_g instanceof EntityLivingBase) {
                if (hit.field_72308_g instanceof EntityPlayer && FMLCommonHandler.instance().getSide() == Side.SERVER && !player.func_184102_h().func_71219_W()) {
                    return;
                }
                DamageSource damageInfo = this.getDamageSource(item, player);
                float damage = this.getWeaponScaledDamage(item, (EntityLivingBase)player);
                EntityLivingBase el = (EntityLivingBase)hit.field_72308_g;
                double motionX = el.field_70159_w;
                double motionY = el.field_70181_x;
                double moutionZ = el.field_70179_y;
                if (damage > 0.0f) {
                    el.func_70097_a(damageInfo, damage);
                    el.field_70159_w = motionX;
                    el.field_70181_x = motionY;
                    el.field_70179_y = moutionZ;
                }
                el.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), this.GetSleepTime(item), 100));
                el.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"mining_fatigue"), this.GetSleepTime(item), 100));
                el.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"jump_boost"), this.GetSleepTime(item), -10));
                if (WeaponHelper.hasStat(WeaponStats.FIRE_DAMAGE, item) && Phaser.isKillMode(item)) {
                    el.func_70015_d(Math.round(WeaponHelper.modifyStat(WeaponStats.FIRE_DAMAGE, item, 0.0f) * (float)item.func_77978_p().func_74771_c("power")));
                } else if (WeaponHelper.hasStat(WeaponStats.HEAL, item)) {
                    el.func_70691_i(WeaponHelper.modifyStat(WeaponStats.HEAL, item, 0.0f) * (float)item.func_77978_p().func_74771_c("power"));
                }
            } else if (WeaponHelper.hasStat(WeaponStats.FIRE_DAMAGE, item)) {
                BlockPos pos = hit.func_178782_a();
                if (hit.field_72313_a == RayTraceResult.Type.BLOCK && player.field_70170_p.func_180495_p(pos).func_177230_c().isFlammable((IBlockAccess)player.field_70170_p, pos, hit.field_178784_b)) {
                    pos.func_177972_a(hit.field_178784_b);
                    if (player.func_175151_a(pos, hit.field_178784_b, item) && player.field_70170_p.func_175623_d(pos)) {
                        player.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            if (Phaser.isKillMode(item) && useCount % this.getShootCooldown(item) == this.getShootCooldown(item) / 2 && WeaponHelper.hasStat(WeaponStats.EXPLOSION_DAMAGE, item)) {
                w.func_72876_a((Entity)player, hitVector.field_72450_a, hitVector.field_72448_b, hitVector.field_72449_c, WeaponHelper.modifyStat(WeaponStats.EXPLOSION_DAMAGE, item, 0.0f) * (float)item.func_77978_p().func_74771_c("power") - 3.0f, true);
            }
        }
    }

    public Vec3d getPlayerLook(EntityPlayer player, ItemStack weapon) {
        Vec3d dir = player.func_70040_Z();
        Vec3d rot = this.getBeamRotation(weapon, player);
        dir.func_178785_b((float)rot.field_72450_a);
        dir.func_178789_a((float)rot.field_72448_b);
        return dir;
    }

    public Vec3d getBeamRotation(ItemStack weapon, EntityPlayer entityPlayer) {
        double rotationY = (float)Math.toRadians(5.0) * MOEasing.Quart.easeIn(this.getAccuracy(weapon, (EntityLivingBase)entityPlayer, false), 0.0f, 1.0f, 1.0f);
        return new Vec3d(0.0, rotationY, 0.0);
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        return this.getHeat(weapon) / this.getMaxHeat(weapon);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        this.TagCompountCheck(itemStackIn);
        if (!playerIn.func_70093_af()) {
            if (this.canFire(itemStackIn, worldIn, (EntityLivingBase)playerIn)) {
                playerIn.func_184598_c(hand);
            }
            if (this.needsRecharge(itemStackIn)) {
                this.chargeFromEnergyPack(itemStackIn, playerIn);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        this.SwitchModes(worldIn, playerIn, itemStackIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (this.canFire(stack, player.field_70170_p, player)) {
            this.DrainEnergy(stack, 1.0f, false);
            int powerLevelMultiply = (this.getPowerLevel(stack) + 1) / 6;
            float newHeat = (this.getHeat(stack) + 1.0f) * (1.1f + 0.05f * (float)powerLevelMultiply);
            this.setHeat(stack, newHeat);
            this.ManageShooting(stack, player.field_70170_p, (EntityPlayer)player, count);
            this.manageOverheat(stack, player.field_70170_p, player);
        } else {
            player.func_184602_cy();
        }
    }

    private void SwitchModes(World world, EntityPlayer player, ItemStack item) {
        this.TagCompountCheck(item);
        SoundHandler.PlaySoundAt(world, MatterOverdriveSounds.weaponsPhaserSwitchMode, SoundCategory.PLAYERS, (Entity)player);
        byte level = this.getPowerLevel(item);
        level = (byte)(level + 1);
        if (level >= 6) {
            level = 0;
        }
        this.setPowerLevel(item, level);
    }

    @Override
    public float getWeaponBaseDamage(ItemStack item) {
        float damage = 0.0f;
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        if (level >= 3) {
            damage = (float)Math.pow(2.0, level - 2);
        }
        return damage;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world, EntityLivingBase shooter) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, 1.0f, true) && !this.isEntitySpectator(shooter);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
    }

    private int GetSleepTime(ItemStack item) {
        this.TagCompountCheck(item);
        byte level = this.getPowerLevel(item);
        if (level < 3) {
            return (int)(Math.pow(level + 1, 5.0) * this.sleepTimeMultipy(item));
        }
        return 0;
    }

    private double sleepTimeMultipy(ItemStack phaser) {
        return WeaponHelper.modifyStat(WeaponStats.DAMAGE, phaser, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
        }
        return new Vector2f(200.0f, (float)(60 + (slot - 4) * 22));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 90.0f);
            }
            case 1: {
                return new Vector2f(100.0f, 80.0f);
            }
            case 2: {
                return new Vector2f(85.0f, 90.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onProjectileHit(RayTraceResult hit, ItemStack weapon, World world, float amount) {
        if (hit.func_178782_a() == null) {
            return;
        }
        IBlockState b = world.func_180495_p(hit.func_178782_a());
        if (hit.field_72308_g != null && hit.field_72308_g instanceof EntityLivingBase) {
            if (WeaponHelper.hasStat(WeaponStats.HEAL, weapon)) {
                world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            } else if (WeaponHelper.hasStat(WeaponStats.FIRE_DAMAGE, weapon) && Phaser.isKillMode(weapon)) {
                world.func_175688_a(EnumParticleTypes.FLAME, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            } else if (Phaser.isKillMode(weapon)) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (!b.func_177230_c().isAir(b, (IBlockAccess)world, hit.func_178782_a())) {
            if (WeaponHelper.hasStat(WeaponStats.FIRE_DAMAGE, weapon) && Phaser.isKillMode(weapon)) {
                world.func_175688_a(EnumParticleTypes.FLAME, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return slot != 3;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        return !module.func_190926_b() && (module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_barrel || module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_color);
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3d position, Vec3d dir, int delay) {
        return false;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    public int getBaseShootCooldown(ItemStack weapon) {
        return 10;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityLivingBase entityPlayer, ItemStack weapon) {
        return false;
    }

    @Override
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return new WeaponSound(MatterOverdriveSounds.weaponsPhaserBeam, SoundCategory.PLAYERS, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, field_77697_d.nextFloat() * 0.05f + 0.2f, 1.0f);
    }

    public byte getPowerLevel(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            return weapon.func_77978_p().func_74771_c("power");
        }
        return 0;
    }

    public void setPowerLevel(ItemStack weapon, byte level) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_74774_a("power", level);
        }
    }
}

