/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.pattern_monitor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.matter_network.IMatterNetworkComponent;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.container.matter_network.IMatterDatabaseMonitor;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.pattern_monitor.ComponentMatterNetworkPatternMonitor;
import matteroverdrive.machines.pattern_monitor.ComponentTaskProcessingPatternMonitor;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityMachinePatternMonitor
extends MOTileEntityMachine
implements IMatterNetworkClient,
IMatterDatabaseMonitor,
IMatterNetworkDispatcher,
IMatterNetworkConnection {
    private ComponentMatterNetworkPatternMonitor networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;
    private ComponentTaskProcessingPatternMonitor taskProcessingComponent;

    public TileEntityMachinePatternMonitor() {
        super(4);
        this.playerSlotsHotbar = true;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.networkComponent = new ComponentMatterNetworkPatternMonitor(this);
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.taskProcessingComponent = new ComponentTaskProcessingPatternMonitor("Replication Tasks", this, 8, 0);
        this.addComponent(this.networkComponent);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.taskProcessingComponent);
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
        return facing.func_176734_d() == side;
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        return this.networkComponent.establishConnectionFromSide(blockState, side);
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
        this.networkComponent.breakConnection(blockState, side);
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.networkComponent.getNetwork();
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.networkComponent.setNetwork(network);
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.networkComponent.canConnectToNetworkNode(blockState, toNode, direction);
    }

    @Override
    public List<IMatterDatabase> getConnectedDatabases() {
        List<IMatterNetworkClient> clients = this.getNetwork().getClients();
        ArrayList<IMatterDatabase> databases = new ArrayList<IMatterDatabase>();
        for (IMatterNetworkClient client : clients) {
            if (!(client instanceof IMatterDatabase)) continue;
            databases.add((IMatterDatabase)((Object)client));
        }
        return databases;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public IMatterNetworkComponent getMatterNetworkComponent() {
        return this.networkComponent;
    }

    @Override
    public MatterNetworkTaskQueue getTaskQueue(int queueID) {
        return this.taskProcessingComponent.getTaskQueue();
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }
}

