/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import matteroverdrive.entity.android_player.AndroidEffects;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.util.MOLog;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class PacketSendAndroidEffects
extends PacketAbstract {
    int androidId;
    List<AndroidEffects.Effect> effects;

    public PacketSendAndroidEffects() {
    }

    public PacketSendAndroidEffects(int androidId, List<AndroidEffects.Effect> effects) {
        this.androidId = androidId;
        this.effects = effects;
    }

    public void fromBytes(ByteBuf buf) {
        this.androidId = buf.readInt();
        try {
            this.effects = AndroidEffects.readEffectsListFromBuffer(buf);
        }
        catch (IOException e) {
            MOLog.log(Level.ERROR, e, "There was a problem while receiving android effects for player", new Object[0]);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.androidId);
        try {
            AndroidEffects.writeEffectsListToPacketBuffer(this.effects, buf);
        }
        catch (IOException e) {
            MOLog.log(Level.ERROR, e, "There was a problem while sending android effects to player", new Object[0]);
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSendAndroidEffects> {
        @Override
        public void handleClientMessage(EntityPlayerSP player, PacketSendAndroidEffects message, MessageContext ctx) {
            Entity entity;
            if (message.effects != null && (entity = player.field_70170_p.func_73045_a(message.androidId)) instanceof EntityPlayer) {
                AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability(entity);
                androidPlayer.getAndroidEffects().updateEffectsFromList(message.effects);
            }
        }
    }
}

