/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.data.MinimapEntityInfo;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSendMinimapInfo
extends PacketAbstract {
    List<MinimapEntityInfo> entityInfos;

    public PacketSendMinimapInfo() {
    }

    public PacketSendMinimapInfo(List<MinimapEntityInfo> entityInfos) {
        this.entityInfos = entityInfos;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityInfos = new ArrayList<MinimapEntityInfo>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.entityInfos.add(new MinimapEntityInfo().readFromBuffer(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityInfos.size());
        for (MinimapEntityInfo entityInfo : this.entityInfos) {
            entityInfo.writeToBuffer(buf);
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSendMinimapInfo> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketSendMinimapInfo message, MessageContext ctx) {
            AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player);
            if (androidPlayer != null && androidPlayer.isAndroid()) {
                AndroidPlayer.setMinimapEntityInfo(message.entityInfos);
            }
        }
    }
}

