/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketAndroidChangeAbility
extends PacketAbstract {
    String ability;

    public PacketAndroidChangeAbility() {
    }

    public PacketAndroidChangeAbility(String ability) {
        this.ability = ability;
    }

    public void fromBytes(ByteBuf buf) {
        this.ability = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ability);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketAndroidChangeAbility> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketAndroidChangeAbility message, MessageContext ctx) {
            AndroidPlayer androidPlayer;
            IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(message.ability);
            if (stat != null && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player)).isUnlocked(stat, 0) && stat.showOnWheel(androidPlayer, androidPlayer.getUnlockedLevel(stat))) {
                androidPlayer.setActiveStat(stat);
                androidPlayer.sync(EnumSet.of(IAndroid.DataType.STATS));
            }
        }
    }
}

