/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.items.Contract;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.quest.PacketSyncQuests;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketQuestActions
extends PacketAbstract {
    public static final int QUEST_ACTION_ABONDON = 0;
    public static final int QUEST_ACTION_COMPLETE = 1;
    public static final int QUEST_ACTION_ADD = 2;
    public static final int QUEST_ACTION_COMPLETE_OBJECTIVE = 3;
    int command;
    int questID;
    int playerID;

    public PacketQuestActions() {
    }

    public PacketQuestActions(int command, int questID, int playerID) {
        this.command = command;
        this.questID = questID;
        this.playerID = playerID;
    }

    public PacketQuestActions(int command, int questID, EntityPlayer entityPlayer) {
        this.command = command;
        this.questID = questID;
        this.playerID = entityPlayer.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.command = buf.readInt();
        this.questID = buf.readInt();
        this.playerID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.command);
        buf.writeInt(this.questID);
        buf.writeInt(this.playerID);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketQuestActions> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketQuestActions message, MessageContext ctx) {
            OverdriveExtendedProperties extendedProperties;
            Entity entity = player.field_70170_p.func_73045_a(message.playerID);
            if (entity instanceof EntityPlayer && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)((EntityPlayer)entity))) != null) {
                ItemStack contract;
                if (message.questID < extendedProperties.getQuestData().getActiveQuests().size()) {
                    QuestStack questStack;
                    if (message.command == 1) {
                        questStack = extendedProperties.getQuestData().getActiveQuests().get(message.questID);
                        if (QuestStack.canComplete((EntityPlayer)entity, questStack)) {
                            questStack.markComplited((EntityPlayer)player, true);
                        }
                    } else {
                        if (message.command == 0) {
                            QuestStack abandonedQuest = extendedProperties.getQuestData().removeQuest(message.questID);
                            if (abandonedQuest != null) {
                                extendedProperties.onQuestAbandoned(abandonedQuest);
                            }
                            MatterOverdrive.NETWORK.sendTo(new PacketSyncQuests(extendedProperties.getQuestData(), EnumSet.of(PlayerQuestData.DataType.ACTIVE_QUESTS)), player);
                            return;
                        }
                        if (message.command == 3) {
                            questStack = extendedProperties.getQuestData().getActiveQuests().get(message.questID);
                            questStack.markComplited((EntityPlayer)entity, false);
                        }
                    }
                }
                if (message.command == 2 && (contract = extendedProperties.getPlayer().field_71071_by.func_70301_a(message.questID)).func_77973_b() instanceof Contract) {
                    extendedProperties.addQuest(((Contract)contract.func_77973_b()).getQuest(contract).copy());
                    extendedProperties.getPlayer().field_71071_by.func_70298_a(message.questID, 1);
                }
            }
        }
    }
}

