/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server.pattern_monitor;

import io.netty.buffer.ByteBuf;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.machines.pattern_monitor.ComponentTaskProcessingPatternMonitor;
import matteroverdrive.machines.pattern_monitor.TileEntityMachinePatternMonitor;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPatternMonitorAddRequest
extends TileEntityUpdatePacket {
    private ItemPattern pattern;
    private int amount;

    public PacketPatternMonitorAddRequest() {
    }

    public PacketPatternMonitorAddRequest(TileEntityMachinePatternMonitor monitor, ItemPattern pattern, int amount) {
        super(monitor);
        this.pattern = pattern;
        this.amount = amount;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.pattern = ItemPattern.fromBuffer(buf);
        this.amount = buf.readShort();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ItemPattern.writeToBuffer(buf, this.pattern);
        buf.writeShort(this.amount);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketPatternMonitorAddRequest> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketPatternMonitorAddRequest message, MessageContext ctx) {
            TileEntityMachinePatternMonitor monitor;
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity != null && entity instanceof TileEntityMachinePatternMonitor && (monitor = (TileEntityMachinePatternMonitor)entity) != null) {
                MatterNetworkTaskReplicatePattern task = new MatterNetworkTaskReplicatePattern(message.pattern, message.amount);
                task.setState(MatterNetworkTaskState.WAITING);
                monitor.getComponent(ComponentTaskProcessingPatternMonitor.class).addReplicateTask(task);
            }
        }
    }
}

