/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityPipe
extends MOTileEntity
implements ITickable {
    public static List<BlockPos> UPDATING_POS = new ArrayList<BlockPos>();
    protected boolean needsUpdate = true;
    protected boolean awoken;
    private int connections = 0;

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74768_a("connections", (int)((byte)this.getConnectionsMask()));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.setConnections(nbt.func_74762_e("connections"), false);
            this.needsUpdate = false;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        if (this.needsUpdate) {
            this.updateSides(true);
            this.needsUpdate = false;
        }
        UPDATING_POS.clear();
        if (!this.awoken) {
            this.onAwake(this.field_145850_b.field_72995_K ? Side.CLIENT : Side.SERVER);
            this.awoken = true;
        }
    }

    public void updateSides(boolean notify) {
        int connections = 0;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction));
            if (!this.canConnectToPipe(t, direction)) continue;
            connections |= 1 << direction.ordinal();
        }
        this.setConnections(connections, notify);
    }

    public int getConnectionsMask() {
        return this.connections;
    }

    public int getConnectionsCount() {
        int tot = 0;
        for (int con = this.connections; con > 0; con &= con - 1) {
            ++tot;
        }
        return tot;
    }

    public void setConnections(int connections, boolean notify) {
        this.connections = connections;
        if (notify) {
            UPDATING_POS.add(this.func_174877_v());
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!this.isConnectedFromSide(facing) || UPDATING_POS.contains(this.func_174877_v().func_177972_a(facing))) continue;
                this.field_145850_b.func_190524_a(this.func_174877_v().func_177972_a(facing), this.func_145838_q(), this.func_174877_v());
            }
            this.func_70296_d();
        }
    }

    public void setConnection(EnumFacing connection, boolean value) {
        this.connections = MOMathHelper.setBoolean(this.connections, connection.ordinal(), value);
        this.func_70296_d();
    }

    public boolean isConnectedFromSide(EnumFacing enumFacing) {
        return MOMathHelper.getBoolean(this.connections, enumFacing.ordinal());
    }

    public abstract boolean canConnectToPipe(TileEntity var1, EnumFacing var2);

    public void queueUpdate() {
        this.needsUpdate = true;
    }

    public boolean isConnectableSide(EnumFacing dir) {
        return MOMathHelper.getBoolean(this.connections, dir.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }
}

