/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import matteroverdrive.api.exceptions.MORuntimeException;
import matteroverdrive.util.MOLog;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.Level;

public class MOJsonHelper {
    private static String currentParentObject;

    public static boolean getBool(JsonObject jsonObject, String key, boolean def) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsBoolean();
        }
        return def;
    }

    public static int getInt(JsonObject jsonObject, String key, int def) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        return def;
    }

    public static int getInt(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsInt();
        }
        throw new MORuntimeException(String.format("Could not find key: '%s' in JSON Object '%s'", key, currentParentObject));
    }

    public static String getString(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsString();
        }
        throw new MORuntimeException(String.format("Could not find key: '%s' in JSON Object '%s'", key, currentParentObject));
    }

    public static String[] getStringArray(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            JsonArray array = jsonObject.getAsJsonArray(key);
            String[] strings = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                strings[i] = array.get(i).getAsString();
            }
            return strings;
        }
        throw new MORuntimeException(String.format("Could not find key: '%s' in JSON Object '%s'", key, currentParentObject));
    }

    public static String getString(JsonObject jsonObject, String key, String def) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return element.getAsJsonPrimitive().getAsString();
        }
        return def;
    }

    public static ItemStack getItemStack(JsonObject jsonObject, String key, ItemStack def) {
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            Item item = Item.func_111206_d((String)obj.get("id").getAsString());
            int count = MOJsonHelper.getInt(obj, "count", 1);
            int damage = MOJsonHelper.getInt(obj, "damage", 0);
            ItemStack itemStack = new ItemStack(item, count, damage);
            if (obj.has("nbt")) {
                try {
                    NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)obj.get("nbt").toString());
                    itemStack.func_77982_d(tagCompound);
                }
                catch (NBTException e) {
                    MOLog.log(Level.ERROR, e, "Could not parse NBT tag from Json in '%s'", new Object[0]);
                }
            }
            return itemStack;
        }
        return def;
    }

    public static Vec3d getVec3(JsonObject jsonObject, String key, Vec3d def) {
        JsonArray array;
        JsonElement element;
        if (jsonObject.has(key) && (element = jsonObject.get(key)).isJsonArray() && (array = element.getAsJsonArray()).size() == 3) {
            try {
                double x = array.get(0).getAsDouble();
                double y = array.get(1).getAsDouble();
                double z = array.get(2).getAsDouble();
                return new Vec3d(x, y, z);
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "All elements in Vec3 array must be decimals", new Object[0]);
            }
        }
        return def;
    }

    public static NBTTagCompound getNbt(JsonObject jsonObject, String key, NBTTagCompound def) {
        if (jsonObject.has(key)) {
            try {
                String json = jsonObject.get(key).toString();
                NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)json);
                MOJsonHelper.removeDoubleQuotes(tagCompound);
                return tagCompound;
            }
            catch (NBTException e) {
                MOLog.log(Level.ERROR, e, "Could not parse NBT tag from Json", new Object[0]);
            }
        }
        return def;
    }

    public static BlockPos getPos(JsonObject jsonObject, String key, BlockPos def) {
        JsonArray array;
        if (jsonObject.has(key) && (array = jsonObject.getAsJsonArray(key)).size() == 3) {
            return new BlockPos(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
        }
        return def;
    }

    public static void removeDoubleQuotes(NBTTagCompound tagCompound) {
        ArrayList cachedKeyList = new ArrayList();
        cachedKeyList.addAll(tagCompound.func_150296_c());
        for (String key : cachedKeyList) {
            NBTBase base = tagCompound.func_74781_a(key);
            tagCompound.func_82580_o(key);
            key = key.replace("\"", "");
            if (base instanceof NBTTagCompound) {
                MOJsonHelper.removeDoubleQuotes((NBTTagCompound)base);
            } else if (base instanceof NBTTagList) {
                MOJsonHelper.removeDoubleQuotes((NBTTagList)base);
            }
            tagCompound.func_74782_a(key, base);
        }
    }

    public static void removeDoubleQuotes(NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            if (tagList.func_179238_g(i) instanceof NBTTagCompound) {
                MOJsonHelper.removeDoubleQuotes((NBTTagCompound)tagList.func_179238_g(i));
                continue;
            }
            if (!(tagList.func_179238_g(i) instanceof NBTTagList)) continue;
            MOJsonHelper.removeDoubleQuotes((NBTTagList)tagList.func_179238_g(i));
        }
    }

    public static void setCurrentParentObject(String parentObject) {
        currentParentObject = parentObject;
    }
}

