/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.QuestStack;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestFactory {
    public QuestStack generateQuestStack(Random random, IQuest quest) {
        QuestStack questStack = new QuestStack(quest);
        quest.initQuestStack(random, questStack);
        return questStack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getFormattedQuestObjective(EntityPlayer entityPlayer, QuestStack questStack, int objectiveInex) {
        boolean isCompleted = questStack.isObjectiveCompleted(entityPlayer, objectiveInex);
        if (isCompleted) {
            return TextFormatting.GREEN + "\u25a0" + " " + questStack.getObjective(entityPlayer, objectiveInex);
        }
        return TextFormatting.DARK_GREEN + "\u25a1" + " " + questStack.getObjective(entityPlayer, objectiveInex);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedQuestObjective(EntityPlayer entityPlayer, QuestStack questStack, int objectiveInex, int length) {
        return this.getFormattedQuestObjective(entityPlayer, questStack, objectiveInex, length, TextFormatting.DARK_GREEN.toString(), TextFormatting.GREEN.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getFormattedQuestObjective(EntityPlayer entityPlayer, QuestStack questStack, int objectiveInex, int length, String uncompletedPrefix, String completedPrefix) {
        List objectiveLines = Minecraft.func_71410_x().field_71466_p.func_78271_c(questStack.getObjective(entityPlayer, objectiveInex), length);
        boolean isObjectiveComplete = questStack.isObjectiveCompleted((EntityPlayer)Minecraft.func_71410_x().field_71439_g, objectiveInex);
        for (int o = 0; o < objectiveLines.size(); ++o) {
            String line = "";
            if (isObjectiveComplete) {
                line = line + completedPrefix;
                if (o == 0) {
                    line = line + "\u25a0 ";
                }
            } else {
                line = line + uncompletedPrefix;
                if (o == 0) {
                    line = line + "\u25a1 ";
                }
            }
            line = line + (String)objectiveLines.get(o);
            objectiveLines.set(o, line);
        }
        return objectiveLines;
    }

    public QuestStack generateQuestStack(String questName) {
        IQuest quest = MatterOverdrive.QUESTS.getQuestByName(questName);
        if (quest != null) {
            QuestStack questStack = new QuestStack(quest);
            quest.initQuestStack(MatterOverdrive.QUESTS.random, questStack);
            return questStack;
        }
        return null;
    }
}

