/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.util.StackUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    private static float lastLightMapX;
    private static float lastLightMapY;

    public static void renderStack(int x, int y, ItemStack stack) {
        RenderUtils.renderStack(x, y, 100, stack, false);
    }

    public static void renderStack(int x, int y, int z, ItemStack stack, boolean renderOverlay) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)z);
            RenderUtils.renderItem.field_77023_b = -150.0f;
            FontRenderer font = null;
            if (!stack.func_190926_b()) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = Minecraft.func_71410_x().field_71466_p;
            }
            renderItem.func_180450_b(stack, x, y);
            if (renderOverlay) {
                RenderUtils.renderItemOverlayIntoGUI(font, stack, x, y, stack.func_190916_E() > 1 ? Integer.toString(stack.func_190916_E()) : null);
            }
            RenderUtils.renderItem.field_77023_b = 0.0f;
            GlStateManager.func_179141_d();
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, String text) {
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                if (text == null && stack.func_190916_E() < 1) {
                    s = TextFormatting.RED + String.valueOf(stack.func_190916_E());
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179084_k();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)3.0f);
                fr.func_175063_a(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                GlStateManager.func_179145_e();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int j = (int)Math.round(13.0 - health * 13.0);
                int i = (int)Math.round(255.0 - health * 255.0);
                GlStateManager.func_179140_f();
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder worldrenderer = tessellator.func_178180_c();
                RenderUtils.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderUtils.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderUtils.func_181565_a(worldrenderer, xPosition + 2, yPosition + 13, j, 1, 255 - i, i, 0, 255);
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
            }
        }
    }

    private static void func_181565_a(BufferBuilder bufferBuilder, int posX, int posY, int p_181565_4_, int p_181565_5_, int p_181565_6_, int p_181565_7_, int p_181565_8_, int p_181565_9_) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b((double)posX, (double)posY, 0.0).func_181669_b(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        bufferBuilder.func_181662_b((double)posX, (double)(posY + p_181565_5_), 0.0).func_181669_b(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        bufferBuilder.func_181662_b((double)(posX + p_181565_4_), (double)(posY + p_181565_5_), 0.0).func_181669_b(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        bufferBuilder.func_181662_b((double)(posX + p_181565_4_), (double)posY, 0.0).func_181669_b(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderStack(int x, int y, ItemStack stack, float opacity) {
        if (!StackUtils.isNullOrEmpty(stack)) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179132_a((boolean)true);
            RenderHelper.func_74520_c();
            renderItem.func_175042_a(stack, x, y);
            RenderHelper.func_74518_a();
            GlStateManager.func_179089_o();
        }
    }

    public static void rotateFromBlock(World world, BlockPos pos) {
        if (world != null) {
            IBlockState blockState = world.func_180495_p(pos);
            EnumFacing rotation = (EnumFacing)blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
            switch (rotation) {
                case WEST: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
        }
    }

    public static void rotateFromBlock(Matrix4f mat, IBlockAccess world, BlockPos pos) {
        if (world != null) {
            IBlockState blockState = world.func_180495_p(pos);
            EnumFacing rotation = (EnumFacing)blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
            Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
            if (rotation == EnumFacing.WEST) {
                mat.rotate(-1.5707964f, axis);
            } else if (rotation == EnumFacing.EAST) {
                mat.rotate(1.5707964f, axis);
            } else if (rotation == EnumFacing.NORTH) {
                mat.rotate((float)(-Math.PI), axis);
            }
        }
    }

    public static void drawCircle(double radius, int segments) {
        GL11.glBegin((int)9);
        for (int i = 0; i < segments; ++i) {
            GL11.glVertex3d((double)(Math.sin((double)i / (double)segments * Math.PI * 2.0) * radius), (double)(Math.cos((double)i / (double)segments * Math.PI * 2.0) * radius), (double)0.0);
        }
        GL11.glEnd();
    }

    public static void drawPlane(double size) {
        RenderUtils.drawPlane(size, size);
    }

    public static void drawPlane(double x, double y, double z, double sizeX, double sizeY) {
        RenderUtils.drawPlaneWithUV(x, y, z, sizeX, sizeY, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawPlane(double sizeX, double sizeY) {
        RenderUtils.drawPlaneWithUV(0.0, 0.0, 0.0, sizeX, sizeY, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawPlaneWithUV(double sizeX, double sizeY, double uStart, double vStart, double uSize, double vSize) {
        RenderUtils.drawPlaneWithUV(0.0, 0.0, 0.0, sizeX, sizeY, uStart, vStart, uSize, vSize);
    }

    public static void drawPlaneWithUV(double x, double y, double z, double sizeX, double sizeY, double uStart, double vStart, double uSize, double vSize) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(uStart + uSize, vStart + vSize).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z).func_187315_a(uStart + uSize, vStart).func_181675_d();
        wr.func_181662_b(x, y, z).func_187315_a(uStart, vStart).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z).func_187315_a(uStart, vStart + vSize).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawPlaneWithUV(double x, double y, double z, double sizeX, double sizeY, double uStart, double vStart, double uSize, double vSize, Color color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        wr.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(uStart + uSize, vStart + vSize).func_181666_a(color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA()).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z).func_187315_a(uStart + uSize, vStart).func_181666_a(color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA()).func_181675_d();
        wr.func_181662_b(x, y, z).func_187315_a(uStart, vStart).func_181666_a(color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA()).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z).func_187315_a(uStart, vStart + vSize).func_181666_a(color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawStencil(int xMin, int yMin, int xMax, int yMax, int mask) {
        GlStateManager.func_179090_x();
        GL11.glStencilFunc((int)519, (int)mask, (int)mask);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b((double)xMin, (double)yMax, 0.0).func_181675_d();
        wr.func_181662_b((double)xMax, (double)yMax, 0.0).func_181675_d();
        wr.func_181662_b((double)xMax, (double)yMin, 0.0).func_181675_d();
        wr.func_181662_b((double)xMin, (double)yMin, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glStencilFunc((int)514, (int)mask, (int)mask);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GL11.glDepthMask((boolean)true);
    }

    public static void drawCube(double sizeX, double sizeY, double sizeZ, Color color) {
        RenderUtils.drawCube(0.0, 0.0, 0.0, sizeX, sizeY, sizeZ, color);
    }

    public static void drawCube(double sizeX, double sizeY, double sizeZ, Color color, float multiply) {
        RenderUtils.drawCube(0.0, 0.0, 0.0, sizeX, sizeY, sizeZ, new Color((int)((float)color.getIntR() * multiply), (int)((float)color.getIntG() * multiply), (int)((float)color.getIntB() * multiply)));
    }

    public static void drawCube(double x, double y, double z, double sizeX, double sizeY, double sizeZ, Color color) {
        RenderUtils.drawCube(x, y, z, sizeX, sizeY, sizeZ, 0.0, 0.0, 1.0, 1.0, color);
    }

    public static void drawCube(double x, double y, double z, double sizeX, double sizeY, double sizeZ, double minU, double minV, double maxU, double maxV, Color color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        if (color != null) {
            r = color.getFloatR();
            g = color.getFloatG();
            b = color.getFloatB();
            a = color.getFloatA();
        }
        wr.func_181662_b(x, y, z).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z + sizeZ).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, z + sizeZ).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z + sizeZ).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z + sizeZ).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, z).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, z + sizeZ).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z + sizeZ).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z + sizeZ).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z + sizeZ).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, z).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y + sizeY, z + sizeZ).func_187315_a(minU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x, y, z + sizeZ).func_187315_a(minU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y, z + sizeZ).func_187315_a(maxU, minV).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b(x + sizeX, y + sizeY, z + sizeZ).func_187315_a(maxU, maxV).func_181666_a(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static int lerp(int a, int b, float lerp) {
        int MASK1 = 0xFF00FF;
        int MASK2 = 65280;
        int f2 = Math.round(256.0f * lerp);
        int f1 = Math.round(256 - f2);
        return (a & MASK1) * f1 + (b & MASK1) * f2 >> 8 & MASK1 | (a & MASK2) * f1 + (b & MASK2) * f2 >> 8 & MASK2;
    }

    public static Color lerp(Color a, Color b, float lerp) {
        return new Color(RenderUtils.lerp(a.getIntR(), b.getIntR(), lerp), RenderUtils.lerp(a.getIntG(), b.getIntG(), lerp), RenderUtils.lerp(a.getIntB(), b.getIntB(), lerp), RenderUtils.lerp(a.getIntA(), b.getIntA(), lerp));
    }

    public static void applyColor(int color) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 256.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void applyColor(Color color) {
        GlStateManager.func_179124_c((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB());
    }

    public static void applyColorWithMultipy(Color color, float mul) {
        GlStateManager.func_179124_c((float)(color.getFloatR() * mul), (float)(color.getFloatG() * mul), (float)(color.getFloatB() * mul));
    }

    public static void applyColorWithMultipy(int color, float mul) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f * mul), (float)((float)(color >> 8 & 0xFF) / 255.0f * mul), (float)((float)(color & 0xFF) / 256.0f * mul), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void applyColorWithAdd(Color color, float add) {
        GlStateManager.func_179124_c((float)(color.getFloatR() + add), (float)(color.getFloatG() + add), (float)(color.getFloatB() + add));
    }

    public static void applyColorWithAlpha(Color color, float alphaMultiply) {
        GlStateManager.func_179131_c((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)(color.getFloatA() * alphaMultiply));
    }

    public static void applyColorWithAlpha(Color color) {
        GlStateManager.func_179131_c((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)color.getFloatA());
    }

    public static void beginDrawinngBlockScreen(double x, double y, double z, EnumFacing side, Color color, TileEntity entity) {
        RenderUtils.beginDrawinngBlockScreen(x, y, z, side, color, entity, 0.05, 1.0f);
    }

    public static void beginDrawinngBlockScreen(double x, double y, double z, EnumFacing side, Color color, TileEntity entity, double offset, float glowAlpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        RenderUtils.disableLightmap();
        Vector3f dir = new Vector3f((float)side.func_176730_m().func_177958_n(), (float)side.func_176730_m().func_177956_o(), (float)side.func_176730_m().func_177952_p());
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f c = Vector3f.cross((Vector3f)front, (Vector3f)dir, null);
        double omega = Math.acos(Vector3f.dot((Vector3f)front, (Vector3f)dir));
        if (omega == Math.PI) {
            c.y = 1.0f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)dir.x * (0.5 + offset)), (double)((double)dir.y * (0.5 + offset)), (double)((double)dir.z * (0.5 + offset)));
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)((float)(omega * 57.29577951308232)), (float)c.x, (float)c.y, (float)c.z);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
        GlStateManager.func_179112_b((int)1, (int)769);
        float multiply = (float)(MOMathHelper.noise(entity.func_174877_v().func_177958_n(), (double)entity.func_145831_w().func_72820_D() * 0.01, entity.func_174877_v().func_177952_p()) * 0.5 + 0.5) * glowAlpha;
        GlStateManager.func_179124_c((float)(color.getFloatR() * multiply), (float)(color.getFloatG() * multiply), (float)(color.getFloatB() * multiply));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityRendererPatternMonitor.screenTextureGlow);
        RenderUtils.drawPlane(1.0);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.05);
        GlStateManager.func_179124_c((float)(color.getFloatR() * 0.05f), (float)(color.getFloatG() * 0.05f), (float)(color.getFloatB() * 0.05f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityRendererPatternMonitor.screenTextureBack);
        RenderUtils.drawPlane(1.0);
    }

    public static void drawScreenInfoWithGlobalAutoSize(String[] info, Color color, EnumFacing side, int leftMargin, int rightMargin, float maxScaleFactor) {
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.03f);
        GlStateManager.func_179152_a((float)0.01f, (float)0.01f, (float)0.01f);
        int height = 0;
        int maxWidth = 0;
        int sizeX = 100 - leftMargin - rightMargin;
        int sizeY = 80;
        float scaleFactor = 1.0f;
        for (String anInfo : info) {
            if (maxWidth >= fontRenderer.func_78256_a(anInfo)) continue;
            maxWidth = fontRenderer.func_78256_a(anInfo);
        }
        if (maxWidth > 0) {
            scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)maxWidth), (float)0.02f, (float)maxScaleFactor);
        }
        for (String anInfo : info) {
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (height + scaledHeight >= sizeY) continue;
            height += scaledHeight;
        }
        height = MathHelper.func_76125_a((int)height, (int)0, (int)sizeY);
        int yCount = 0;
        for (String anInfo : info) {
            GlStateManager.func_179094_E();
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (yCount + scaledHeight >= sizeY) {
                GlStateManager.func_179121_F();
                break;
            }
            int width = fontRenderer.func_78256_a(anInfo);
            GlStateManager.func_179109_b((float)(leftMargin + sizeX / 2), (float)(50 + yCount + scaledHeight / 2 - height / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)0.0f);
            fontRenderer.func_78276_b(anInfo, -width / 2, -RenderUtils.fontRenderer.field_78288_b / 2, color.getColor());
            GlStateManager.func_179121_F();
            yCount += scaledHeight;
        }
        GlStateManager.func_179121_F();
    }

    public static void drawScreenInfoWithLocalAutoSize(String[] info, Color color, EnumFacing side, int leftMargin, int rightMargin, float maxScaleFactor) {
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.03f);
        GlStateManager.func_179152_a((float)0.01f, (float)0.01f, (float)0.01f);
        int height = 0;
        int maxWidth = 0;
        int sizeX = 100 - leftMargin - rightMargin;
        int sizeY = 80;
        for (String anInfo : info) {
            float scaleFactor = 1.0f;
            int width = fontRenderer.func_78256_a(anInfo);
            if (width > 0) {
                scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)width), (float)0.02f, (float)maxScaleFactor);
            }
            int scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor);
            if (maxWidth < fontRenderer.func_78256_a(anInfo)) {
                maxWidth = fontRenderer.func_78256_a(anInfo);
            }
            if (height + scaledHeight >= sizeY) continue;
            height += scaledHeight;
        }
        height = MathHelper.func_76125_a((int)height, (int)0, (int)sizeY);
        int yCount = 0;
        for (String anInfo : info) {
            int scaledHeight;
            GlStateManager.func_179094_E();
            float scaleFactor = 1.0f;
            int width = fontRenderer.func_78256_a(anInfo);
            if (width > 0) {
                scaleFactor = MathHelper.func_76131_a((float)((float)sizeX / (float)width), (float)0.02f, (float)maxScaleFactor);
            }
            if (yCount + (scaledHeight = (int)((float)RenderUtils.fontRenderer.field_78288_b * scaleFactor)) >= sizeY) {
                GlStateManager.func_179121_F();
                break;
            }
            GlStateManager.func_179109_b((float)(leftMargin + sizeX / 2), (float)(50 + yCount + scaledHeight / 2 - height / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)0.0f);
            fontRenderer.func_78276_b(anInfo, -width / 2, -RenderUtils.fontRenderer.field_78288_b / 2, color.getColor());
            GlStateManager.func_179121_F();
            yCount += scaledHeight;
        }
        GlStateManager.func_179121_F();
    }

    public static void endDrawinngBlockScreen() {
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    public static void disableLightmap() {
        lastLightMapX = OpenGlHelper.lastBrightnessX;
        lastLightMapY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void enableLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastLightMapX, (float)lastLightMapY);
    }

    public static void DrawMultilineInfo(List infos, int x, int y, int maxLines, int maxLineWidth, int color) {
        try {
            int linesCounter = 0;
            String infoText = StringUtils.join((Iterable)infos, (String)"\n");
            fontRenderer.func_78279_b(infoText, x, y + linesCounter * 10, maxLineWidth, color);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void DrawMultilineInfoCentered(List infos, int x, int y, int maxLines, int maxLineWidth, int color) {
        try {
            for (int i = 0; i < Math.min(maxLines, infos.size()); ++i) {
                String info = infos.get(i).toString();
                info = info.substring(0, Math.min(maxLineWidth, info.length()));
                int width = fontRenderer.func_78256_a(info);
                fontRenderer.func_175063_a(info, (float)(x - width / 2), (float)(y + i * 10), color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static void translateToWorlds(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void rotateTo(Entity viewer) {
        GlStateManager.func_179114_b((float)viewer.field_70177_z, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewer.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void tessalateParticle(Entity viewer, TextureAtlasSprite particleIcon, double scale, Vec3d position, Color color) {
        RenderUtils.tessalateParticle(viewer, particleIcon, scale, position, color.getFloatR(), color.getFloatG(), color.getFloatB(), color.getFloatA());
    }

    public static void tessalateParticle(Entity viewer, TextureAtlasSprite particleIcon, double scale, Vec3d position, float r, float g, float b, float a) {
        float f1 = MathHelper.func_76134_b((float)(viewer.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(viewer.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(viewer.field_70125_A * ((float)Math.PI / 180)));
        float uMin = particleIcon.func_94209_e();
        float uMax = particleIcon.func_94212_f();
        float vMin = particleIcon.func_94206_g();
        float vMax = particleIcon.func_94210_h();
        float x = (float)position.field_72450_a;
        float y = (float)position.field_72448_b;
        float z = (float)position.field_72449_c;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181662_b((double)x - (double)f1 * scale - (double)f3 * scale, (double)y - (double)f5 * scale, (double)z - (double)f2 * scale - (double)f4 * scale).func_187315_a((double)uMax, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b((double)x - (double)f1 * scale + (double)f3 * scale, (double)y + (double)f5 * scale, (double)z - (double)f2 * scale + (double)f4 * scale).func_187315_a((double)uMax, (double)vMin).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b((double)x + (double)f1 * scale + (double)f3 * scale, (double)y + (double)f5 * scale, (double)z + (double)f2 * scale + (double)f4 * scale).func_187315_a((double)uMin, (double)vMin).func_181666_a(r, g, b, a).func_181675_d();
        wr.func_181662_b((double)x + (double)f1 * scale - (double)f3 * scale, (double)y - (double)f5 * scale, (double)z + (double)f2 * scale - (double)f4 * scale).func_187315_a((double)uMin, (double)vMax).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void enable3DRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
    }

    public static void enable2DRender() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179089_o();
    }

    public static void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, int widthU, int heightV, float texW, float texH, float zLevel) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.tessalateSizedModelRect(x, y, u, v, width, height, widthU, heightV, texW, texH, zLevel);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void tessalateSizedModelRect(int x, int y, int u, int v, int width, int height, int widthU, int heightV, float texW, float texH, float zLevel) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)u * texU), (double)((float)(v + heightV) * texV)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + widthU) * texU), (double)((float)(v + heightV) * texV)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(u + widthU) * texU), (double)((float)v * texV)).func_181675_d();
        wr.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)u * texU), (double)((float)v * texV)).func_181675_d();
    }

    public static void drawString(String string, int x, int y, Color color, float multiply) {
        RenderUtils.drawString(Minecraft.func_71410_x().field_71466_p, string, x, y, color, multiply);
    }

    public static void drawString(FontRenderer fontRenderer, String string, int x, int y, Color color, float multiply) {
        fontRenderer.func_78276_b(string, x, y, color.multiplyWithoutAlpha(multiply).getColor());
    }

    public static void beginStencil() {
        GL11.glEnable((int)2960);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        GlStateManager.func_179086_m((int)1024);
    }

    public static void beginDrawingDepthMask() {
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179151_a((double)1.0);
        GlStateManager.func_179143_c((int)513);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179090_x();
    }

    public static void beginDepthMasking() {
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)516);
    }

    public static void endStencil() {
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilMask((int)0);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GL11.glDisable((int)2960);
    }

    public static void endDepthMask() {
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179097_i();
    }

    public static void drawShip(double x, double y, double z, double size) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(x - size, y, z).func_181675_d();
        wr.func_181662_b(x + size, y, z - size).func_181675_d();
        wr.func_181662_b(x + size, y, z + size);
        wr.func_181662_b(x - size, y, z).func_181675_d();
        wr.func_181662_b(x + size, y, z + size).func_181675_d();
        wr.func_181662_b(x + size, y + size, z).func_181675_d();
        wr.func_181662_b(x - size, y, z).func_181675_d();
        wr.func_181662_b(x + size, y + size, z).func_181675_d();
        wr.func_181662_b(x + size, y, z - size).func_181675_d();
        wr.func_181662_b(x + size, y, z - size).func_181675_d();
        wr.func_181662_b(x + size, y + size, z).func_181675_d();
        wr.func_181662_b(x + size, y, z + size).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void rotateTowards(Vec3d from, Vec3d to, Vec3d up) {
        double dot = from.func_72430_b(to);
        if (Math.abs(dot - -1.0) < Double.MIN_VALUE) {
            GlStateManager.func_179114_b((float)180.0f, (float)((float)up.field_72450_a), (float)((float)up.field_72448_b), (float)((float)up.field_72449_c));
        }
        if (Math.abs(dot - 1.0) < Double.MIN_VALUE) {
            return;
        }
        double rotAngle = Math.acos(dot);
        Vec3d rotAxis = from.func_72431_c(to).func_72432_b();
        GlStateManager.func_179114_b((float)((float)(rotAngle * 57.29577951308232)), (float)((float)rotAxis.field_72450_a), (float)((float)rotAxis.field_72448_b), (float)((float)rotAxis.field_72449_c));
    }

    public static void renderIcon(double x, double y, double z, TextureAtlasSprite icon, int width, int height) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(x, y + (double)height, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_181675_d();
        wr.func_181662_b(x + (double)width, y + (double)height, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_181675_d();
        wr.func_181662_b(x + (double)width, y, z).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_181675_d();
        wr.func_181662_b(x, y, z).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

