/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FeatureRightClickHarvest {
    public static final List<String> BLACKLIST = new ArrayList<String>();
    private static final Method GET_SEED = ReflectionHelper.findMethod(BlockCrops.class, (String)"getSeed", (String)"func_149866_i", (Class[])new Class[0]);

    public static void configure(Configuration config) {
        ConfigCategory category = config.getCategory("features");
        String[] values = config.get(category.getName(), "right_click_harvest_blacklist", new String[0]).getStringList();
        category.get("right_click_harvest_blacklist").setComment("Here you can blacklist crops from being right-click-harvestable.\nSyntax: modid:blockid");
        for (String value : values) {
            BLACKLIST.add(value);
        }
    }

    @SubscribeEvent
    public void onRightClickCrop(PlayerInteractEvent.RightClickBlock event) {
        BlockCrops crop;
        if (!ModConfig.confRightClickHarvest) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (BLACKLIST.contains(state.func_177230_c().getRegistryName().toString())) {
            return;
        }
        if (state.func_177230_c() instanceof BlockCrops && (crop = (BlockCrops)state.func_177230_c()).func_185525_y(state) && this.getSeed((Block)crop) != null) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)event.getItemStack());
            NonNullList drops = NonNullList.func_191196_a();
            crop.getDrops(drops, (IBlockAccess)event.getWorld(), event.getPos(), state, fortune);
            ListIterator itr = drops.listIterator();
            while (itr.hasNext()) {
                ItemStack drop = (ItemStack)itr.next();
                Item seed = drop.func_77973_b();
                if (drop.func_190926_b() || seed == null || seed != this.getSeed((Block)crop)) continue;
                drop.func_190918_g(1);
                break;
            }
            event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
            if (!event.getWorld().field_72995_K) {
                for (ItemStack drop : drops) {
                    if (drop.func_190926_b()) continue;
                    BlockCrops.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)drop);
                }
                ForgeEventFactory.fireBlockHarvesting((List)drops, (World)event.getWorld(), (BlockPos)event.getPos(), (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)event.getEntityPlayer());
                event.getWorld().func_175656_a(event.getPos(), crop.func_185528_e(0));
            }
        }
    }

    public Item getSeed(Block block) {
        try {
            return (Item)GET_SEED.invoke((Object)block, new Object[0]);
        }
        catch (Exception e) {
            PickleTweaks.LOGGER.error("Unable to load seed from crop {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }
}

