/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.MathTool;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryManipulation {
    private static IProperty AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    private static final Set<IProperty> SAFE_PROPERTIES = ImmutableSet.of((Object)BlockSlab.field_176554_a, (Object)BlockStairs.field_176308_b, (Object)BlockLog.field_176299_a, (Object)AXIS, (Object)BlockDirectional.field_176387_N, (Object)BlockStairs.field_176309_a, (Object[])new IProperty[]{BlockTrapDoor.field_176285_M, BlockTorch.field_176596_a, BlockStairs.field_176310_M, BlockLever.field_176360_a, BlockLever.field_176359_b, BlockRedstoneRepeater.field_176410_b, BlockStoneSlab.field_176556_M, BlockWoodSlab.field_176557_b, BlockDoubleWoodSlab.field_176557_b, BlockDoubleStoneSlab.field_176556_M});
    private static final Set<IProperty> SAFE_PROPERTIES_COPY_PASTE = ImmutableSet.builder().addAll(SAFE_PROPERTIES).addAll((Iterable)ImmutableSet.of((Object)BlockDoubleWoodSlab.field_176557_b, (Object)BlockRail.field_176565_b, (Object)BlockRailPowered.field_176568_b)).build();

    public static ItemStack giveItem(ItemStack targetStack, EntityPlayer player, World world) {
        ItemStack target;
        if (player.field_71075_bZ.field_75098_d) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = target = targetStack.func_77973_b() instanceof ConstructionPaste ? InventoryManipulation.addPasteToContainer(player, targetStack) : targetStack;
        if (target.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack tool = GadgetGeneric.getGadget(player);
        for (Pair<InventoryType, IItemHandler> inv : InventoryManipulation.collectInventories(tool, player, world, NetworkIO.Operation.INSERT)) {
            target = InventoryManipulation.insertIntoInventory((IItemHandler)inv.getValue(), target, (InventoryType)((Object)inv.getKey()));
            if (!target.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return target;
    }

    private static ItemStack insertIntoInventory(IItemHandler inventory, ItemStack target, InventoryType type) {
        ItemStack containerItem;
        int i;
        if (inventory == null) {
            return target;
        }
        for (i = 0; i < inventory.getSlots(); ++i) {
            int insertCount;
            if (target.func_190926_b()) {
                return target;
            }
            containerItem = inventory.getStackInSlot(i);
            if (containerItem.func_190926_b() || containerItem.func_77973_b() != target.func_77973_b() || containerItem.func_77960_j() != target.func_77960_j()) continue;
            int n = insertCount = target.func_190916_E() - containerItem.func_190916_E() > containerItem.func_77976_d() ? target.func_190916_E() - containerItem.func_190916_E() : target.func_190916_E();
            if (containerItem.func_190916_E() + insertCount > target.func_77976_d()) continue;
            ItemStack insertStack = containerItem.func_77946_l();
            insertStack.func_190920_e(insertCount);
            inventory.insertItem(i, insertStack, false);
            target.func_190918_g(insertCount);
        }
        for (i = 0; i < inventory.getSlots() && !target.func_190926_b(); ++i) {
            containerItem = inventory.getStackInSlot(i);
            if (!containerItem.func_190926_b() || !inventory.isItemValid(i, target) || type == InventoryType.PLAYER && i == 40) continue;
            ItemStack insertStack = target.func_77946_l();
            insertStack.func_190920_e(target.func_190916_E() > target.func_77976_d() ? containerItem.func_77976_d() : target.func_190916_E());
            ItemStack stack = inventory.insertItem(i, insertStack, true);
            if (stack.func_190916_E() == insertStack.func_190916_E()) continue;
            inventory.insertItem(i, insertStack, false);
            target.func_190918_g(insertStack.func_190916_E());
        }
        return target;
    }

    public static boolean useItem(ItemStack target, EntityPlayer player, int amountRequired, World world) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int amountLeft = amountRequired;
        for (Pair<InventoryType, IItemHandler> inv : InventoryManipulation.collectInventories(GadgetGeneric.getGadget(player), player, world, NetworkIO.Operation.EXTRACT)) {
            if ((amountLeft -= InventoryManipulation.extractFromInventory((IItemHandler)inv.getValue(), target, amountLeft)) > 0) continue;
            return true;
        }
        return amountLeft < amountRequired;
    }

    private static int extractFromInventory(IItemHandler inventory, ItemStack target, int amountRequired) {
        int amountSaturated = 0;
        if (inventory == null) {
            return amountSaturated;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack containerItem = inventory.getStackInSlot(i);
            if (containerItem.func_77973_b() == target.func_77973_b() && containerItem.func_77960_j() == target.func_77960_j()) {
                ItemStack stack = inventory.extractItem(i, amountRequired, false);
                amountSaturated += stack.func_190916_E();
            }
            if (amountSaturated >= amountRequired) break;
        }
        return amountSaturated;
    }

    private static List<Pair<InventoryType, IItemHandler>> collectInventories(ItemStack gadget, EntityPlayer player, World world, NetworkIO.Operation operation) {
        IItemHandler currentInv;
        ArrayList<Pair<InventoryType, IItemHandler>> inventories = new ArrayList<Pair<InventoryType, IItemHandler>>();
        IItemHandler linked = GadgetUtils.getRemoteInventory(gadget, world, player, operation);
        if (linked != null) {
            inventories.add(Pair.of((Object)((Object)InventoryType.LINKED), (Object)linked));
        }
        if ((currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) {
            return inventories;
        }
        inventories.add((Pair<InventoryType, IItemHandler>)Pair.of((Object)((Object)InventoryType.PLAYER), (Object)currentInv));
        for (int i = 0; i < currentInv.getSlots(); ++i) {
            ItemStack itemStack = currentInv.getStackInSlot(i);
            if (!itemStack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            inventories.add((Pair<InventoryType, IItemHandler>)Pair.of((Object)((Object)InventoryType.OTHER), (Object)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
        return inventories;
    }

    public static int countItem(ItemStack itemStack, EntityPlayer player, World world) {
        return InventoryManipulation.countItem(itemStack, player, (ItemStack tool, ItemStack stack) -> {
            IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world, player);
            return remoteInventory == null ? 0 : InventoryManipulation.countInContainer(remoteInventory, stack.func_77973_b(), stack.func_77960_j());
        });
    }

    public static int countItem(ItemStack itemStack, EntityPlayer player, IRemoteInventoryProvider remoteInventory) {
        if (player.field_71075_bZ.field_75098_d) {
            return Integer.MAX_VALUE;
        }
        long count = remoteInventory.countItem(GadgetGeneric.getGadget(player), itemStack);
        IItemHandler currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (currentInv == null) {
            return 0;
        }
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), currentInv);
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(player);
        if (slots.size() == 0 && invContainers.size() == 0 && count == 0L) {
            return 0;
        }
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                count += (long)InventoryManipulation.countInContainer(container, itemStack.func_77973_b(), itemStack.func_77960_j());
            }
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stackInSlot = currentInv.getStackInSlot(slot);
            count += (long)stackInSlot.func_190916_E();
        }
        return MathTool.longToInt(count);
    }

    public static IntList countItems(List<ItemStack> items, EntityPlayer player) {
        IntArrayList result = new IntArrayList();
        for (ItemStack item : items) {
            result.add(InventoryManipulation.countItem(item, player, player.field_70170_p));
        }
        return result;
    }

    public static int countPaste(EntityPlayer player) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return Integer.MAX_VALUE;
        }
        IItemHandler currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (currentInv == null) {
            return 0;
        }
        long count = 0L;
        ConstructionPaste item = ModItems.constructionPaste;
        List<Integer> slots = InventoryManipulation.findItem(item, 0, currentInv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack stackInSlot = currentInv.getStackInSlot(slot);
                count += (long)stackInSlot.func_190916_E();
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, currentInv)).size() > 0) {
            for (int slot : containerSlots) {
                ItemStack stackInSlot = currentInv.getStackInSlot(slot);
                if (!(stackInSlot.func_77973_b() instanceof GenericPasteContainer)) continue;
                count += (long)GenericPasteContainer.getPasteAmount(stackInSlot);
            }
        }
        return MathTool.longToInt(count);
    }

    public static ItemStack addPasteToContainer(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        IItemHandler currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (currentInv == null) {
            return itemStack;
        }
        List<Integer> slots = InventoryManipulation.findItemClass(GenericPasteContainer.class, currentInv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, GenericPasteContainer.getPasteAmount(currentInv.getStackInSlot(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator<Map.Entry> comparator = Comparator.comparing(Map.Entry::getValue);
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry : list) {
            ItemStack containerStack = currentInv.getStackInSlot(((Integer)entry.getKey()).intValue());
            int maxAmount = ((GenericPasteContainer)containerStack.func_77973_b()).getMaxCapacity();
            int pasteInContainer = GenericPasteContainer.getPasteAmount(containerStack);
            int freeSpace = maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            GenericPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    public static boolean usePaste(EntityPlayer player, int count) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IItemHandler currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (currentInv == null) {
            return false;
        }
        List<Integer> slots = InventoryManipulation.findItem(ModItems.constructionPaste, 0, currentInv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack pasteStack = currentInv.getStackInSlot(slot);
                if (pasteStack.func_190916_E() < count) continue;
                pasteStack.func_190918_g(count);
                return true;
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, currentInv)).size() > 0) {
            for (int slot : containerSlots) {
                int pasteAmt;
                ItemStack containerStack = currentInv.getStackInSlot(slot);
                if (!(containerStack.func_77973_b() instanceof GenericPasteContainer) || (pasteAmt = GenericPasteContainer.getPasteAmount(containerStack)) < count) continue;
                GenericPasteContainer.setPasteAmount(containerStack, pasteAmt - count);
                return true;
            }
        }
        return false;
    }

    private static List<IItemHandler> findInvContainers(EntityPlayer player) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        IItemHandler currentInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (currentInv == null) {
            return containers;
        }
        for (int i = 0; i < currentInv.getSlots(); ++i) {
            ItemStack itemStack = currentInv.getStackInSlot(i);
            if (!itemStack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            containers.add((IItemHandler)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item, int meta) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item || tempItem.func_77960_j() != meta) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, int meta, IItemHandler itemHandler) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (itemHandler == null) {
            return slots;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77960_j()) continue;
            slots.add(i);
        }
        return slots;
    }

    private static List<Integer> findItemClass(Class c, IItemHandler itemHandler) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_180651_a(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static IBlockState getSpecificStates(IBlockState originalState, World world, EntityPlayer player, BlockPos pos, ItemStack tool) {
        IBlockState placeState;
        ItemStack item;
        Block block = originalState.func_177230_c();
        try {
            item = block.getPickBlock(originalState, null, world, pos, player);
        }
        catch (Exception ignored) {
            item = InventoryManipulation.getSilkTouchDrop(originalState);
        }
        int meta = item.func_77960_j();
        try {
            placeState = originalState.func_177230_c().getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, meta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
        }
        catch (Exception var8) {
            placeState = originalState.func_177230_c().func_176223_P();
        }
        for (IProperty prop : placeState.func_177227_a()) {
            if (tool.func_77973_b() instanceof GadgetCopyPaste) {
                if (!SAFE_PROPERTIES_COPY_PASTE.contains(prop)) continue;
                placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
                continue;
            }
            if (!SAFE_PROPERTIES.contains(prop)) continue;
            placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
        }
        return placeState;
    }

    public static ItemStack getStackInEitherHand(EntityPlayer player, Class<?> itemClass) {
        ItemStack mainHand = player.func_184614_ca();
        if (itemClass.isInstance(mainHand.func_77973_b())) {
            return mainHand;
        }
        ItemStack offhand = player.func_184592_cb();
        if (itemClass.isInstance(offhand.func_77973_b())) {
            return offhand;
        }
        return ItemStack.field_190927_a;
    }

    public static String formatItemCount(int maxSize, int count) {
        int stacks = count / maxSize;
        int leftover = count % maxSize;
        if (stacks == 0) {
            return String.valueOf(leftover);
        }
        return stacks + "\u00d7" + maxSize + "+" + leftover;
    }

    public static interface IRemoteInventoryProvider {
        public int countItem(ItemStack var1, ItemStack var2);
    }

    private static enum InventoryType {
        PLAYER,
        LINKED,
        OTHER;

    }
}

